/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoserClassLoader
extends ClassLoader {
    private static final Log log = LogFactory.getLog(CoserClassLoader.class);
    protected File validatorsDirectory;

    public CoserClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void setValidatorsDirectory(File validatorsDirectory) {
        this.validatorsDirectory = validatorsDirectory;
    }

    @Override
    public URL getResource(String name) {
        URL result = null;
        if (name.matches("/fr/ifremer/coser/.+\\.xml")) {
            File valFile = new File(this.validatorsDirectory, name);
            if (valFile.isFile()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Locating resources " + name + " to " + valFile.getAbsolutePath()));
                }
                try {
                    result = valFile.toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException("Can't get validator url", ex);
                }
            }
            if (result == null) {
                result = super.getResource("validators" + name);
            }
        }
        if (result == null) {
            result = super.getResource(name);
        }
        return result;
    }
}

