/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.persistence;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DaoUtils {
    protected static final String LIKE = "TRANSLATE(LOWER( %s ),'\u00e1\u00e0\u00e2\u00e3\u00e4\u00e5\u0101\u0103\u0105\u00e8\u00e9\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011b\u00ec\u00ed\u00ee\u00ef\u00ec\u0129\u012b\u012d\u1e29\u00f3\u00f4\u00f5\u00f6\u014d\u014f\u0151\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u00e4\u00e0\u00e1\u00e2\u00e3\u00e5\u00e6\u00e7\u0107\u0109\u010d\u00f6\u00f2\u00f3\u00f4\u00f5\u00f8\u00fc\u00f9\u00fa\u00fb\u00df\u00e9\u00e8\u00ea\u00eb\u00fd\u00f1\u00ee\u00ec\u00ed\u00ef\u015f','aaaaaaaaaeeeeeeeeeeiiiiiiiihooooooouuuuuuuuaaaaaaeccccoooooouuuuseeeeyniiiis')like LOWER( %s )";

    public static String getFieldLikeInsensitive(String field1, String field2) {
        String query = String.format(LIKE, field1, field2);
        return query;
    }

    public static String addQueryAttribute(Map<String, Object> args, String entityAttributeName, Object value) {
        String queryAttributeName;
        String baseAttributeName = entityAttributeName.replaceAll("[.]", "_");
        int index = 0;
        do {
            queryAttributeName = baseAttributeName + index;
            ++index;
        } while (args.containsKey(queryAttributeName));
        args.put(queryAttributeName, value);
        return queryAttributeName;
    }

    protected static String getQueryForAttributeLike(String entityAlias, String entityAttributeName, Map<String, Object> args, String likeValue, String operator) {
        String alias = StringUtils.isBlank((CharSequence)entityAlias) ? "" : entityAlias + ".";
        String queryAttributeName = DaoUtils.addQueryAttribute(args, entityAttributeName, StringUtils.stripAccents((String)likeValue));
        String result = " " + operator + " " + DaoUtils.getFieldLikeInsensitive(alias + entityAttributeName, ":" + queryAttributeName);
        return result;
    }

    public static String getQueryForAttributeEquals(String entityAlias, String entityAttributeName, Map<String, Object> args, Object value, String operator) {
        String result = "";
        if (value != null) {
            String alias = StringUtils.isBlank((CharSequence)entityAlias) ? "" : entityAlias + ".";
            String queryAttributeName = DaoUtils.addQueryAttribute(args, entityAttributeName, value);
            result = result + String.format(" %s %s = :%s", operator, alias + entityAttributeName, queryAttributeName);
        }
        return result;
    }

    public static String andAttributeEquals(String entityAlias, String entityAttributeName, Map<String, Object> args, Object value) {
        String result = DaoUtils.getQueryForAttributeEquals(entityAlias, entityAttributeName, args, value, "AND");
        return result;
    }

    public static String orAttributeEquals(String entityAlias, String entityAttributeName, Map<String, Object> args, Object value) {
        String result = DaoUtils.getQueryForAttributeEquals(entityAlias, entityAttributeName, args, value, "OR");
        return result;
    }

    public static String andAttributeLike(String entityAlias, String entityAttributeName, Map<String, Object> args, String value) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)value)) {
            result = DaoUtils.getQueryForAttributeLike(entityAlias, entityAttributeName, args, "%" + value + "%", "AND");
        }
        return result;
    }

    public static String orAttributeLike(String entityAlias, String entityAttributeName, Map<String, Object> args, String value) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)value)) {
            result = DaoUtils.getQueryForAttributeLike(entityAlias, entityAttributeName, args, "%" + value + "%", "OR");
        }
        return result;
    }

    protected static String getQueryForAttributeContains(String entityAlias, String entityAttributeName, Map<String, Object> args, Object value, String operator) {
        String result = "";
        String alias = StringUtils.isBlank((CharSequence)entityAlias) ? "" : entityAlias + ".";
        String queryAttributeName = DaoUtils.addQueryAttribute(args, entityAttributeName, value);
        result = result + String.format(" %s :%s in elements( %s )", operator, queryAttributeName, alias + entityAttributeName);
        return result;
    }

    public static String andAttributeContains(String entityAlias, String entityAttributeName, Map<String, Object> args, Object value) {
        String result = DaoUtils.getQueryForAttributeContains(entityAlias, entityAttributeName, args, value, "AND");
        return result;
    }
}

