/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.indexation;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;

public class TikaUtils {
    private static final Log log = LogFactory.getLog(TikaUtils.class);
    public static final List<String> READABLE_TEXT_MIMETYPES = Arrays.asList("text/plain", "application/pdf", "application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.presentation", "application/msword", "application/mspowerpoint", "application/powerpoint", "application/vnd.ms-powerpoint", "text/html");
    private static final Tika tika = new Tika();

    public static String getFileContent(String filePath) {
        String fileContent;
        block5: {
            fileContent = "";
            File file = new File(filePath);
            try {
                String mimeType = tika.detect(file);
                if (StringUtils.isNotBlank((CharSequence)mimeType) && READABLE_TEXT_MIMETYPES.contains(mimeType.toLowerCase())) {
                    fileContent = tika.parseToString(file);
                }
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Unable to read file " + filePath), (Throwable)e);
                }
            }
            catch (TikaException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)("Unable to get file content from Tika : " + filePath), (Throwable)e);
            }
        }
        return fileContent;
    }

    public static String getFileMimeType(String filePath) {
        String mimeType = tika.detect(filePath);
        return mimeType;
    }
}

