/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: DateParser.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://tchemit@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3/vradi-services/src/main/java/com/jurismarches/vradi/services/managers/DateParser.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package com.jurismarches.vradi.services.managers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Parseur de date utilisé lors de l'import des flux.
 *
 * @author schorlet
 * @version $Revision: 1715 $ $Date: 2010-10-27 21:21:28 +0200 (mer., 27 oct. 2010) $
 * @since 10 mars 2010 12:02:21
 */
public class DateParser {

    static private final Log log = LogFactory.getLog(DateParser.class);

    private static final String ND1 = "N.D.";

    private static final String ND2 = "---";

    private static final TimeZone timezone = TimeZone.getTimeZone("GMT");

    //public static final SimpleDateFormat defaultFormat = new SimpleDateFormat();
    // FIXME EC20100510 fix locale dependant tests
    public static final SimpleDateFormat defaultFormat = new SimpleDateFormat("", Locale.FRANCE);

    public static final SimpleDateFormat usFormat = new SimpleDateFormat("", Locale.US);

    /**
     * formats frequemments rencontrés.
     */
    public static final String[] frequentMasks = new String[] {
        // 10 avril 2010, à 12 heures
        "dd MMMM yyyy', à' HH 'heures'",
        // 5 mai 2010, à 12:00.
        "dd MMMM yyyy', à' HH:mm'.'",
        // 2 avril 2010, à 15 h 30
        "dd MMMM yyyy', à' HH 'h' mm",
        // 2010-04-02 12:00:00
        "yyyy-MM-dd HH:mm:ss",
    };
        
    /**
     * autres formats et variantes.
     */
    public static final String[] variantMasks = new String[] {
        // 23 mars 2010
        "dd MMMM yyyy",
        // 23 mars 2010.
        "dd MMMM yyyy'.'",
        
        // 10/03/2010 à 12:00
        "dd/MM/yyyy 'à' HH:mm",
        // 10/03/2010 à 12:00.
        "dd/MM/yyyy 'à' HH:mm'.'",
        // 10/03/2010 à 12 heures
        "dd/MM/yyyy 'à' HH 'heures'",
        // 10/03/2010
        "dd/MM/yyyy",
        
        // 2010-04-02 12:00:00
        "yyyy-MM-dd HH:mm:ss",
        // 2010-04-02 12:00
        "yyyy-MM-dd HH:mm",
        // 2008-12-21
        "yyyy-MM-dd",
        
        // 10 avril 2010 à 12 heures
        "dd MMMM yyyy 'à' HH 'heures'",
        
        // 5 mai 2010 à 12:00
        "dd MMMM yyyy 'à' HH:mm",
        // 5 mai 2010 à 12:00.
        "dd MMMM yyyy 'à' HH:mm'.'",
        // 5 mai 2010, à 12:00
        "dd MMMM yyyy', à' HH:mm",
        
        // 2 avril 2010 à 15 h 30
        "dd MMMM yyyy 'à' HH 'h' mm",
        // 2 avril 2010 à 15h30
        "dd MMMM yyyy 'à' HH'h'mm",
        // 2 avril 2010, à 15h30
        "dd MMMM yyyy', à' HH'h'mm",
        
        // 1.e.r avril 2010, à 17 heures
        "'1.e.r' MMMM yyyy', à' HH 'heures'",
        // 1.e.r avril 2010 à 17 heures
        "'1.e.r' MMMM yyyy 'à' HH 'heures'",
        // 1er avril 2010, à 17 heures
        "'1er' MMMM yyyy', à' HH 'heures'",
        // 1er avril 2010 à 17 heures
        "'1er' MMMM yyyy 'à' HH 'heures'"
    };
    
    /**
     * formats en Locale.US.
     */
    public static final String[] usMasks = new String[] {
        // Sun, 29 Nov 2009 22:07:29 +0100
        "E, d MMM yyyy HH:mm:ss Z"
    };
    
    public static Date parse(String source) {
        if (source == null) {
            return null;
        }
        
        String sourcetrim = source.trim();
        if (sourcetrim.isEmpty() || ND1.equals(sourcetrim) || ND2.equals(sourcetrim)) {
            return null;
        }
        
        Date date = parse(source, defaultFormat, frequentMasks);
        if (date == null) {
            date = parse(source, defaultFormat, variantMasks);
            
            if (date == null) {
                date = parse(source, usFormat, usMasks);
            }
        }
        
        return date;
    }
    
    public static Date parse(String source, SimpleDateFormat dateFormat, String... masks) {
        dateFormat.setTimeZone(timezone);
        for (String mask : masks) {
            try {
                dateFormat.applyPattern(mask);
                Date date = dateFormat.parse(source);
                return date;
            } catch (ParseException eee) {
                if (log.isWarnEnabled()) {
                    log.warn("Can't parse date", eee);
                }
            }
        }
        
        return null;
    }
}
