/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.undo.UndoManager;
import org.bounce.text.xml.XMLEditorKit;
import org.webharvest.gui.BreakpointCollection;
import org.webharvest.gui.BreakpointInfo;
import org.webharvest.gui.GuiUtils;
import org.webharvest.gui.XmlEditorScrollPane;
import org.webharvest.utils.CommonUtil;

public class XmlTextPane
extends JEditorPane {
    private UndoManager undoManager = new UndoManager();
    private DeleteLineAction deleteLineAction = new DeleteLineAction();
    private TabAction tabAction = new TabAction();
    private ShiftTabAction shiftTabAction = new ShiftTabAction();
    private DuplicateAction duplicateAction = new DuplicateAction();
    private CommentAction commentAction = new CommentAction();
    private BreakpointCollection breakpoints = new BreakpointCollection();
    private int errorLine = -1;
    private int markerLine = -1;
    private int stopDebugLine = -1;
    private Point lastClickPoint;

    public XmlTextPane() {
        XMLEditorKit kit = new XMLEditorKit(true, this);
        kit.setLineWrappingEnabled(false);
        kit.setStyle("element-name", new Color(128, 0, 0), 0);
        kit.setStyle("element-value", new Color(0, 0, 0), 0);
        kit.setStyle("element-prefix", new Color(128, 0, 0), 0);
        kit.setStyle("attribute-name", new Color(255, 0, 0), 0);
        kit.setStyle("attribute-value", new Color(0, 0, 0), 0);
        kit.setStyle("attribute-prefix", new Color(128, 0, 0), 0);
        kit.setStyle("namespace-name", new Color(102, 102, 102), 0);
        kit.setStyle("namespace-value", new Color(0, 51, 51), 0);
        kit.setStyle("namespace-prefix", new Color(102, 102, 102), 0);
        kit.setStyle("Entity", new Color(0, 0, 0), 0);
        kit.setStyle("Comment", new Color(153, 153, 153), 0);
        kit.setStyle("CData", new Color(0, 0, 0), 0);
        kit.setStyle("Special", new Color(0, 0, 0), 0);
        this.setEditorKit(kit);
        this.setFont(new Font("Monospaced", 0, 12));
        this.registerKeyboardAction(this.shiftTabAction, KeyStroke.getKeyStroke(9, 1), 0);
        this.registerKeyboardAction(this.deleteLineAction, KeyStroke.getKeyStroke(89, 2), 0);
        ActionListener escAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlTextPane.this.clearMarkerLine();
                XmlTextPane.this.clearErrorLine();
            }
        };
        this.registerKeyboardAction(escAction, KeyStroke.getKeyStroke(27, 0), 0);
        this.getActionMap().put(this.tabAction.getValue("Name"), this.tabAction);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public UndoableEditListener getUndoManager() {
        return this.undoManager;
    }

    public boolean hasSelection() {
        String selectedText = this.getSelectedText();
        return selectedText != null && !"".equals(selectedText);
    }

    public void duplicate() {
        this.duplicateAction.execute();
    }

    public void comment() {
        this.commentAction.execute();
    }

    public void toggleBreakpoint() {
        if (this.isEnabled()) {
            try {
                int position = this.lastClickPoint != null ? this.viewToModel(this.lastClickPoint) : this.getCaretPosition();
                this.lastClickPoint = null;
                if (position >= 0) {
                    String textToCaret = this.getDocument().getText(0, position);
                    int lineCount = 0;
                    for (int i = 0; i < textToCaret.length(); ++i) {
                        if (textToCaret.charAt(i) != '\n') continue;
                        ++lineCount;
                    }
                    if (this.breakpoints.isThereBreakpoint(lineCount)) {
                        this.breakpoints.removeBreakpoint(lineCount);
                    } else {
                        this.breakpoints.addBreakpoint(new BreakpointInfo(lineCount));
                    }
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            Component parent = GuiUtils.getParentOfType(this, XmlEditorScrollPane.class);
            if (parent != null) {
                ((XmlEditorScrollPane)parent).onDocChanged();
            }
            this.repaint();
        }
    }

    private int getPositionForLine(int line) {
        int pos;
        String text = this.getText();
        int lineCount = 0;
        for (pos = 0; pos < text.length() && lineCount != line; ++pos) {
            if (text.charAt(pos) != '\n') continue;
            ++lineCount;
        }
        return pos;
    }

    private void scrollToLine(int line) {
        final int posForLine = this.getPositionForLine(line);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    XmlTextPane.this.scrollRectToVisible(XmlTextPane.this.modelToView(posForLine));
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public BreakpointCollection getBreakpoints() {
        return this.breakpoints;
    }

    public int getMarkerLine() {
        return this.markerLine;
    }

    public void setMarkerLine(int markerLine) {
        this.markerLine = markerLine;
        this.repaint();
        this.scrollToLine(markerLine);
    }

    public void clearMarkerLine() {
        this.markerLine = -1;
        this.repaint();
    }

    public int getErrorLine() {
        return this.errorLine;
    }

    public void setErrorLine(int errorLine) {
        this.errorLine = errorLine;
        this.repaint();
        this.scrollToLine(errorLine);
    }

    public void clearErrorLine() {
        this.errorLine = -1;
        this.repaint();
    }

    public int getStopDebugLine() {
        return this.stopDebugLine;
    }

    public void setStopDebugLine(int stopDebugLine) {
        this.stopDebugLine = stopDebugLine;
        this.repaint();
        this.scrollToLine(stopDebugLine);
    }

    public void clearStopDebugLine() {
        this.stopDebugLine = -1;
        this.repaint();
    }

    public void setLastClickPoint(Point lastClickPoint) {
        this.lastClickPoint = lastClickPoint;
    }

    public Point getLastClickPoint() {
        return this.lastClickPoint;
    }

    private class ShiftTabAction
    extends TextAction {
        public ShiftTabAction() {
            super("shift-tab-action");
        }

        private void outdentText(JTextComponent textComponent) throws BadLocationException {
            int newLineIndex;
            int tabSize = (Integer)textComponent.getDocument().getProperty("tabSize");
            String selectedText = textComponent.getSelectedText();
            int n = newLineIndex = selectedText != null ? selectedText.indexOf(10) : -1;
            if (newLineIndex >= 0) {
                int originalSelectionStart;
                int selectionStart = originalSelectionStart = textComponent.getSelectionStart();
                int selectionEnd = textComponent.getSelectionEnd();
                int lastNewLineBeforeSelection = textComponent.getText(0, selectionStart).lastIndexOf(10);
                int begin = lastNewLineBeforeSelection >= 0 ? lastNewLineBeforeSelection : 0;
                int end = selectionEnd;
                String text = textComponent.getText(begin, end - begin);
                if (lastNewLineBeforeSelection < 0) {
                    text = "\n" + text;
                }
                int len = text.length();
                StringBuffer out = new StringBuffer(len);
                for (int i = 0; i < len; ++i) {
                    int stripCount;
                    char ch = text.charAt(i);
                    out.append(ch);
                    if (ch != '\n' || i >= len - 1) continue;
                    char next = text.charAt(i + 1);
                    if (next == '\t') {
                        stripCount = 1;
                    } else {
                        for (stripCount = 0; stripCount < tabSize && i + 1 + stripCount < len && ((next = text.charAt(i + 1 + stripCount)) == ' ' || next == '\t'); ++stripCount) {
                        }
                    }
                    selectionEnd -= stripCount;
                    if (i + begin < originalSelectionStart - 1) {
                        selectionStart -= stripCount;
                    }
                    i += stripCount;
                }
                textComponent.select(begin, end);
                textComponent.replaceSelection(lastNewLineBeforeSelection < 0 ? out.toString().substring(1) : out.toString());
                textComponent.select(selectionStart, selectionEnd);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (!textComponent.isEditable() || !textComponent.isEnabled()) {
                return;
            }
            try {
                this.outdentText(textComponent);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    private class TabAction
    extends TextAction {
        public TabAction() {
            super("insert-tab");
        }

        private void indentText(JTextComponent textComponent) throws BadLocationException {
            int newLineIndex;
            String selectedText = textComponent.getSelectedText();
            int n = newLineIndex = selectedText != null ? selectedText.indexOf(10) : -1;
            if (newLineIndex >= 0) {
                int originalSelectionStart;
                int selectionStart = originalSelectionStart = textComponent.getSelectionStart();
                int selectionEnd = textComponent.getSelectionEnd();
                int lastNewLineBeforeSelection = textComponent.getText(0, selectionStart).lastIndexOf(10);
                int begin = lastNewLineBeforeSelection >= 0 ? lastNewLineBeforeSelection : 0;
                int end = selectionEnd++;
                String text = textComponent.getText(begin, end - begin);
                int len = text.length();
                StringBuffer out = new StringBuffer(len);
                if (lastNewLineBeforeSelection < 0) {
                    out.insert(0, '\t');
                    ++selectionStart;
                }
                for (int i = 0; i < len; ++i) {
                    char ch = text.charAt(i);
                    out.append(ch);
                    if (ch != '\n' || i >= len - 1) continue;
                    out.append("\t");
                    ++selectionEnd;
                    if (begin + i >= originalSelectionStart) continue;
                    ++selectionStart;
                }
                textComponent.select(begin, end);
                textComponent.replaceSelection(out.toString());
                textComponent.select(selectionStart, selectionEnd);
            } else {
                textComponent.replaceSelection("\t");
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (!textComponent.isEditable() || !textComponent.isEnabled()) {
                return;
            }
            try {
                this.indentText(textComponent);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    private class DeleteLineAction
    extends TextAction {
        public DeleteLineAction() {
            super("delete-line");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (!textComponent.isEditable() || !textComponent.isEnabled()) {
                return;
            }
            try {
                int fromIndex;
                int position = XmlTextPane.this.getCaretPosition();
                Document document = XmlTextPane.this.getDocument();
                int docLen = document.getLength();
                if (docLen == 0) {
                    return;
                }
                int toIndex = XmlTextPane.this.getText((fromIndex = Math.max(0, XmlTextPane.this.getText(0, position).lastIndexOf(10))) + 1, docLen - fromIndex - 1).indexOf(10);
                toIndex = toIndex < 0 ? docLen : fromIndex + toIndex + 1;
                String text = XmlTextPane.this.getText(fromIndex, toIndex - fromIndex);
                if (text.startsWith("\n") || toIndex >= docLen) {
                    document.remove(fromIndex, toIndex - fromIndex);
                } else {
                    document.remove(fromIndex, toIndex - fromIndex + 1);
                }
                int newPosition = 0;
                if (fromIndex > 0) {
                    newPosition = fromIndex + 1;
                }
                if (newPosition > (docLen = document.getLength())) {
                    newPosition = XmlTextPane.this.getText().lastIndexOf(10) + 1;
                }
                XmlTextPane.this.setCaretPosition(newPosition);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    private class CommentAction {
        private CommentAction() {
        }

        public void execute() {
            if (!XmlTextPane.this.isEditable() || !XmlTextPane.this.isEnabled()) {
                return;
            }
            int position = XmlTextPane.this.lastClickPoint != null ? XmlTextPane.this.viewToModel(XmlTextPane.this.lastClickPoint) : XmlTextPane.this.getCaretPosition();
            XmlTextPane.this.lastClickPoint = null;
            Document document = XmlTextPane.this.getDocument();
            String selectedText = XmlTextPane.this.getSelectedText();
            try {
                if (selectedText != null && !CommonUtil.isEmpty(selectedText)) {
                    String trimmed = selectedText.trim();
                    if (trimmed.startsWith("<!--") && trimmed.endsWith("-->")) {
                        StringBuffer buffer = new StringBuffer(selectedText);
                        int pos = buffer.indexOf("<!--");
                        buffer.delete(pos, pos + 4);
                        pos = buffer.lastIndexOf("-->");
                        buffer.delete(pos, pos + 3);
                        XmlTextPane.this.replaceSelection(buffer.toString());
                    } else {
                        String newSelection = "<!--" + selectedText + "-->";
                        XmlTextPane.this.replaceSelection(newSelection);
                    }
                } else {
                    String trimmed;
                    int fromIndex;
                    int docLen = document.getLength();
                    int toIndex = XmlTextPane.this.getText((fromIndex = Math.max(0, XmlTextPane.this.getText(0, position).lastIndexOf(10))) + 1, docLen - position).indexOf(10);
                    toIndex = toIndex < 0 ? docLen : fromIndex + toIndex;
                    String textToComment = XmlTextPane.this.getText(fromIndex, toIndex - fromIndex + 1);
                    if (textToComment.startsWith("\n")) {
                        textToComment = textToComment.substring(1);
                        ++fromIndex;
                    }
                    if (textToComment.endsWith("\n")) {
                        textToComment = textToComment.substring(0, textToComment.length() - 1);
                        --toIndex;
                    }
                    if ((trimmed = textToComment.trim()).startsWith("<!--") && trimmed.endsWith("-->")) {
                        int pos = textToComment.lastIndexOf("-->");
                        document.remove(fromIndex + pos, 3);
                        pos = textToComment.indexOf("<!--");
                        document.remove(fromIndex + pos, 4);
                    } else {
                        document.insertString(Math.min(toIndex + 1, docLen), "-->", null);
                        document.insertString(fromIndex, "<!--", null);
                    }
                }
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    private class DuplicateAction {
        private DuplicateAction() {
        }

        public void execute() {
            if (!XmlTextPane.this.isEditable() || !XmlTextPane.this.isEnabled()) {
                return;
            }
            try {
                int position = XmlTextPane.this.lastClickPoint != null ? XmlTextPane.this.viewToModel(XmlTextPane.this.lastClickPoint) : XmlTextPane.this.getCaretPosition();
                XmlTextPane.this.lastClickPoint = null;
                Document document = XmlTextPane.this.getDocument();
                String selectedText = XmlTextPane.this.getSelectedText();
                if (selectedText != null && !CommonUtil.isEmpty(selectedText)) {
                    int selectionEnd = XmlTextPane.this.getSelectionEnd();
                    document.insertString(selectionEnd, selectedText, null);
                    XmlTextPane.this.select(selectionEnd, selectionEnd + selectedText.length());
                } else {
                    int fromIndex;
                    int docLen = document.getLength();
                    int toIndex = XmlTextPane.this.getText((fromIndex = Math.max(0, XmlTextPane.this.getText(0, position).lastIndexOf(10))) + 1, docLen - fromIndex).indexOf(10);
                    toIndex = toIndex < 0 ? docLen : fromIndex + toIndex;
                    String textToDuplicate = XmlTextPane.this.getText(fromIndex, toIndex - fromIndex + 1);
                    if (!textToDuplicate.startsWith("\n")) {
                        textToDuplicate = "\n" + textToDuplicate;
                    }
                    if (textToDuplicate.endsWith("\n")) {
                        textToDuplicate = textToDuplicate.substring(0, textToDuplicate.length() - 1);
                    }
                    document.insertString(Math.min(docLen, toIndex + 1), textToDuplicate, null);
                    XmlTextPane.this.setCaretPosition(position + textToDuplicate.length());
                }
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }
}

