/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jgroups.conf.ProtocolParameter;

public class ProtocolData {
    private final Map mParameters = new HashMap();
    private final String mProtocolName;
    private final String mClassName;

    @Deprecated
    public ProtocolData(String protocolName, String description, String className, ProtocolParameter[] params) {
        this.mProtocolName = protocolName;
        this.mClassName = className;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                this.mParameters.put(params[i].getName(), params[i]);
            }
        }
    }

    public ProtocolData(String protocolName, String className, ProtocolParameter[] params) {
        this.mProtocolName = protocolName;
        this.mClassName = className;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                this.mParameters.put(params[i].getName(), params[i]);
            }
        }
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getProtocolName() {
        return this.mProtocolName;
    }

    @Deprecated
    public static String getDescription() {
        return "n/a";
    }

    public Map getParameters() {
        return this.mParameters;
    }

    @Deprecated
    public static boolean isOverride() {
        return false;
    }

    public ProtocolParameter[] getParametersAsArray() {
        ProtocolParameter[] result = new ProtocolParameter[this.mParameters.size()];
        Iterator it = this.mParameters.keySet().iterator();
        for (int i = 0; i < result.length; ++i) {
            String key = (String)it.next();
            result[i] = (ProtocolParameter)this.mParameters.get(key);
        }
        return result;
    }

    public void override(ProtocolParameter[] params) {
        for (int i = 0; i < params.length; ++i) {
            this.mParameters.put(params[i].getName(), params[i]);
        }
    }

    public String getProtocolString(boolean new_format) {
        return new_format ? this.getProtocolStringNewXml() : this.getProtocolString();
    }

    public String getProtocolString() {
        StringBuilder buf = new StringBuilder(this.mClassName);
        if (!this.mParameters.isEmpty()) {
            buf.append('(');
            Iterator i = this.mParameters.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                ProtocolParameter param = (ProtocolParameter)this.mParameters.get(key);
                buf.append(param.getParameterString());
                if (!i.hasNext()) continue;
                buf.append(';');
            }
            buf.append(')');
        }
        return buf.toString();
    }

    public String getProtocolStringNewXml() {
        StringBuilder buf = new StringBuilder(this.mClassName + ' ');
        if (!this.mParameters.isEmpty()) {
            Iterator i = this.mParameters.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                ProtocolParameter param = (ProtocolParameter)this.mParameters.get(key);
                buf.append(param.getParameterStringXml());
                if (!i.hasNext()) continue;
                buf.append(' ');
            }
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.mProtocolName.hashCode();
    }

    public boolean equals(Object another) {
        return another instanceof ProtocolData && this.getProtocolName().equals(((ProtocolData)another).getProtocolName());
    }
}

