/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;

class TermOffsetsTokenStream {
    TokenStream bufferedTokenStream = null;
    Token bufferedToken;
    int startOffset;
    int endOffset;

    public TermOffsetsTokenStream(TokenStream tstream) {
        this.bufferedTokenStream = tstream;
        this.startOffset = 0;
        this.bufferedToken = null;
    }

    public TokenStream getMultiValuedTokenStream(final int length) {
        this.endOffset = this.startOffset + length;
        return new TokenStream(){
            Token token;

            public Token next() throws IOException {
                while (true) {
                    if (TermOffsetsTokenStream.this.bufferedToken == null) {
                        TermOffsetsTokenStream.this.bufferedToken = TermOffsetsTokenStream.this.bufferedTokenStream.next();
                    }
                    if (TermOffsetsTokenStream.this.bufferedToken == null) {
                        return null;
                    }
                    if (TermOffsetsTokenStream.this.startOffset <= TermOffsetsTokenStream.this.bufferedToken.startOffset() && TermOffsetsTokenStream.this.bufferedToken.endOffset() <= TermOffsetsTokenStream.this.endOffset) {
                        this.token = TermOffsetsTokenStream.this.bufferedToken;
                        TermOffsetsTokenStream.this.bufferedToken = null;
                        this.token.setStartOffset(this.token.startOffset() - TermOffsetsTokenStream.this.startOffset);
                        this.token.setEndOffset(this.token.endOffset() - TermOffsetsTokenStream.this.startOffset);
                        return this.token;
                    }
                    if (TermOffsetsTokenStream.this.bufferedToken.endOffset() > TermOffsetsTokenStream.this.endOffset) {
                        TermOffsetsTokenStream.this.startOffset += length + 1;
                        return null;
                    }
                    TermOffsetsTokenStream.this.bufferedToken = null;
                }
            }
        };
    }
}

