/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceNotifier;

public class JGroupsNotifierTransporter
extends ReceiverAdapter
implements WikittyServiceNotifier.RemoteNotifierTransporter {
    private static Log log = LogFactory.getLog(JGroupsNotifierTransporter.class);
    public static final String WIKITTY_EVENT_JGROUPCHANNELNAME_OPTION = "wikitty.service.event.jgroupschannelname";
    protected WikittyServiceNotifier ws;
    protected JChannel channel;

    public JGroupsNotifierTransporter(WikittyServiceNotifier ws, Properties props) {
        this.ws = ws;
        if (props != null) {
            String jgroupChannel = props.getProperty(WIKITTY_EVENT_JGROUPCHANNELNAME_OPTION);
            if (!StringUtils.isBlank((String)jgroupChannel)) {
                this.initChannel(jgroupChannel);
            } else {
                throw new IllegalArgumentException("Can't use propagate cache without a valid jgroups channel name !!!");
            }
        }
    }

    protected void initChannel(String channelName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Init jgroup communication channel...");
        }
        try {
            this.channel = new JChannel();
            this.channel.setReceiver((Receiver)this);
            this.channel.setOpt(3, (Object)false);
            this.channel.connect(channelName);
            if (log.isInfoEnabled()) {
                log.info((Object)("JGroup communication channel initialized to " + this.channel.getAddressAsString() + " (" + this.channel.getClusterName() + ")"));
                log.info((Object)("Channel view: " + this.channel.getView()));
            }
        }
        catch (ChannelException eee) {
            throw new WikittyException("Can't initialize jgroup channel", eee);
        }
    }

    @Override
    public void sendMessage(WikittyServiceEvent event) throws Exception {
        Message msg = new Message(null, null, (Serializable)event);
        this.channel.send(msg);
    }

    public void receive(Message msg) {
        Object message = msg.getObject();
        if (log.isInfoEnabled()) {
            log.info((Object)("Receive message : " + message));
        }
        if (message instanceof WikittyServiceEvent) {
            WikittyServiceEvent event = (WikittyServiceEvent)message;
            this.ws.processRemoteEvent(event);
        }
    }
}

