package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class XmlFieldBindingAbstract extends BusinessEntityWikitty implements XmlFieldBinding {

    private static final long serialVersionUID = -278663925L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionXmlFieldBinding =
        new WikittyExtension(EXT_XMLFIELDBINDING, "2.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String xmlField[0-*] unique=true",
				"String formField",
				"String defaultValue"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionXmlFieldBinding);

        extensions = Collections.unmodifiableList(exts);
    }

	public XmlFieldBindingAbstract() {
		super();
	}

    public XmlFieldBindingAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public XmlFieldBindingAbstract(Wikitty wi) {
		super(wi);
	}

    public Set<String> getXmlField() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_XMLFIELD, String.class);
        return result;
    }

    public void addXmlField(String element) {
        getWikitty().addToField(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_XMLFIELD, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_XMLFIELDBINDING_XMLFIELD, null, getXmlField());
    }
    
    public void removeXmlField(String element) {
        getWikitty().removeFromField(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_XMLFIELD, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_XMLFIELDBINDING_XMLFIELD, null, getXmlField());
    }
    
    public void clearXmlField() {
        getWikitty().clearField(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_XMLFIELD);
        getPropertyChangeSupport().firePropertyChange(FIELD_XMLFIELDBINDING_XMLFIELD, null, getXmlField());
    }


    public void setFormField(String formField) {
        Object oldValue = getField(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_FORMFIELD);
        getWikitty().setField(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_FORMFIELD, formField);
        getPropertyChangeSupport().firePropertyChange(FIELD_XMLFIELDBINDING_FORMFIELD, oldValue, formField);
    }

    public String getFormField() {
        String result = getWikitty().getFieldAsString(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_FORMFIELD);
        return result;
    }


    public void setDefaultValue(String defaultValue) {
        Object oldValue = getField(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_DEFAULTVALUE);
        getWikitty().setField(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_DEFAULTVALUE, defaultValue);
        getPropertyChangeSupport().firePropertyChange(FIELD_XMLFIELDBINDING_DEFAULTVALUE, oldValue, defaultValue);
    }

    public String getDefaultValue() {
        String result = getWikitty().getFieldAsString(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_DEFAULTVALUE);
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_XMLFIELD);
            Object f2 = w2.getFieldAsObject(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_XMLFIELD);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_FORMFIELD);
            Object f2 = w2.getFieldAsObject(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_FORMFIELD);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_DEFAULTVALUE);
            Object f2 = w2.getFieldAsObject(EXT_XMLFIELDBINDING, FIELD_XMLFIELDBINDING_DEFAULTVALUE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //XmlFieldBindingAbstract
