package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public class GroupHelper extends GroupImpl {

    private static final long serialVersionUID = 696224139L;


    /**
     * This class is not instanciable, it's just helper
     */
    private GroupHelper() {
    }


    static public void setName(Wikitty w, String name) {
        w.setField(EXT_GROUP, Group.FIELD_GROUP_NAME, name);
    }

    static public String getName(Wikitty w) {
        String result = w.getFieldAsString(EXT_GROUP, Group.FIELD_GROUP_NAME);
        return result;
    }

    static public Set<String> getClient(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_GROUP, Group.FIELD_GROUP_CLIENT, String.class);
        return result;
    }

    static public void addClient(Wikitty w, String element) {
        w.addToField(EXT_GROUP, Group.FIELD_GROUP_CLIENT, element);
    }
    
    static public void removeClient(Wikitty w, String element) {
        w.removeFromField(EXT_GROUP, Group.FIELD_GROUP_CLIENT, element);
    }
    
    static public void clearClient(Wikitty w) {
        w.clearField(EXT_GROUP, Group.FIELD_GROUP_CLIENT);
    }

    static public Set<String> getUser(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_GROUP, Group.FIELD_GROUP_USER, String.class);
        return result;
    }

    static public void addUser(Wikitty w, String element) {
        w.addToField(EXT_GROUP, Group.FIELD_GROUP_USER, element);
    }
    
    static public void removeUser(Wikitty w, String element) {
        w.removeFromField(EXT_GROUP, Group.FIELD_GROUP_USER, element);
    }
    
    static public void clearUser(Wikitty w) {
        w.clearField(EXT_GROUP, Group.FIELD_GROUP_USER);
    }

    static public Set<String> getQueries(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES, String.class);
        return result;
    }

    static public void addQueries(Wikitty w, String element) {
        w.addToField(EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES, element);
    }
    
    static public void removeQueries(Wikitty w, String element) {
        w.removeFromField(EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES, element);
    }
    
    static public void clearQueries(Wikitty w) {
        w.clearField(EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES);
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_QUERYMAKER);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, Group.FIELD_GROUP_NAME);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, Group.FIELD_GROUP_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, Group.FIELD_GROUP_CLIENT);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, Group.FIELD_GROUP_CLIENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, Group.FIELD_GROUP_USER);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, Group.FIELD_GROUP_USER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //GroupHelper
