package com.herbocailleau.sgq.web;

/*
 * #%L
 * SGQ :: Web
 * $Id: SgqContextListener.java 178 2012-10-24 12:44:34Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/SgqContextListener.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.web.security.SecurityShiroFilter;

import com.herbocailleau.sgq.business.ServiceFactory;
import com.herbocailleau.sgq.business.SgqBusinessConfig;

public class SgqContextListener implements ServletContextListener {

    private static final Log log = LogFactory.getLog(SgqContextListener.class);

    @Override
    public void contextInitialized(ServletContextEvent sce) {

        if (log.isInfoEnabled()) {
            log.info("Context SGQ initialized");
        }

        // add application config in servlet context for shiro filter
        SgqBusinessConfig config = ServiceFactory.getConfig();
        sce.getServletContext().setAttribute(SecurityShiroFilter.APP_CONFIG_CONTEXT,
                config.getConfig());
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info("Context SGQ destroyed");
        }
    }
}
