/*
 * #%L
 * SGQ :: Web
 * $Id: LabelsImportProcessAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/LabelsImportProcessAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.io.File;

import com.herbocailleau.sgq.business.services.ProductionService;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action d'import de reception des lots.
 * 
 * @author echatellier
 */
public class LabelsImportProcessAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected File file;

    protected String fileFilename;

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileFilename(String fileFilename) {
        this.fileFilename = fileFilename;
    }

    @Override
    public String execute() throws Exception {

        ProductionService productionService = newService(ProductionService.class);
        productionService.importLabelsFile(fileFilename, file);

        return SUCCESS;
    }

}
