/*
 * #%L
 * SGQ :: Web
 * $Id: BatchAnalyzeAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchAnalyzeAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action d'affichage du détail d'une analyse.
 * 
 * @author echatellier
 */
public class BatchAnalyzeAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected String analyzeId;

    protected Analyze analyze;

    public void setAnalyzeId(String analyzeId) {
        this.analyzeId = analyzeId;
    }

    @Override
    public String execute() throws Exception {
        BatchService batchService = newService(BatchService.class);
        analyze = batchService.getAnalyzeById(analyzeId);
        return SUCCESS;
    }

    public Analyze getAnalyze() {
        return analyze;
    }
}
