/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzesReceiptAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/AnalyzesReceiptAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de preparation des analyses pour plusieurs lots.
 * 
 * @author echatellier
 */
public class AnalyzesReceiptAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected String analyzeId;

    protected Analyze analyze;

    protected List<Supplier> suppliers;

    public void setAnalyzeId(String analyzeId) {
        this.analyzeId = analyzeId;
    }

    @Override
    public String execute() throws Exception {

        ReferentialService referentialService = newService(ReferentialService.class);
        BatchService batchService = newService(BatchService.class);
        analyze = batchService.getAnalyzeById(analyzeId);
        suppliers = referentialService.getAllSupplierLabFirst();

        return SUCCESS;
    }

    public Analyze getAnalyze() {
        return analyze;
    }

    public List<Supplier> getSuppliers() {
        return suppliers;
    }
}
