/*
 * #%L
 * SGQ :: Web
 * $Id: SuppliersAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/SuppliersAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.List;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class SuppliersAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = -3534478380625138078L;

    protected int page;

    protected List<Supplier> suppliers;

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public String execute() throws Exception {

        ReferentialService referentialService = newService(ReferentialService.class);
        suppliers = referentialService.getSuppliers(10 * page, 10);
        return SUCCESS;
    }

    public List<Supplier> getSuppliers() {
        return suppliers;
    }
}
