/*
 * #%L
 * SGQ :: Web
 * $Id: ProductsAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/ProductsAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.List;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class ProductsAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 5564446302091087009L;

    protected int page;

    protected List<Product> products;

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public String execute() throws Exception {

        ReferentialService referentialService = newService(ReferentialService.class);
        products = referentialService.getProducts(50 * page, 50);
        return SUCCESS;
    }

    public List<Product> getProducts() {
        return products;
    }
}
