/*
 * #%L
 * SGQ :: Web
 * $Id: ClientEditProcessAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/ClientEditProcessAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.entities.ClientImpl;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class ClientEditProcessAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1308482145630762010L;

    protected ReferentialService referentialService;

    protected Client client;

    protected ReferentialService getReferentialService() {
        if (referentialService == null) {
            referentialService = newService(ReferentialService.class);
        }
        return referentialService;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName" , "clients"})})
    public String execute() throws Exception {

        getReferentialService().saveClient(client);

        return super.execute();
    }
    
    public Client getClient() {
        if (client == null) {
            String clientId = getParameter("client.topiaId");
            if (StringUtils.isNotBlank(clientId)) {
                client = getReferentialService().findClientById(clientId);
            } else {
                client = new ClientImpl();
            }
        }
        return client;
    }
}
