/*
 * #%L
 * SGQ :: Web
 * $Id: ClientEditAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/ClientEditAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.entities.ClientImpl;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class ClientEditAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4820174489319218088L;

    protected String clientId;

    protected Client client;

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String execute() throws Exception {

        ReferentialService referentialService = newService(ReferentialService.class);
        if (clientId != null) {
            client = referentialService.findClientById(clientId);
        } else {
            client = new ClientImpl();
        }

        return SUCCESS;
    }

    public Client getClient() {
        return client;
    }
}
