/*
 * #%L
 * SGQ :: Web
 * $Id: SgqActionSupport.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/SgqActionSupport.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ParameterAware;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.nuiton.topia.TopiaContext;
import org.nuiton.web.filter.TopiaTransactionFilter;

import com.herbocailleau.sgq.business.ServiceFactory;
import com.herbocailleau.sgq.business.SgqService;
import com.opensymphony.xwork2.ActionSupport;

public class SgqActionSupport extends ActionSupport implements ServletRequestAware, ParameterAware {

    /** serialVersionUID. */
    private static final long serialVersionUID = -2556887628485541765L;

    /** Topia context associated with request. */
    protected TopiaContext transaction;

    protected Map<String, String[]> actionParameters;

    @Override
    public void setServletRequest(HttpServletRequest request) {
        transaction = TopiaTransactionFilter.getTransaction(request);
    }

    @Override
    public void setParameters(Map<String, String[]> actionParameters) {
        this.actionParameters = actionParameters;
        
    }

    public <E extends SgqService> E newService(Class<E> serviceClass) {
        E service = ServiceFactory.newService(serviceClass, transaction);
        return service;
    }

    public String getApplicationVersion() {
        return ServiceFactory.getConfig().getFlatOptions().getProperty("application.version");
    }
    
    /**
     * Renvoie la valeur d'un paramètre de la request. Cette méthode peut
     * être appelée pour récupérer la valeur d'un paramètre avant que
     * l'intercepteur pousse les valeurs saisies dans un formulaire.
     *
     * @param parameterKey l'identifiant du paramètre
     * @return sa valeur
     */
    public String getParameter(String parameterKey) {
        String result = null;
        if (actionParameters != null) {
            String[] parameterValues = actionParameters.get(parameterKey);
            if (parameterValues != null && parameterValues.length >= 1) {
                result = parameterValues[0];
            }
        }
        return result;
    }
}
