/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.reply.actions;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.Stamp;
import com.franciaflex.faxtomail.services.service.UserService;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SetDefaultSigningAction
extends AbstractFaxToMailAction<SigningSettingsUIModel, SigningSettingsUI, SigningSettingsUIHandler> {
    private static final Log log = LogFactory.getLog(SetDefaultSigningAction.class);

    public SetDefaultSigningAction(SigningSettingsUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        SigningSettingsUIModel model = (SigningSettingsUIModel)this.getModel();
        Stamp signing = model.getSelectedSigning();
        signing.setLabel(model.getSelectedSigningName());
        signing.setText(model.getSelectedSigningText());
        FaxToMailUser user = this.getContext().getCurrentUser();
        UserService userService = this.getContext().newServiceContext().getUserService();
        userService.saveSigning(user, signing, true);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((SigningSettingsUIModel)this.getModel()).setSelectedSigningDefault(true);
        ((SigningSettingsUIModel)this.getModel()).updateSetDefaultButtonEnabled();
        ((SigningSettingsUIModel)this.getModel()).setModified(false);
        ((SigningSettingsUI)this.getUI()).getSigningList().repaint();
    }
}

