/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.reply;

import com.franciaflex.faxtomail.persistence.entities.Stamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdesktop.beans.AbstractSerializableBean;

public class SigningSettingsUIModel
extends AbstractSerializableBean {
    public static final String PROPERTY_SIGNINGS = "signings";
    public static final String PROPERTY_SELECTED_SIGNING = "selectedSigning";
    public static final String PROPERTY_SELECTED_SIGNING_NAME = "selectedSigningName";
    public static final String PROPERTY_SELECTED_SIGNING_TEXT = "selectedSigningText";
    public static final String PROPERTY_SELECTED_SIGNING_DEFAULT = "selectedSigningDefault";
    public static final String PROPERTY_SET_DEFAULT_BUTTON_ENABLED = "setDefaultButtonEnabled";
    public static final String PROPERTY_MODIFIED = "modified";
    protected List<Stamp> signings = new ArrayList<Stamp>();
    protected Stamp selectedSigning;
    protected String selectedSigningName;
    protected String selectedSigningText;
    protected boolean selectedSigningDefault;
    protected boolean modified;

    public Stamp getSelectedSigning() {
        return this.selectedSigning;
    }

    public void setSelectedSigning(Stamp selectedSigning) {
        Stamp oldValue = this.getSelectedSigning();
        this.selectedSigning = selectedSigning;
        this.firePropertyChange(PROPERTY_SELECTED_SIGNING, oldValue, selectedSigning);
        this.setSelectedSigningName(selectedSigning != null ? selectedSigning.getLabel() : "");
        this.setSelectedSigningText(selectedSigning != null ? selectedSigning.getText() : "");
        this.setModified(false);
        this.updateSetDefaultButtonEnabled();
    }

    public List<Stamp> getSignings() {
        return this.signings;
    }

    public void setSignings(Collection<Stamp> signings) {
        this.signings.clear();
        if (signings != null) {
            this.signings.addAll(signings);
        }
        this.firePropertyChange(PROPERTY_SIGNINGS, null, this.signings);
    }

    public void addSigning(Stamp signing) {
        this.signings.add(signing);
        this.firePropertyChange(PROPERTY_SIGNINGS, null, this.signings);
    }

    public void removeSigning(Stamp signing) {
        this.signings.remove(signing);
        this.firePropertyChange(PROPERTY_SIGNINGS, null, this.signings);
    }

    public String getSelectedSigningName() {
        return this.selectedSigningName;
    }

    public void setSelectedSigningName(String selectedSigningName) {
        String oldValue = this.getSelectedSigningName();
        this.selectedSigningName = selectedSigningName;
        this.firePropertyChange(PROPERTY_SELECTED_SIGNING_NAME, oldValue, selectedSigningName);
        this.setModified(true);
    }

    public String getSelectedSigningText() {
        return this.selectedSigningText;
    }

    public void setSelectedSigningText(String selectedSigningText) {
        String oldValue = this.getSelectedSigningText();
        this.selectedSigningText = selectedSigningText;
        this.firePropertyChange(PROPERTY_SELECTED_SIGNING_TEXT, oldValue, selectedSigningText);
        this.setModified(true);
    }

    public boolean isSelectedSigningDefault() {
        return this.selectedSigningDefault;
    }

    public void setSelectedSigningDefault(boolean selectedSigningDefault) {
        Boolean oldValue = this.isSelectedSigningDefault();
        this.selectedSigningDefault = selectedSigningDefault;
        this.firePropertyChange(PROPERTY_SELECTED_SIGNING_DEFAULT, oldValue, selectedSigningDefault);
        this.updateSetDefaultButtonEnabled();
    }

    public boolean isSetDefaultButtonEnabled() {
        return this.selectedSigning != null && this.selectedSigning.isPersisted() && !this.selectedSigningDefault;
    }

    public void updateSetDefaultButtonEnabled() {
        this.firePropertyChange(PROPERTY_SET_DEFAULT_BUTTON_ENABLED, null, this.isSetDefaultButtonEnabled());
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        Boolean oldValue = this.isModified();
        this.modified = modified;
        this.firePropertyChange(PROPERTY_MODIFIED, oldValue, modified);
    }

    public void resetSelectedSigning() {
        this.setSelectedSigningName(this.selectedSigning.getLabel());
        this.setSelectedSigningText(this.selectedSigning.getText());
        this.setModified(false);
    }
}

