/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.pdfeditor.actions;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorCrossUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorHighlighterUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorLineUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorNoteUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorStampTextUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXContext;
import org.nuiton.i18n.I18n;

public class GenerateAnnotatedAttachmentAction
extends AbstractFaxToMailAction<PDFEditorUIModel, PDFEditorUI, PDFEditorUIHandler> {
    public GenerateAnnotatedAttachmentAction(PDFEditorUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n.t((String)"faxtomail.action.generateAnnotatedAttachment.tip", (Object[])new Object[0]));
    }

    @Override
    public void doAction() throws Exception {
        PDFEditorUIModel model = (PDFEditorUIModel)this.getModel();
        AttachmentFile attachmentFile = model.getNotNullFile();
        File file = attachmentFile.getFile();
        FileInputStream inputStream = new FileInputStream(file);
        PdfReader.unethicalreading = true;
        PdfReader pdfReader = new PdfReader((InputStream)inputStream);
        File target = File.createTempFile("faxtomail-", ".tmp");
        target.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(target);
        PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)fos);
        int pageNb = model.getPages().length;
        float zoom = model.getZoom();
        int rotation = model.getRotation();
        for (int i = 1; i <= pageNb; ++i) {
            PdfContentByte cb = pdfStamper.getOverContent(i);
            PDFEditorUIModel.Page page = model.getPage(i);
            for (PDFEditorNoteUI pDFEditorNoteUI : page.getNotes()) {
                this.addNoteToPdf(zoom, rotation, cb, pDFEditorNoteUI);
            }
            for (PDFEditorCrossUI pDFEditorCrossUI : page.getCrosses()) {
                this.addCrossToPdf(zoom, rotation, cb, pDFEditorCrossUI);
            }
            for (PDFEditorLineUI pDFEditorLineUI : page.getLines()) {
                this.addLineToPdf(zoom, rotation, cb, pDFEditorLineUI);
            }
            for (PDFEditorHighlighterUI pDFEditorHighlighterUI : page.getHighlighters()) {
                this.addHighlightToPdf(zoom, rotation, cb, pDFEditorHighlighterUI);
            }
            for (PDFEditorStampTextUI pDFEditorStampTextUI : page.getTextStamps()) {
                this.addStampToPdf(zoom, rotation, cb, pDFEditorStampTextUI);
            }
        }
        pdfStamper.close();
        pdfReader.close();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(target));
        FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
        AttachmentFile attachmentFileNew = serviceContext.getEmailService().getAttachmentFileFromStream((InputStream)is);
        attachmentFileNew.setRotation(rotation);
        String fileName = model.getOriginalFile().getFilename();
        attachmentFileNew.setFilename(FaxToMailUIUtil.getEditedFileName(fileName));
        model.setEditedFile(attachmentFileNew);
    }

    protected void addHighlightToPdf(float zoom, int rotation, PdfContentByte cb, PDFEditorHighlighterUI panel) {
        int[] coordinates = this.computeCoordinates(panel, rotation, zoom);
        int width = coordinates[0];
        int height = coordinates[1];
        int x = coordinates[2];
        int y = coordinates[3];
        cb.saveState();
        PdfGState gs1 = new PdfGState();
        gs1.setFillOpacity(0.4f);
        cb.setGState(gs1);
        cb.setColorFill(BaseColor.YELLOW);
        cb.rectangle((float)x, (float)y, (float)width, (float)height);
        cb.fill();
        cb.restoreState();
    }

    protected void addLineToPdf(float zoom, int rotation, PdfContentByte cb, PDFEditorLineUI panel) {
        int[] coordinates = this.computeCoordinates(panel, rotation, zoom);
        int width = coordinates[0];
        int height = coordinates[1];
        int x = coordinates[2];
        int y = coordinates[3];
        if (rotation % 180 == 0 ^ panel.isHorizontal() == false) {
            y += height / 2;
        } else {
            x += width / 2;
        }
        cb.saveState();
        cb.setColorStroke(BaseColor.BLUE);
        cb.moveTo((float)x, (float)y);
        if (rotation % 180 == 0 ^ panel.isHorizontal() == false) {
            cb.lineTo((float)(x + width), (float)y);
        } else {
            cb.lineTo((float)x, (float)(y + height));
        }
        cb.stroke();
        cb.restoreState();
    }

    protected void addCrossToPdf(float zoom, int rotation, PdfContentByte cb, PDFEditorCrossUI panel) {
        int[] coordinates = this.computeCoordinates(panel, rotation, zoom);
        int width = coordinates[0];
        int height = coordinates[1];
        int x = coordinates[2];
        int y = coordinates[3];
        cb.saveState();
        cb.setColorStroke(BaseColor.BLUE);
        cb.moveTo((float)x, (float)y);
        cb.lineTo((float)(x + width), (float)(y + height));
        cb.stroke();
        cb.moveTo((float)(x + width), (float)y);
        cb.lineTo((float)x, (float)(y + height));
        cb.stroke();
        cb.restoreState();
    }

    protected void addNoteToPdf(float zoom, int rotation, PdfContentByte cb, PDFEditorNoteUI note) throws DocumentException, IOException {
        int[] coordinates = this.computeCoordinates(note, rotation, zoom);
        int width = coordinates[0];
        int height = coordinates[1];
        int x = coordinates[2];
        int y = coordinates[3];
        Insets insets = note.getInsets();
        cb.saveState();
        cb.setColorFill(BaseColor.YELLOW);
        cb.rectangle((float)x, (float)y, (float)width, (float)height);
        cb.fill();
        cb.restoreState();
        cb.saveState();
        JTextArea textArea = note.getNoteText();
        float fontSize = textArea.getFont().getSize2D() / zoom;
        BaseFont titleFont = BaseFont.createFont((String)"Helvetica-Oblique", (String)"Cp1252", (boolean)false);
        BaseFont font = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        String text = note.getText();
        String[] rows = text.split("\n");
        int rowHeight = (int)((float)(textArea.getHeight() / rows.length) / zoom);
        int xxx = x;
        int yyy = y;
        if (rotation == 0) {
            xxx += insets.left;
            yyy = (int)((float)yyy + ((float)(height - rowHeight) - (float)insets.top / zoom));
        } else if (rotation == 90) {
            xxx = (int)((float)xxx + ((float)rowHeight + (float)insets.top / zoom));
            yyy += insets.left;
        } else if (rotation == 180) {
            xxx = (int)((float)xxx + ((float)width - (float)insets.right / zoom));
            yyy = (int)((float)yyy + ((float)rowHeight - (float)insets.top / zoom));
        } else if (rotation == 270) {
            xxx = (int)((float)xxx + ((float)(width - rowHeight) - (float)insets.left / zoom));
            yyy = (int)((float)yyy + ((float)height - (float)insets.top / zoom));
        }
        this.showTextAligned(cb, note.getTitle(), xxx, yyy, rotation, titleFont, fontSize);
        for (String s : rows) {
            if (s.isEmpty()) {
                s = " ";
            }
            if (rotation == 0) {
                yyy -= rowHeight;
            } else if (rotation == 90) {
                xxx += rowHeight;
            } else if (rotation == 180) {
                yyy += rowHeight;
            } else if (rotation == 270) {
                xxx -= rowHeight;
            }
            this.showTextAligned(cb, s, xxx, yyy, rotation, font, fontSize);
        }
        cb.restoreState();
    }

    protected void addStampToPdf(float zoom, int rotation, PdfContentByte cb, PDFEditorStampTextUI stamp) throws DocumentException, IOException {
        int[] coordinates = this.computeCoordinates(stamp, rotation, zoom);
        int width = coordinates[0];
        int height = coordinates[1];
        int x = coordinates[2];
        int y = coordinates[3];
        Insets insets = stamp.getInsets();
        cb.saveState();
        JLabel label = stamp.getStampText();
        float fontSize = label.getFont().getSize2D() / zoom;
        BaseFont font = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        String text = stamp.getText();
        String[] rows = text.split("\n");
        int rowHeight = (int)((float)(stamp.getHeight() / rows.length) / zoom);
        int xxx = x;
        int yyy = y;
        if (rotation == 0) {
            xxx += insets.left;
            yyy = (int)((float)yyy + ((float)(height - rowHeight) - (float)insets.top / zoom));
        } else if (rotation == 90) {
            xxx = (int)((float)xxx + ((float)rowHeight + (float)insets.top / zoom));
            yyy += insets.left;
        } else if (rotation == 180) {
            xxx = (int)((float)xxx + ((float)width - (float)insets.right / zoom));
            yyy = (int)((float)yyy + ((float)rowHeight - (float)insets.top / zoom));
        } else if (rotation == 270) {
            xxx = (int)((float)xxx + ((float)(width - rowHeight) - (float)insets.left / zoom));
            yyy = (int)((float)yyy + ((float)height - (float)insets.top / zoom));
        }
        for (String s : rows) {
            if (s.isEmpty()) {
                s = " ";
            }
            this.showTextAligned(cb, s, xxx, yyy, rotation, font, fontSize);
            if (rotation == 0) {
                yyy -= rowHeight;
                continue;
            }
            if (rotation == 90) {
                xxx += rowHeight;
                continue;
            }
            if (rotation == 180) {
                yyy += rowHeight;
                continue;
            }
            if (rotation != 270) continue;
            xxx -= rowHeight;
        }
        cb.restoreState();
    }

    protected int[] computeCoordinates(Component panel, int rotation, float zoom) {
        Point location = panel.getLocation();
        int width = rotation % 180 == 0 ? panel.getWidth() : panel.getHeight();
        int height = rotation % 180 == 0 ? panel.getHeight() : panel.getWidth();
        width = (int)((float)width / zoom);
        height = (int)((float)height / zoom);
        int x = 0;
        int y = 0;
        if (rotation == 0) {
            x = (int)((float)location.x / zoom);
            y = (int)((float)(((PDFEditorUI)this.getUI()).getContainer().getHeight() - location.y) / zoom) - height;
        } else if (rotation == 180) {
            x = (int)((float)(((PDFEditorUI)this.getUI()).getContainer().getWidth() - location.x) / zoom) - width;
            y = (int)((float)location.y / zoom);
        } else if (rotation == 90) {
            x = (int)((float)location.y / zoom);
            y = (int)((float)location.x / zoom);
        } else if (rotation == 270) {
            x = (int)((float)(((PDFEditorUI)this.getUI()).getContainer().getHeight() - location.y) / zoom) - width;
            y = (int)((float)(((PDFEditorUI)this.getUI()).getContainer().getWidth() - location.x) / zoom) - height;
        }
        int[] result = new int[]{width, height, x, y};
        return result;
    }

    protected void showTextAligned(PdfContentByte canvas, String text, float x, float y, float rotation, BaseFont baseFont, float fontSize) {
        canvas.saveState();
        ColumnText ct = new ColumnText(canvas);
        float lly = -1.0f;
        float ury = 2.0f;
        float llx = 0.0f;
        float urx = 20000.0f;
        if (rotation == 0.0f) {
            llx += x;
            lly += y;
            urx += x;
            ury += y;
        } else {
            double alpha = (double)rotation * Math.PI / 180.0;
            float cos = (float)Math.cos(alpha);
            float sin = (float)Math.sin(alpha);
            canvas.concatCTM(cos, sin, -sin, cos, x, y);
        }
        Font font = new Font(baseFont, fontSize);
        ct.setSimpleColumn(new Phrase(text, font), llx, lly, urx, ury, 0.0f, 0);
        ct.setAlignment(0);
        try {
            ct.go();
        }
        catch (DocumentException e) {
            throw new ExceptionConverter((Exception)((Object)e));
        }
        canvas.restoreState();
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        PDFEditorUIModel model = (PDFEditorUIModel)this.getModel();
        AttachmentEditorUI parentUI = (AttachmentEditorUI)((PDFEditorUI)this.getUI()).getContextValue(JAXXContext.class, "parent");
        parentUI.getModel().fireAttachmentEdited((Attachment)model.toEntity());
        model.setModify(false);
        ((PDFEditorUIHandler)this.getHandler()).closeFrame();
    }
}

