/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.Configuration;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.HistoryImpl;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.MailAction;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.OriginalEmail;
import com.franciaflex.faxtomail.persistence.entities.OriginalEmailImpl;
import com.franciaflex.faxtomail.ui.swing.actions.PrintOnDefaultPrinterAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListTableFilter;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.actions.ComputeQuantitiesByRangeAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.actions.LoadFolderEmailsAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.actions.SaveDemandeFromListAction;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailDemandListHandler;
import com.franciaflex.faxtomail.ui.swing.util.DemandeTableModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.franciaflex.faxtomail.ui.swing.util.FolderTreeNode;
import com.franciaflex.faxtomail.ui.swing.util.PaginationComboModel;
import com.franciaflex.faxtomail.ui.swing.util.RemoveablePropertyChangeListener;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.table.filter.TableFilter;
import jaxx.runtime.swing.table.filter.TableRowFilterSupport;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.nuiton.decorator.Decorator;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.action.ApplicationUIAction;
import org.nuiton.jaxx.application.swing.util.CloseableUI;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class DemandeListUIHandler
extends AbstractFaxToMailDemandListHandler<DemandeListUIModel, DemandeListUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(DemandeListUIHandler.class);
    public static final String REFRESH_KEY = "F5";
    public static final String REFRESH_FOLDER_ACTION = "refreshFolder";
    protected Configuration config;
    protected DemandeListTableFilter tableFilter;
    protected Timer refreshListTimer;
    protected final Binder<EmailFilter, EmailFilter> binder = BinderFactory.newBinder(EmailFilter.class);
    protected final PropertyChangeListener actionInProgressListener = new RemoveablePropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean inProgress = (Boolean)evt.getNewValue();
            ((DemandeListUI)DemandeListUIHandler.this.getUI()).getNavigationTree().setEnabled(!inProgress);
        }
    };
    protected final PropertyChangeListener emailFilterPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EmailFilter emailFilter = (EmailFilter)evt.getSource();
            DemandeListUIHandler.this.binder.copy((Object)emailFilter, (Object)DemandeListUIHandler.this.getContext().getEmailFilter(), new String[]{evt.getPropertyName()});
        }
    };
    protected final PropertyChangeListener selectedDemandeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("priority".equals(propertyName) && (evt.getNewValue() != null || evt.getOldValue() != null)) {
                SaveDemandeFromListAction saveAction = (SaveDemandeFromListAction)DemandeListUIHandler.this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)DemandeListUIHandler.this, SaveDemandeFromListAction.class);
                saveAction.setModifiedProperties(propertyName);
                DemandeListUIHandler.this.getContext().getActionEngine().runAction((AbstractApplicationAction)saveAction);
            }
        }
    };

    public TableFilter<JXTable> getTableFilter() {
        return this.tableFilter;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void beforeInit(DemandeListUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.config = this.getContext().newServiceContext().getConfigurationService().getConfiguration();
        DemandeListUIModel model = new DemandeListUIModel();
        List folders = this.getContext().newServiceContext().getMailFolderService().getRootMailFoldersWithReadingRights(this.getContext().getCurrentUser());
        model.setFolders(new ArrayList<MailFolder>(folders));
        ((DemandeListUI)this.ui).setContextValue(model);
    }

    public void afterInit(DemandeListUI ui) {
        this.initUI(ui);
        DemandeListUIModel model = (DemandeListUIModel)((Object)this.getModel());
        final JXTable dataTable = ((DemandeListUI)this.getUI()).getDataTable();
        this.initDemandeTable(dataTable, false);
        this.tableFilter = new DemandeListTableFilter(dataTable, this);
        Decorator<Object> decorator = new Decorator<Object>(Object.class){

            public String toString(Object bean) {
                Decorator<?> decorator;
                String s = null;
                if (bean != null && (decorator = DemandeListUIHandler.this.getDecorator(bean.getClass(), null)) != null) {
                    s = decorator.toString(bean);
                }
                if (s == null) {
                    s = JAXXUtil.getStringValue((Object)bean);
                }
                return s;
            }
        };
        TableRowFilterSupport.forFilter((TableFilter)this.tableFilter).searchable(true).searchDecorator((Decorator)decorator).useTableRenderers(true).setPopupDefaultSize(new Dimension(250, 290)).apply();
        this.updateEmailFilterWithContextEmailFilter();
        dataTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel source = (ListSelectionModel)e.getSource();
                DemandeListUIModel model = (DemandeListUIModel)((Object)DemandeListUIHandler.this.getModel());
                if (source.isSelectionEmpty()) {
                    model.setSelectedEmails(null);
                } else {
                    ArrayList<DemandeUIModel> selectedRows = new ArrayList<DemandeUIModel>();
                    DemandeTableModel dataTableModel = (DemandeTableModel)dataTable.getModel();
                    for (int i = source.getMinSelectionIndex(); i <= source.getMaxSelectionIndex(); ++i) {
                        if (!source.isSelectedIndex(i)) continue;
                        selectedRows.add(dataTableModel.getEntry(i));
                    }
                    model.setSelectedEmails(selectedRows);
                }
            }
        });
        model.addPropertyChangeListener("emails", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List emails = (List)evt.getNewValue();
                DemandeTableModel dataTableModel = (DemandeTableModel)dataTable.getModel();
                dataTableModel.setRows(emails);
                int quotationNb = 0;
                int pfNb = 0;
                int savNb = 0;
                for (DemandeUIModel email : emails) {
                    quotationNb += email.getQuotationNb();
                    pfNb += email.getPfNb();
                    savNb += email.getSavNb();
                }
                DemandeListUIModel model = (DemandeListUIModel)((Object)evt.getSource());
                model.setQuotationNb(quotationNb);
                model.setPfNb(pfNb);
                model.setSavNb(savNb);
            }
        });
        model.addPropertyChangeListener("selectedEmails", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List newDemands;
                List oldDemands = (List)evt.getOldValue();
                if (oldDemands != null) {
                    for (DemandeUIModel demand : oldDemands) {
                        demand.removePropertyChangeListener(DemandeListUIHandler.this.selectedDemandeChangeListener);
                    }
                }
                if ((newDemands = (List)evt.getNewValue()) != null) {
                    for (DemandeUIModel demand : newDemands) {
                        demand.addPropertyChangeListener(DemandeListUIHandler.this.selectedDemandeChangeListener);
                    }
                }
                DemandeListUIHandler.this.resetTimer();
            }
        });
        final JTree navigationTree = ui.getNavigationTree();
        List<MailFolder> foldersToExpand = this.getContext().getListExpandedFolders();
        final Map<MailFolder, FolderTreeNode> nodesByFolder = FaxToMailUIUtil.initFolderTree(this.getContext(), navigationTree, model.getFolders(), foldersToExpand, true);
        this.getContext().addPropertyChangeListener("actionInProgress", this.actionInProgressListener);
        navigationTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FolderTreeNode folderNode;
                TableCellEditor cellEditor = dataTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.stopCellEditing();
                }
                if ((folderNode = (FolderTreeNode)e.getPath().getLastPathComponent()).isCanSelect()) {
                    MailFolder folder = folderNode.getMailFolder();
                    ((DemandeListUIModel)((Object)DemandeListUIHandler.this.getModel())).setSelectedFolder(folder);
                }
            }
        });
        model.addPropertyChangeListener("selectedFolder", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MailFolder folder = (MailFolder)evt.getNewValue();
                DemandeListUIHandler.this.getContext().setCurrentMailFolder(folder);
                DemandeListUIHandler.this.loadFolderDemands(nodesByFolder);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodesByFolder.get(folder);
                if (node != null) {
                    navigationTree.setSelectionPath(new TreePath(node.getPath()));
                }
            }
        });
        ui.getResultPerPageCombo().setModel(new PaginationComboModel());
        int resultPerPage = this.getConfig().getResultPerPage();
        ui.getModel().setResultPerPage(resultPerPage);
        ui.getResultPerPageCombo().setSelectedItem(resultPerPage);
        ui.getResultPerPageCombo().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DemandeListUIHandler.this.updateResultPerPage(e);
            }
        });
        JRootPane rootPane = this.getContext().getMainUI().getRootPane();
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(REFRESH_KEY), REFRESH_FOLDER_ACTION);
        ApplicationUIAction refreshAction = this.getContext().getActionFactory().createUIAction((AbstractApplicationUIHandler)this, LoadFolderEmailsAction.class);
        rootPane.getActionMap().put(REFRESH_FOLDER_ACTION, (Action)refreshAction);
        int interval = this.getConfig().getRefreshListInterval() * 1000;
        this.refreshListTimer = new Timer(interval, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadFolderEmailsAction refreshAction = (LoadFolderEmailsAction)DemandeListUIHandler.this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)DemandeListUIHandler.this, LoadFolderEmailsAction.class);
                DemandeListUIHandler.this.getContext().getActionEngine().runAction((AbstractApplicationAction)refreshAction);
            }
        });
        this.loadFolderDemands(nodesByFolder);
    }

    public void resetTimer() {
        this.refreshListTimer.restart();
    }

    public void updateEmailFilterWithContextEmailFilter() {
        EmailFilter emailFilter = ((DemandeListUIModel)((Object)this.getModel())).getEmailFilter();
        emailFilter.removePropertyChangeListener(this.emailFilterPropertyChangeListener);
        this.filtersFromContextToModel();
        emailFilter.addPropertyChangeListener(this.emailFilterPropertyChangeListener);
    }

    protected void filtersFromContextToModel() {
        EmailFilter contextEmailFilter = this.getContext().getEmailFilter();
        EmailFilter currentEmailFilter = ((DemandeListUIModel)((Object)this.getModel())).getEmailFilter();
        currentEmailFilter.clear();
        ArrayList fields = this.getColumns();
        if (CollectionUtils.isEmpty(fields)) {
            fields = Lists.newArrayList((Object[])MailField.getTableFields());
        }
        ArrayList<String> propertiesToBind = new ArrayList<String>();
        for (int i = 0; i < fields.size(); ++i) {
            String property = null;
            MailField field = (MailField)fields.get(i);
            switch (field) {
                case DEMAND_STATUS: {
                    property = "demandStatus";
                    break;
                }
                case RECEPTION_DATE: {
                    property = "receptionDates";
                    break;
                }
                case RECIPIENT: {
                    property = "recipients";
                    break;
                }
                case SENDER: {
                    property = "senders";
                    break;
                }
                case OBJECT: {
                    property = "demandObjects";
                    break;
                }
                case CLIENT_CODE: {
                    property = "clientCodes";
                    break;
                }
                case CLIENT_NAME: {
                    property = "clientNames";
                    break;
                }
                case CLIENT_BRAND: {
                    property = "clientBrands";
                    break;
                }
                case DEMAND_TYPE: {
                    property = "demandTypes";
                    break;
                }
                case EDI_RETURN: {
                    property = "ediCodeNumbers";
                    break;
                }
                case WAITING_STATE: {
                    property = "waitingStates";
                    break;
                }
                case TAKEN_BY: {
                    property = "takenBys";
                    break;
                }
                case PRIORITY: {
                    property = "priorities";
                    break;
                }
                case PROJECT_REFERENCE: {
                    property = "projectReferences";
                    break;
                }
                case COMPANY_REFERENCE: {
                    property = "localReferences";
                    break;
                }
                case REFERENCE: {
                    property = "references";
                    break;
                }
                case RANGE_ROW: {
                    property = "ranges";
                    break;
                }
                case PF_NB: {
                    property = "productsQuantities";
                    break;
                }
                case SAV_NB: {
                    property = "savQuantities";
                    break;
                }
                case QUOTATION_NB: {
                    property = "quotationQuantities";
                    break;
                }
                case LAST_ATTACHMENT_OPENING_IN_THIS_FOLDER_USER: {
                    property = "lastAttachmentOpeners";
                    break;
                }
                case COMMENT: {
                    property = "comments";
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)(i + "property to copy to model's emailfilter : " + property));
            }
            if (property != null) {
                block34: {
                    try {
                        Method getter = new PropertyDescriptor(property, EmailFilter.class).getReadMethod();
                        Collection value = (Collection)getter.invoke((Object)contextEmailFilter, new Object[0]);
                        this.tableFilter.setFilterState(i, value);
                    }
                    catch (IntrospectionException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("error while introspecting emailfilter for property " + property), (Throwable)e);
                        }
                    }
                    catch (InvocationTargetException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("error while calling getter for property " + property), (Throwable)e);
                        }
                    }
                    catch (IllegalAccessException e) {
                        if (!log.isErrorEnabled()) break block34;
                        log.error((Object)("error while calling getter for property " + property), (Throwable)e);
                    }
                }
                propertiesToBind.add(property);
                continue;
            }
            this.tableFilter.setFilterState(i, null);
        }
        this.binder.copy((Object)contextEmailFilter, (Object)currentEmailFilter, propertiesToBind.toArray(new String[propertiesToBind.size()]));
    }

    @Override
    public String populateColumnModel(JXTable table, boolean sortable) {
        return super.populateColumnModel(table, sortable);
    }

    protected void loadFolderDemands(Map<MailFolder, FolderTreeNode> nodesByFolder) {
        FolderTreeNode folderNode;
        MailFolder folder = ((DemandeListUIModel)((Object)this.getModel())).getSelectedFolder();
        if (folder != null && (folderNode = nodesByFolder.get(folder)) != null) {
            boolean readable = folderNode.isCanRead();
            while (folder.getAllowCreateDemandIntoFolder() == null && folder.getParent() != null) {
                folder = folder.getParent();
            }
            DemandeListUIModel model = (DemandeListUIModel)((Object)this.getModel());
            model.setComputeQuantitiesByRangeEnabled(readable);
            model.setNewDemandEnabled(readable && folder != null && Boolean.TRUE.equals(folder.getAllowCreateDemandIntoFolder()));
        }
        this.tableFilter.executeFilter();
    }

    public void goToNextPage() {
        ((DemandeListUIModel)((Object)this.getModel())).setPaginationParameter(((DemandeListUIModel)((Object)this.getModel())).getPaginationResult().getNextPage());
        this.runListAction();
    }

    public void goToPreviousPage() {
        ((DemandeListUIModel)((Object)this.getModel())).setPaginationParameter(((DemandeListUIModel)((Object)this.getModel())).getPaginationResult().getPreviousPage());
        this.runListAction();
    }

    public void updateResultPerPage(ItemEvent event) {
        if (event.getStateChange() == 1) {
            int resultPerPage = (Integer)event.getItem();
            ((DemandeListUIModel)((Object)this.getModel())).setResultPerPage(resultPerPage);
            this.getConfig().setResultPerPage(resultPerPage);
            this.getConfig().save();
            ((DemandeListUIModel)((Object)this.getModel())).resetPaginationParameter();
            this.runListAction();
        }
    }

    protected void runListAction() {
        if (((DemandeListUIModel)((Object)this.getModel())).getSelectedFolder() != null) {
            LoadFolderEmailsAction loadFolderEmailsAction = (LoadFolderEmailsAction)this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)this, LoadFolderEmailsAction.class);
            this.getContext().getActionEngine().runAction((AbstractApplicationAction)loadFolderEmailsAction);
        }
    }

    @Override
    public void initDemandeTable(final JXTable table, boolean sortable) {
        HighlightPredicate reportNotTakenPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                int viewRow = adapter.row;
                int modelRow = adapter.convertRowIndexToModel(viewRow);
                DemandeUIModel row = ((DemandeTableModel)table.getModel()).getEntry(modelRow);
                MailFolder folder = ((DemandeListUIModel)((Object)DemandeListUIHandler.this.getModel())).getSelectedFolder();
                while (folder.getOpenAttachmentReportNoTaken() == null && folder.getParent() != null) {
                    folder = folder.getParent();
                }
                return Boolean.TRUE.equals(folder.getOpenAttachmentReportNoTaken()) && row.getLastAttachmentOpener() != null && !row.getLastAttachmentOpener().equals(row.getTakenBy());
            }
        };
        Color color = Color.ORANGE;
        table.addHighlighter((Highlighter)new ColorHighlighter(reportNotTakenPredicate, color, Color.WHITE, color.darker(), Color.WHITE));
        super.initDemandeTable(table, sortable);
    }

    @Override
    public List<MailField> getColumns() {
        List tableColumns = null;
        MailFolder selectedFolder = ((DemandeListUIModel)((Object)this.getModel())).getSelectedFolder();
        if (selectedFolder != null) {
            while (!selectedFolder.isUseCurrentLevelTableColumns() && selectedFolder.getParent() != null) {
                selectedFolder = selectedFolder.getParent();
            }
            tableColumns = selectedFolder.getFolderTableColumns();
        }
        return tableColumns;
    }

    @Override
    protected MailField[] getEditableTableProperties() {
        MailField[] result = ((DemandeListUIModel)((Object)this.getModel())).getSelectedFolder() != null && ((DemandeListUIModel)((Object)this.getModel())).getSelectedFolder().isFolderWritable() ? new MailField[]{MailField.PRIORITY, MailField.ATTACHMENT, MailField.REPLIES} : new MailField[]{MailField.ATTACHMENT, MailField.REPLIES};
        return result;
    }

    @Override
    protected void onDoubleClickOnDemande(DemandeUIModel selectedEmail) {
        super.onDoubleClickOnDemande(selectedEmail);
        selectedEmail.removePropertyChangeListener(this.selectedDemandeChangeListener);
        this.getContext().setCurrentPaginationParameter(((DemandeListUIModel)((Object)this.getModel())).getPaginationParameter());
    }

    protected JComponent getComponentToFocus() {
        return ((DemandeListUI)this.getUI()).getNavigationTree();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        DemandeListUIModel model = (DemandeListUIModel)((Object)this.getModel());
        model.getEmailFilter().removePropertyChangeListener(this.emailFilterPropertyChangeListener);
        List<DemandeUIModel> selectedEmails = model.getSelectedEmails();
        if (selectedEmails != null) {
            for (DemandeUIModel demand : selectedEmails) {
                demand.removePropertyChangeListener(this.selectedDemandeChangeListener);
            }
        }
        JTree tree = ((DemandeListUI)this.getUI()).getNavigationTree();
        List<MailFolder> folders = FaxToMailUIUtil.getExpandedFolders(tree);
        this.getContext().setListExpandedFolders(folders);
        JRootPane rootPane = this.getContext().getMainUI().getRootPane();
        rootPane.getInputMap(2).remove(KeyStroke.getKeyStroke(REFRESH_KEY));
        rootPane.getActionMap().remove(REFRESH_FOLDER_ACTION);
        this.getContext().removePropertyChangeListener("actionInProgress", this.actionInProgressListener);
    }

    public boolean quitUI() {
        return true;
    }

    public SwingValidator<DemandeListUIModel> getValidator() {
        return null;
    }

    protected void beforeOpenPopup(int rowIndex, int columnIndex) {
        super.beforeOpenPopup(rowIndex, columnIndex);
        int selectedRowCount = ((DemandeListUI)this.getUI()).getDataTable().getSelectedRowCount();
        DemandeListUIModel model = (DemandeListUIModel)((Object)this.getModel());
        model.setReplyEnabled(selectedRowCount == 1 && model.getSelectedEmails().get(0).isEditable() && this.isActionEnabled(model.getSelectedEmails().get(0), MailAction.REPLY, this.config));
        model.setArchiveEnabled(selectedRowCount > 0);
        model.setTransmitEnabled(selectedRowCount > 0);
        model.setPrintEnabled(selectedRowCount > 0);
    }

    public void autoSelectNodeInTree(MouseEvent e, JPopupMenu popup) {
        boolean rightClick = SwingUtilities.isRightMouseButton(e);
        if (rightClick) {
            JTree source = (JTree)e.getSource();
            int rowIndex = source.getClosestRowForLocation(e.getX(), e.getY());
            if (log.isDebugEnabled()) {
                log.debug((Object)("At point [" + e.getPoint() + "] found Row " + rowIndex));
            }
            if (rowIndex == -1) {
                source.clearSelection();
            } else {
                source.setSelectionRow(rowIndex);
            }
            popup.show(source, e.getX(), e.getY());
        }
    }

    public void computeQuantitiesByRange() {
        QuantitiesByRangeUI dialogContent = new QuantitiesByRangeUI((FaxToMailUI)this.ui);
        this.getContext().getActionEngine().runAction((AbstractApplicationAction)new ComputeQuantitiesByRangeAction(dialogContent.getHandler()));
    }

    public void newDemand() {
        FaxToMailUser currentUser = this.getContext().getCurrentUser();
        Date now = new Date();
        ArrayList<History> histories = new ArrayList<History>();
        DemandeUIModel email = new DemandeUIModel();
        HistoryImpl history = new HistoryImpl();
        history.setFaxToMailUser(currentUser);
        history.setType(HistoryType.CREATION);
        history.setModificationDate(now);
        histories.add((History)history);
        history = new HistoryImpl();
        history.setFaxToMailUser(currentUser);
        history.setType(HistoryType.OPENING);
        history.setModificationDate(now);
        histories.add((History)history);
        email.setMailFolder(((DemandeListUIModel)((Object)this.getModel())).getSelectedFolder());
        email.setReceptionDate(now);
        email.setTakenBy(currentUser);
        email.setHistory(histories);
        email.setDemandStatus(DemandStatus.UNTREATED);
        OriginalEmailImpl originalEmail = new OriginalEmailImpl();
        originalEmail.setContent("");
        email.setOriginalEmail((OriginalEmail)originalEmail);
        this.openDemand(email);
    }

    public void print() {
        DemandeListUIModel model = (DemandeListUIModel)((Object)this.getModel());
        MailFolder selectedFolder = model.getSelectedFolder();
        while (selectedFolder.getParent() != null && selectedFolder.getPrintActionEqualTakeAction() == null) {
            selectedFolder = selectedFolder.getParent();
        }
        boolean take = Boolean.TRUE.equals(selectedFolder.getPrintActionEqualTakeAction());
        HashMultimap attachmentToPrints = HashMultimap.create();
        for (DemandeUIModel demandeUIModel : model.getSelectedEmails()) {
            List<Attachment> attachments = demandeUIModel.getAttachment();
            if (CollectionUtils.isEmpty(attachments)) {
                attachmentToPrints.put((Object)demandeUIModel, null);
                continue;
            }
            for (Attachment attachment : attachments) {
                FaxToMailUIUtil.forceAttachmentFileLoading(this.getContext(), attachment);
                AttachmentFile attachmentFile = attachment.getEditedFile();
                if (attachmentFile == null) {
                    attachmentFile = attachment.getOriginalFile();
                }
                attachmentToPrints.put((Object)demandeUIModel, (Object)attachmentFile);
            }
        }
        PrintOnDefaultPrinterAction action = new PrintOnDefaultPrinterAction(this, (Multimap<DemandeUIModel, AttachmentFile>)attachmentToPrints, take, true);
        this.getContext().getActionEngine().runAction((AbstractApplicationAction)action);
    }

    @Override
    public void reloadList() {
        this.runListAction();
    }
}

