package com.franciaflex.faxtomail.ui.swing.content.reply;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Stamp;
import com.franciaflex.faxtomail.ui.swing.content.reply.actions.SaveSigningAction;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.jaxx.application.swing.util.Cancelable;

import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since 1.4
 */
public class SigningSettingsUIHandler extends AbstractFaxToMailUIHandler<SigningSettingsUIModel, SigningSettingsUI> implements Cancelable {

    /**
     * Logger.
     */
    private static final Log log = LogFactory.getLog(SigningSettingsUIHandler.class);

    @Override
    public void beforeInit(SigningSettingsUI ui) {
        super.beforeInit(ui);

        SigningSettingsUIModel model = new SigningSettingsUIModel();
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInit(SigningSettingsUI ui) {
        initUI(ui);

        SigningSettingsUIModel model = getModel();

        model.addPropertyChangeListener(SigningSettingsUIModel.PROPERTY_SIGNINGS, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {

                List<Stamp> signings = (List<Stamp>) evt.getNewValue();
                JList<Stamp> signingList = getUI().getSigningList();
                signingList.setListData(signings.toArray(new Stamp[signings.size()]));
            }
        });

        model.addPropertyChangeListener(SigningSettingsUIModel.PROPERTY_SELECTED_SIGNING, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                getUI().getSigningList().setSelectedValue(evt.getNewValue(), true);
            }
        });

        Collection<Stamp> stampSigning = getContext().getCurrentUser().getSignings();
        model.setSignings(stampSigning);

        JList<Stamp> signingList = getUI().getSigningList();

        Decorator<Stamp> signingDecorator = getDecorator(Stamp.class, null);
        ListCellRenderer listCellRenderer = new SigningListCellRenderer(signingDecorator);
        signingList.setCellRenderer(listCellRenderer);

        signingList.addListSelectionListener(new ListSelectionListener() {
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {

                    SigningSettingsUIModel model = getModel();
                    JList<Stamp> list = (JList<Stamp>) e.getSource();

                    if (model.isModified()) {
                        int saveAnswer = askSaveBeforeLeaving(t("faxtomail.signings.settings.saveBeforeLeaving",
                                                                model.getSelectedSigningName()));
                        switch (saveAnswer) {
                            case JOptionPane.CANCEL_OPTION:
                                model.setModified(false); // don't cause yet another prompt when reverting selection
                                list.setSelectedValue(model.getSelectedSigning(), true);
                                model.setModified(true);
                                return;

                            case JOptionPane.YES_OPTION:
                                getContext().getActionEngine().runActionAndWait(SigningSettingsUIHandler.this, SaveSigningAction.class);
                                break;

                            case JOptionPane.NO_OPTION:
                                model.resetSelectedSigning();
                                break;
                        }
                    }

                    Stamp selectedValue = list.getSelectedValue();
                    model.setSelectedSigning(selectedValue);
                    model.setSelectedSigningDefault(selectedValue != null &&
                                                            selectedValue.equals(getContext().getCurrentUser().getDefaultSigning()));
                }
            }
        });

    }

    @Override
    public void cancel() {
        getParentContainer(Dialog.class).setVisible(false);
    }

    @Override
    public void onCloseUI() {
    }


    @Override
    public Component getTopestUI() {
        return getUI();
    }

    @Override
    public SwingValidator<SigningSettingsUIModel> getValidator() {
        return getUI().getValidator();
    }

    @Override
    protected JComponent getComponentToFocus() {
        return null;
    }

    private class SigningListCellRenderer extends DecoratorListCellRenderer {

        public SigningListCellRenderer(Decorator<Stamp> decorator) {
            super(decorator);
        }

        @Override
        protected Object decorateValue(Object value, int index) {
            String label = (String) super.decorateValue(value, index);
            Stamp signing = (Stamp) value;
            if (signing != null && signing.equals(getContext().getCurrentUser().getDefaultSigning())) {
                label = "<html><strong>" + label + "</strong></html>";
            }
            return label;
        }
    }
}
