package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id: ClientTopiaDao.java 660 2014-10-02 11:30:33Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-1.0/faxtomail-persistence/src/main/java/com/franciaflex/faxtomail/persistence/entities/ClientTopiaDao.java $
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Preconditions;

public class ClientTopiaDao extends AbstractClientTopiaDao<Client> {

    protected List<Client> forPropertyJsonLike(String property, String value) {
        Preconditions.checkArgument(StringUtils.isNotBlank(value), "Empty value can produce unexcepted results");

        String query = "FROM " + Client.class.getName() + " WHERE " + property + " LIKE :propValue";

        Map<String, Object> args = new HashMap<>();
        args.put("propValue", "%\"" + value + "\"%");
        List<Client> result = findAll(query, args);
        return result;
    }

    public List<Client> forEmailAddressesJsonLike(String emailAddress) {
        List<Client> result = forPropertyJsonLike(Client.PROPERTY_EMAIL_ADDRESSES_JSON, emailAddress);
        return result;
    }

    public List<Client> forFaxNumbersJsonLike(String faxNumber) {
        List<Client> result = forPropertyJsonLike(Client.PROPERTY_FAX_NUMBERS_JSON, faxNumber);
        return result;
    }

} //ClientTopiaDao
