/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyObsoleteException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.jdbc.WikittyJDBCUtil;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittyExtensionStorage;
import org.nuiton.wikitty.storage.WikittyStorage;

public class WikittyStorageJDBC
implements WikittyStorage {
    protected static Log log = LogFactory.getLog(WikittyStorageJDBC.class);
    protected final Properties jdbcQuery;
    protected ApplicationConfig config;
    private static final Pattern listFieldPattern = Pattern.compile("(.*)\\[(\\d+)/(\\d+)\\]");
    protected WikittyExtensionStorage extensionStorage;

    public WikittyStorageJDBC(ApplicationConfig config, WikittyExtensionStorage extensionStorage) {
        this.config = config;
        this.extensionStorage = extensionStorage;
        this.jdbcQuery = WikittyJDBCUtil.loadQuery(config);
        this.checkTableOrCreation();
        this.checkColumnBinaryOrAlter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTableOrCreation() {
        Connection connectionTest = WikittyJDBCUtil.getJDBCConnection(this.config);
        try {
            Statement statementTest = connectionTest.createStatement();
            statementTest.execute(this.jdbcQuery.getProperty("jdbc.queries.creation.wikitty.admin.test"));
            statementTest.execute(this.jdbcQuery.getProperty("jdbc.queries.creation.wikitty.data.test"));
        }
        catch (SQLException silentError) {
            if (log.isInfoEnabled()) {
                log.info((Object)"try to create wikitty database");
            }
            Connection connection = WikittyJDBCUtil.getConnection(this.config);
            try {
                Statement statement = connection.createStatement();
                statement.execute(this.jdbcQuery.getProperty("jdbc.queries.creation.wikitty.admin"));
                statement.execute(this.jdbcQuery.getProperty("jdbc.queries.creation.wikitty.data"));
                WikittyJDBCUtil.commitJDBCConnection(connection);
            }
            catch (SQLException eee) {
                WikittyJDBCUtil.rollbackJDBCConnection(connection);
                throw new WikittyException("Can't create table for wikitty storage", (Throwable)eee);
            }
            finally {
                WikittyJDBCUtil.closeQuietly(connection);
            }
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connectionTest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkColumnBinaryOrAlter() {
        Connection connectionTest = WikittyJDBCUtil.getJDBCConnection(this.config);
        try {
            Statement statementTest = connectionTest.createStatement();
            statementTest.execute(this.jdbcQuery.getProperty("jdbc.queries.creation.wikitty.data.test.binary"));
        }
        catch (SQLException silentError) {
            if (log.isInfoEnabled()) {
                log.info((Object)"try to alter wikitty database to add binary column");
            }
            Connection connection = WikittyJDBCUtil.getConnection(this.config);
            try {
                Statement statement = connection.createStatement();
                statement.execute(this.jdbcQuery.getProperty("jdbc.queries.creation.wikitty.data.alter.binary"));
                WikittyJDBCUtil.commitJDBCConnection(connection);
            }
            catch (SQLException eee) {
                WikittyJDBCUtil.rollbackJDBCConnection(connection);
                log.fatal((Object)"Can add column to store binary field. You can't use binary", (Throwable)eee);
            }
            finally {
                WikittyJDBCUtil.closeQuietly(connection);
            }
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connectionTest);
        }
    }

    protected String getColName(FieldType.TYPE type) {
        String result;
        switch (type) {
            case BINARY: {
                result = "binaryValue";
                break;
            }
            case BOOLEAN: {
                result = "booleanValue";
                break;
            }
            case DATE: {
                result = "dateValue";
                break;
            }
            case NUMERIC: {
                result = "numberValue";
                break;
            }
            default: {
                result = "textValue";
            }
        }
        return result;
    }

    public WikittyEvent store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean force) throws WikittyException {
        Connection connection = WikittyJDBCUtil.getConnection(this.config);
        try {
            WikittyEvent result = new WikittyEvent((Object)this);
            for (Wikitty wikitty : wikitties) {
                String query = String.format(this.jdbcQuery.getProperty("jdbc.queries.select.two.where"), "version", "deletionDate", WikittyJDBCUtil.TABLE_WIKITTY_ADMIN, "id");
                PreparedStatement statement = connection.prepareStatement(query);
                statement.setString(1, wikitty.getId());
                ResultSet versionResultSet = statement.executeQuery();
                String extensionList = "";
                boolean wikittyAlreadyExists = versionResultSet.next();
                String actualVersion = null;
                Date deletionDate = null;
                String requestedVersion = wikitty.getVersion();
                if (wikittyAlreadyExists) {
                    actualVersion = versionResultSet.getString("version");
                    deletionDate = versionResultSet.getDate("deletionDate");
                }
                String newVersion = null;
                if (force) {
                    newVersion = WikittyUtil.versionGreaterThan((String)requestedVersion, (String)actualVersion) ? requestedVersion : WikittyUtil.incrementMajorRevision((String)actualVersion);
                } else {
                    if (WikittyUtil.versionEquals((String)actualVersion, (String)requestedVersion) && deletionDate == null) continue;
                    if (WikittyUtil.versionGreaterThan((String)actualVersion, (String)requestedVersion)) {
                        throw new WikittyObsoleteException(String.format("Your wikitty '%s' is obsolete", wikitty.getId()));
                    }
                    newVersion = WikittyUtil.incrementMajorRevision((String)actualVersion);
                }
                if (wikittyAlreadyExists) {
                    WikittyJDBCUtil.doQuery(connection, this.jdbcQuery.getProperty("jdbc.queries.delete.wikitty.data"), wikitty.getId());
                } else {
                    WikittyJDBCUtil.doQuery(connection, this.jdbcQuery.getProperty("jdbc.queries.insert.wikitty.admin"), wikitty.getId(), newVersion, "");
                }
                for (WikittyExtension ext : wikitty.getExtensions()) {
                    extensionList = extensionList + "," + ext.getId();
                    for (String fieldName : ext.getFieldNames()) {
                        FieldType type = ext.getFieldType(fieldName);
                        if (type.isCollection()) {
                            List list = wikitty.getFieldAsList(ext.getName(), fieldName, Object.class);
                            if (list != null) {
                                for (int i = 0; i < list.size(); ++i) {
                                    Object value = list.get(i);
                                    String colName = this.getColName(type.getType());
                                    String q = String.format(this.jdbcQuery.getProperty("jdbc.queries.insert.wikitty.data"), colName);
                                    WikittyJDBCUtil.doQuery(connection, q, wikitty.getId(), ext.getName() + "." + fieldName + "[" + i + "/" + list.size() + "]", value);
                                }
                                continue;
                            }
                            if (!type.isNotNull()) continue;
                            throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, ext.getName()));
                        }
                        Object value = wikitty.getFieldAsObject(ext.getName(), fieldName);
                        if (value != null) {
                            String colName = this.getColName(type.getType());
                            String q = String.format(this.jdbcQuery.getProperty("jdbc.queries.insert.wikitty.data"), colName);
                            WikittyJDBCUtil.doQuery(connection, q, wikitty.getId(), ext.getName() + "." + fieldName, value);
                            continue;
                        }
                        if (!type.isNotNull()) continue;
                        throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, ext.getName()));
                    }
                }
                if (extensionList.length() > 0) {
                    extensionList = extensionList.substring(1);
                }
                String q = this.jdbcQuery.getProperty("jdbc.queries.update.wikitty.admin");
                WikittyJDBCUtil.doQuery(connection, q, newVersion, extensionList, null, wikitty.getId());
                Wikitty newWikitty = wikitty.clone();
                newWikitty.setVersion(newVersion);
                newWikitty.clearDirty();
                result.addWikitty(newWikitty);
            }
            WikittyEvent wikittyEvent = result;
            return wikittyEvent;
        }
        catch (WikittyException eee) {
            throw eee;
        }
        catch (Exception eee) {
            throw new WikittyException("Can't store wikitty", (Throwable)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public boolean exists(WikittyTransaction transaction, String id) {
        Connection connection = WikittyJDBCUtil.getConnection(this.config);
        try {
            boolean result;
            String q = String.format(this.jdbcQuery.getProperty("jdbc.queries.select.where"), "id", WikittyJDBCUtil.TABLE_WIKITTY_ADMIN, "id");
            PreparedStatement statement = connection.prepareStatement(q);
            statement.setString(1, id);
            ResultSet resultSet = statement.executeQuery();
            boolean bl = result = resultSet.next();
            return bl;
        }
        catch (SQLException eee) {
            throw new WikittyException("Can't test wikitty existance", (Throwable)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public boolean isDeleted(WikittyTransaction transaction, String id) {
        Connection connection = WikittyJDBCUtil.getConnection(this.config);
        try {
            String q = String.format(this.jdbcQuery.getProperty("jdbc.queries.select.where"), "deletionDate", WikittyJDBCUtil.TABLE_WIKITTY_ADMIN, "id");
            PreparedStatement statement = connection.prepareStatement(q);
            statement.setString(1, id);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                boolean result;
                boolean bl = result = resultSet.getDate("deletionDate") != null;
                return bl;
            }
            try {
                throw new WikittyException(String.format("Wikitty with id '%s' doesn't exists", id));
            }
            catch (SQLException eee) {
                throw new WikittyException("Can't test if wikitty is already deleted", (Throwable)eee);
            }
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public Wikitty restore(WikittyTransaction transaction, String id, String ... fqFieldName) throws WikittyException {
        Connection connection = WikittyJDBCUtil.getConnection(this.config);
        try {
            String q = String.format(this.jdbcQuery.getProperty("jdbc.queries.select.where.notdeleted"), "*", WikittyJDBCUtil.TABLE_WIKITTY_ADMIN, "id");
            PreparedStatement statement = connection.prepareStatement(q);
            statement.setString(1, id);
            ResultSet adminResultSet = statement.executeQuery();
            if (adminResultSet.next()) {
                Wikitty result;
                String version = adminResultSet.getString("version");
                String extensionList = adminResultSet.getString("extension_list");
                String qdata = String.format(this.jdbcQuery.getProperty("jdbc.queries.select.where"), "*", WikittyJDBCUtil.TABLE_WIKITTY_DATA, "id");
                PreparedStatement sta = connection.prepareStatement(qdata);
                sta.setString(1, id);
                ResultSet dataResultSet = sta.executeQuery();
                Wikitty wikitty = result = this.constructWikitty(transaction, id, version, extensionList, dataResultSet, fqFieldName);
                return wikitty;
            }
            try {
                throw new WikittyException(String.format("Can't restore wikitty '%s'", id));
            }
            catch (SQLException eee) {
                throw new WikittyException(String.format("Can't restore wikitty '%s'", id), (Throwable)eee);
            }
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public WikittyEvent delete(WikittyTransaction transaction, Collection<String> ids) throws WikittyException {
        Connection connection = WikittyJDBCUtil.getConnection(this.config);
        try {
            WikittyEvent result = new WikittyEvent((Object)this);
            java.util.Date now = new java.util.Date();
            for (String id : ids) {
                if (!this.exists(transaction, id) || this.isDeleted(transaction, id)) continue;
                WikittyJDBCUtil.doQuery(connection, this.jdbcQuery.getProperty("jdbc.queries.delete.wikitty.admin"), id);
                result.addRemoveDate(id, now);
            }
            WikittyEvent wikittyEvent = result;
            return wikittyEvent;
        }
        catch (SQLException eee) {
            throw new WikittyException("Can't delete wikitty", (Throwable)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public void scanWikitties(WikittyTransaction transaction, WikittyStorage.Scanner scanner) {
        Connection connection = WikittyJDBCUtil.getConnection(this.config);
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(String.format(this.jdbcQuery.getProperty("jdbc.queries.select.notdeleted"), "id", WikittyJDBCUtil.TABLE_WIKITTY_ADMIN));
            while (resultSet.next()) {
                String id = resultSet.getString("id");
                scanner.scan(id);
            }
        }
        catch (SQLException eee) {
            throw new WikittyException("Can't scan whole wikitty", (Throwable)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    protected Wikitty constructWikitty(WikittyTransaction transaction, String id, String version, String extensionList, ResultSet resultSet, String ... fqFieldName) throws SQLException {
        HashSet<String> acceptedField = new HashSet<String>(Arrays.asList(fqFieldName));
        WikittyImpl result = new WikittyImpl(id);
        result.setVersion(version);
        if (extensionList != null && !"".equals(extensionList)) {
            for (String ext : extensionList.split(",")) {
                String extName = WikittyExtension.computeName((String)ext);
                String extVersion = WikittyExtension.computeVersion((String)ext);
                WikittyExtension extension = this.extensionStorage.restore(transaction, extName, extVersion);
                result.addExtension(extension);
            }
        }
        HashMap<String, Object[]> listFieldMap = new HashMap<String, Object[]>();
        while (resultSet.next()) {
            String fqfieldName = resultSet.getString("fieldName");
            if (!this.isAcceptedField(acceptedField, fqfieldName)) continue;
            FieldType type = result.getFieldType(fqfieldName);
            Object value = null;
            switch (type.getType()) {
                case BINARY: {
                    InputStream blob = resultSet.getBinaryStream("binaryValue");
                    try {
                        value = IOUtils.toByteArray((InputStream)blob);
                        break;
                    }
                    catch (IOException eee) {
                        throw new WikittyException("Can't read blob stream for database", (Throwable)eee);
                    }
                }
                case BOOLEAN: {
                    value = resultSet.getBoolean("booleanValue");
                    break;
                }
                case DATE: {
                    Timestamp timestamp = resultSet.getTimestamp("dateValue");
                    if (timestamp == null) break;
                    value = new java.util.Date(timestamp.getTime());
                    break;
                }
                case NUMERIC: {
                    value = resultSet.getBigDecimal("numberValue");
                    break;
                }
                case STRING: {
                    value = resultSet.getString("textValue");
                    break;
                }
                case WIKITTY: {
                    value = resultSet.getString("textValue");
                    break;
                }
                default: {
                    value = resultSet.getString("textValue");
                }
            }
            if (type.isCollection()) {
                Matcher match = listFieldPattern.matcher(fqfieldName);
                if (match.find()) {
                    fqfieldName = match.group(1);
                    int index = Integer.parseInt(match.group(2));
                    Object[] array = (Object[])listFieldMap.get(fqfieldName);
                    if (array == null) {
                        int size = Integer.parseInt(match.group(3));
                        array = new Object[size];
                        listFieldMap.put(fqfieldName, array);
                    }
                    array[index] = value;
                    continue;
                }
                if (!log.isErrorEnabled()) continue;
                log.error((Object)String.format("Can't read list field correctly '%s'", fqfieldName));
                continue;
            }
            result.setFqField(fqfieldName, value);
        }
        for (String fieldName : listFieldMap.keySet()) {
            Object[] array = (Object[])listFieldMap.get(fieldName);
            FieldType type = result.getFieldType(fieldName);
            if (type.isUnique()) {
                HashSet<Object> set = new HashSet<Object>(Arrays.asList(array));
                result.setFqField(fieldName, set);
                continue;
            }
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(array));
            result.setFqField(fieldName, list);
        }
        return result;
    }

    protected boolean isAcceptedField(Set<String> acceptedField, String fqfieldName) {
        boolean result = acceptedField.isEmpty();
        if (!result) {
            int crochet = fqfieldName.indexOf("[");
            if (crochet != -1) {
                fqfieldName = fqfieldName.substring(0, crochet);
            }
            result = acceptedField.contains(fqfieldName);
        }
        return result;
    }

    public WikittyEvent clear(WikittyTransaction transaction) {
        Connection connection = WikittyJDBCUtil.getConnection(this.config);
        try {
            WikittyJDBCUtil.doQuery(connection, this.jdbcQuery.getProperty("jdbc.queries.clear.wikitty"), new Object[0]);
            WikittyEvent result = new WikittyEvent((Object)this);
            result.addType(WikittyEvent.WikittyEventType.CLEAR_WIKITTY);
            WikittyEvent wikittyEvent = result;
            return wikittyEvent;
        }
        catch (SQLException eee) {
            throw new WikittyException("Can't clear wikitty data", (Throwable)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikittyStorage.DataStatistic getDataStatistic(WikittyTransaction transaction) {
        WikittyStorage.DataStatistic result;
        Connection connection = WikittyJDBCUtil.getConnection(this.config);
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(this.jdbcQuery.getProperty("jdbc.queries.select.count.active.wikitties"));
            long activeWikitties = resultSet.getLong(1);
            resultSet = statement.executeQuery(this.jdbcQuery.getProperty("jdbc.queries.select.count.deleted.wikitties"));
            long deletedWikitties = resultSet.getLong(1);
            result = new WikittyStorage.DataStatistic(activeWikitties, deletedWikitties);
        }
        catch (SQLException eee) {
            result = new WikittyStorage.DataStatistic();
            log.warn((Object)"Can't retrieve statisticn data", (Throwable)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
        return result;
    }
}

