/*
 * #%L
 * Wikitty :: wikitty-jdbc-impl
 * 
 * $Id: WikittyServiceJDBC.java 619 2010-12-17 16:33:52Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.2/wikitty-jdbc-impl/src/main/java/org/nuiton/wikitty/jdbc/WikittyServiceJDBC.java $
 * %%
 * Copyright (C) 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.wikitty.jdbc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.services.WikittyServiceStorage;
import org.nuiton.wikitty.storage.solr.WikittySearchEngineSolr;

/**
 * @author poussin
 * @version $Revision: 619 $
 *
 * Last update: $Date: 2010-12-17 17:33:52 +0100 (ven., 17 déc. 2010) $
 * by : $Author: bpoussin $
 * @deprecated use WikittyServiceFactory is good config file
 * @see WikittyServiceFactory
 */
public class WikittyServiceJDBC extends WikittyServiceStorage {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyServiceJDBC.class);

    public WikittyServiceJDBC(ApplicationConfig config) {
        extensionStorage = new WikittyExtensionStorageJDBC(config);
        wikittyStorage = new WikittyStorageJDBC(config, extensionStorage);
        searchEngine = new WikittySearchEngineSolr(config, extensionStorage);
    }

}
