package org.nuiton.topia.security.entities.authorization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaSecurityDAOHelper.TopiaSecurityEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class TopiaAuthorizationDAOAbstract<E extends TopiaAuthorization> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)TopiaAuthorization.class;
    }

    @Override
    public TopiaSecurityEntityEnum getTopiaEntityEnum() {
        return TopiaSecurityEntityEnum.TopiaAuthorization;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //TopiaAuthorizationDAOAbstract<E extends TopiaAuthorization>
