/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.security;

import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaSecurityDAOHelper;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.event.TopiaEntityVetoable;
import org.nuiton.topia.event.TopiaTransactionEvent;
import org.nuiton.topia.event.TopiaTransactionVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.security.TopiaSecurityService;
import org.nuiton.topia.security.entities.authorization.TopiaAssociationAuthorizationDAO;
import org.nuiton.topia.security.entities.authorization.TopiaAuthorization;
import org.nuiton.topia.security.entities.authorization.TopiaAuthorizationDAO;
import org.nuiton.topia.security.entities.authorization.TopiaEntityAuthorizationDAO;
import org.nuiton.topia.security.entities.authorization.TopiaEntityAuthorizationImpl;
import org.nuiton.topia.security.entities.authorization.TopiaExpressionLink;
import org.nuiton.topia.security.entities.authorization.TopiaExpressionLinkDAO;
import org.nuiton.topia.security.entities.user.TopiaGroupDAO;
import org.nuiton.topia.security.entities.user.TopiaUser;
import org.nuiton.topia.security.entities.user.TopiaUserDAO;
import org.nuiton.topia.security.jaas.TopiaConfiguration;
import org.nuiton.topia.security.jaas.TopiaPermission;
import org.nuiton.topia.security.jaas.TopiaPolicy;
import org.nuiton.topia.security.listener.EntityVetoable;
import org.nuiton.topia.security.listener.NoSecurityLoad;
import org.nuiton.topia.security.listener.PropertyReadListener;
import org.nuiton.topia.security.listener.PropertyVetoable;
import org.nuiton.topia.security.listener.PropertyWriteListener;
import org.nuiton.topia.security.util.TopiaSecurityCaching;
import org.nuiton.topia.security.util.TopiaSecurityUtil;

public class TopiaSecurityServiceImpl
implements TopiaSecurityService,
TopiaTransactionVetoable {
    private static Log log = LogFactory.getLog(TopiaSecurityServiceImpl.class);
    private TopiaContext rootContext;
    private TopiaContext securityContext;
    private EntityVetoable entityVetoable = new EntityVetoable(this);
    private PropertyReadListener read = new PropertyReadListener(this);
    private PropertyWriteListener write = new PropertyWriteListener(this);
    private PropertyVetoable propertyVetoable = new PropertyVetoable(this.read, this.write);
    private TopiaPolicy policy = new TopiaPolicy(this);
    private transient TopiaSecurityCaching entitiesLoadingCache = new TopiaSecurityCaching(2);
    private transient Map<String, Permission> authorizationsCache = Collections.synchronizedMap(new ReferenceMap(1, 1));
    private transient Map<String, Set<Permission>> permissionsCache = Collections.synchronizedMap(new ReferenceMap(1, 1));

    public String getServiceName() {
        return "security";
    }

    public Class<?>[] getPersistenceClasses() {
        return TopiaSecurityUtil.TOPIA_SECURITY_PERSISTENCE_CLASSES;
    }

    public boolean preInit(TopiaContextImplementor context) {
        return true;
    }

    public boolean postInit(TopiaContextImplementor context) {
        this.rootContext = context;
        this.securityContext = null;
        this.rootContext.addTopiaEntityVetoable((TopiaEntityVetoable)this.entityVetoable);
        this.rootContext.addTopiaEntityListener((TopiaEntityListener)this.propertyVetoable);
        this.rootContext.addTopiaTransactionVetoable((TopiaTransactionVetoable)this);
        this.policy.installPolicy();
        Configuration.setConfiguration(new TopiaConfiguration("topia", this));
        return true;
    }

    public void beginTransaction(TopiaTransactionEvent event) {
        TopiaContext context = event.getSource();
        context.addTopiaEntityVetoable((TopiaEntityVetoable)this.entityVetoable);
        context.addTopiaEntityListener((TopiaEntityListener)this.propertyVetoable);
        context.addTopiaTransactionVetoable((TopiaTransactionVetoable)this);
    }

    public TopiaContext getSecurityContext() throws TopiaException {
        if (this.securityContext == null) {
            this.securityContext = this.rootContext.beginTransaction();
        }
        return this.securityContext;
    }

    public TopiaUserDAO getTopiaUserDAO() {
        try {
            return TopiaSecurityDAOHelper.getTopiaUserDAO(this.getSecurityContext());
        }
        catch (TopiaException te) {
            log.error((Object)"Recuperation du TopiaUserDAO impossible", (Throwable)te);
            return null;
        }
    }

    public TopiaGroupDAO getTopiaGroupDAO() {
        try {
            return TopiaSecurityDAOHelper.getTopiaGroupDAO(this.getSecurityContext());
        }
        catch (TopiaException te) {
            log.error((Object)"Recuperation du TopiaGroupDAO impossible", (Throwable)te);
            return null;
        }
    }

    public TopiaAuthorizationDAO getTopiaAuthorizationDAO() {
        try {
            return TopiaSecurityDAOHelper.getTopiaAuthorizationDAO(this.getSecurityContext());
        }
        catch (TopiaException te) {
            log.error((Object)"Recuperation du TopiaAuthorizationDAO impossible", (Throwable)te);
            return null;
        }
    }

    public TopiaEntityAuthorizationDAO getTopiaEntityAuthorizationDAO() {
        try {
            return TopiaSecurityDAOHelper.getTopiaEntityAuthorizationDAO(this.getSecurityContext());
        }
        catch (TopiaException te) {
            log.error((Object)"Recuperation du TopiaEntityAuthorizationDAO impossible", (Throwable)te);
            return null;
        }
    }

    public TopiaExpressionLinkDAO getTopiaIdLinkDAO() {
        try {
            return TopiaSecurityDAOHelper.getTopiaExpressionLinkDAO(this.getSecurityContext());
        }
        catch (TopiaException te) {
            log.error((Object)"Recuperation du TopiaLinkAuthorizationDAO impossible", (Throwable)te);
            return null;
        }
    }

    public TopiaAssociationAuthorizationDAO getTopiaAssociationAuthorizationDAO() {
        try {
            return TopiaSecurityDAOHelper.getTopiaAssociationAuthorizationDAO(this.getSecurityContext());
        }
        catch (TopiaException te) {
            log.error((Object)"Recuperation du TopiaAssociationAuthorizationDAO impossible", (Throwable)te);
            return null;
        }
    }

    public Set<Permission> putPermissionsCache(String principalName) throws TopiaException {
        TopiaAuthorizationDAO authorizationDAO = this.getTopiaAuthorizationDAO();
        List authorizations = authorizationDAO.findAll();
        HashSet<Permission> permissions = new HashSet<Permission>();
        this.permissionsCache.put(principalName, permissions);
        String className = TopiaId.getClassNameAsString((String)principalName);
        boolean addEmptyPrincipals = className.equals(TopiaUser.class.getName());
        for (TopiaAuthorization authorization : authorizations) {
            Set principals = authorization.getPrincipals();
            if (!principals.contains(principalName) && (!addEmptyPrincipals || !principals.isEmpty())) continue;
            Permission permission = this.getAuthorizationCache(authorization);
            permissions.add(permission);
        }
        this.getSecurityContext().commitTransaction();
        return permissions;
    }

    private Permission getAuthorizationCache(TopiaAuthorization authorization) {
        String topiaIdAuthorization = authorization.getTopiaId();
        Permission permission = this.authorizationsCache.get(topiaIdAuthorization);
        if (permission == null) {
            permission = new TopiaPermission(authorization);
            this.authorizationsCache.put(topiaIdAuthorization, permission);
        }
        return permission;
    }

    public Set<Permission> getPermissionsCache(String principalName) {
        return this.permissionsCache.get(principalName);
    }

    public void putEntitiesLoadingCache(String topiaId, boolean authorized) {
        String userPrincipal = TopiaSecurityUtil.getUserPrincipal();
        if (userPrincipal != null) {
            this.entitiesLoadingCache.put(authorized, userPrincipal, topiaId);
        }
    }

    public Boolean getEntitiesLoadingCache(String topiaId) {
        String userPrincipal = TopiaSecurityUtil.getUserPrincipal();
        if (userPrincipal != null) {
            return (Boolean)this.entitiesLoadingCache.get(userPrincipal, topiaId);
        }
        return null;
    }

    public void removeEntitiesLoadingCache(String userPrincipal) {
        this.entitiesLoadingCache.clear(userPrincipal);
    }

    public boolean containEntitiesLoadingCache(String topiaId) {
        Boolean authorized = this.getEntitiesLoadingCache(topiaId);
        return authorized != null;
    }

    protected List<String> getRealExpressions(String topiaId) {
        try {
            ArrayList<String> allBy = this.getSecurityContext().findAll("select distinct link.by from " + TopiaExpressionLink.class.getName() + " link where link.replace=:replace", new Object[]{"replace", topiaId});
            this.getSecurityContext().commitTransaction();
            if (allBy == null) {
                allBy = new ArrayList<String>();
            }
            allBy.add(topiaId);
            return allBy;
        }
        catch (TopiaException te) {
            throw new SecurityException("Replace expression for link failed", te);
        }
    }

    protected int getRealActions(String topiaId, int actions) {
        block3: {
            try {
                Class klass = TopiaId.getClassName((String)topiaId);
                if (NoSecurityLoad.class.isAssignableFrom(klass)) {
                    actions &= 0xE;
                }
            }
            catch (TopiaNotFoundException te) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Real actions failed", (Throwable)te);
            }
        }
        return actions;
    }

    @Override
    public void checkPermission(Class<?> entityClass, int actions) throws SecurityException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Checking permissions to entity class : " + entityClass));
        }
        if (entityClass == null) {
            throw new SecurityException("Class cannot be null");
        }
        String topiaId = entityClass.getName() + "#*";
        this.checkPermission(topiaId, actions);
    }

    @Override
    public void checkPermission(String topiaId, int actions) throws SecurityException {
        int realActions = this.getRealActions(topiaId, actions);
        if (realActions != 0) {
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject != null) {
                List<String> expressions = this.getRealExpressions(topiaId);
                boolean authorized = false;
                for (String expression : expressions) {
                    TopiaEntityAuthorizationImpl authorization = new TopiaEntityAuthorizationImpl(expression, realActions, subject.getPrincipals());
                    try {
                        AccessController.checkPermission(new TopiaPermission(authorization));
                        authorized = true;
                        break;
                    }
                    catch (SecurityException se) {
                        authorized = false;
                    }
                }
                if (!authorized) {
                    throw new SecurityException("Access denied to object \"" + topiaId + "\" for \"" + subject + "\"");
                }
            } else if (log.isWarnEnabled()) {
                log.warn((Object)"Use doAs() and login first");
            }
        }
    }
}

