package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;


public  abstract class TaasUserAbstract extends TopiaEntityAbstract implements TaasUser {

    /**
     * Nom de l'attribut en BD : login

     */
    protected String login;
    /**
     * Nom de l'attribut en BD : password

     */
    protected String password;
    /**
     * Nom de l'attribut en BD : email

     */
    protected String email;
    /**
     * Nom de l'attribut en BD : enabled

     */
    protected boolean enabled;
    /**
     * Nom de l'attribut en BD : lastConnectionDate

     */
    protected Date lastConnectionDate;
    /**
     * Nom de l'attribut en BD : numberOfConnection

     */
    protected int numberOfConnection;
    /**
     * Nom de l'attribut en BD : link

     */
    protected String link;
    /**
     * Nom de l'attribut en BD : principals

     */
    protected Collection<TaasPrincipal> principals;
    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, LOGIN, String.class, login);
        visitor.visit(this, PASSWORD, String.class, password);
        visitor.visit(this, EMAIL, String.class, email);
        visitor.visit(this, ENABLED, boolean.class, enabled);
        visitor.visit(this, LAST_CONNECTION_DATE, Date.class, lastConnectionDate);
        visitor.visit(this, NUMBER_OF_CONNECTION, int.class, numberOfConnection);
        visitor.visit(this, LINK, String.class, link);
        visitor.visit(this, PRINCIPALS, Collection.class, TaasPrincipal.class, principals);
        visitor.end(this);
}

    /**
     * setLogin :
     * @param login 
     */

    @Override
    public void setLogin(String login) {
        String oldValue = this.login;
        fireOnPreWrite(LOGIN, oldValue, login);
        this.login = login;
        fireOnPostWrite(LOGIN, oldValue, login);
}

    /**
     * getLogin :
     * @return String 
     */

    @Override
    public String getLogin() {
        fireOnPreRead(LOGIN, login);
        String result = this.login;
        fireOnPostRead(LOGIN, login);
        return result;
}

    /**
     * setPassword :
     * @param password 
     */

    @Override
    public void setPassword(String password) {
        String oldValue = this.password;
        fireOnPreWrite(PASSWORD, oldValue, password);
        this.password = password;
        fireOnPostWrite(PASSWORD, oldValue, password);
}

    /**
     * getPassword :
     * @return String 
     */

    @Override
    public String getPassword() {
        fireOnPreRead(PASSWORD, password);
        String result = this.password;
        fireOnPostRead(PASSWORD, password);
        return result;
}

    /**
     * setEmail :
     * @param email 
     */

    @Override
    public void setEmail(String email) {
        String oldValue = this.email;
        fireOnPreWrite(EMAIL, oldValue, email);
        this.email = email;
        fireOnPostWrite(EMAIL, oldValue, email);
}

    /**
     * getEmail :
     * @return String 
     */

    @Override
    public String getEmail() {
        fireOnPreRead(EMAIL, email);
        String result = this.email;
        fireOnPostRead(EMAIL, email);
        return result;
}

    /**
     * setEnabled :
     * @param enabled 
     */

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldValue = this.enabled;
        fireOnPreWrite(ENABLED, oldValue, enabled);
        this.enabled = enabled;
        fireOnPostWrite(ENABLED, oldValue, enabled);
}

    /**
     * getEnabled :
     * @return boolean 
     */

    @Override
    public boolean getEnabled() {
        fireOnPreRead(ENABLED, enabled);
        boolean result = this.enabled;
        fireOnPostRead(ENABLED, enabled);
        return result;
}

    /**
     * isEnabled :
     * @return boolean 
     */

    @Override
    public boolean isEnabled() {
        fireOnPreRead(ENABLED, enabled);
        boolean result = this.enabled;
        fireOnPostRead(ENABLED, enabled);
        return result;
}

    /**
     * setLastConnectionDate :
     * @param lastConnectionDate 
     */

    @Override
    public void setLastConnectionDate(Date lastConnectionDate) {
        Date oldValue = this.lastConnectionDate;
        fireOnPreWrite(LAST_CONNECTION_DATE, oldValue, lastConnectionDate);
        this.lastConnectionDate = lastConnectionDate;
        fireOnPostWrite(LAST_CONNECTION_DATE, oldValue, lastConnectionDate);
}

    /**
     * getLastConnectionDate :
     * @return Date 
     */

    @Override
    public Date getLastConnectionDate() {
        fireOnPreRead(LAST_CONNECTION_DATE, lastConnectionDate);
        Date result = this.lastConnectionDate;
        fireOnPostRead(LAST_CONNECTION_DATE, lastConnectionDate);
        return result;
}

    /**
     * setNumberOfConnection :
     * @param numberOfConnection 
     */

    @Override
    public void setNumberOfConnection(int numberOfConnection) {
        int oldValue = this.numberOfConnection;
        fireOnPreWrite(NUMBER_OF_CONNECTION, oldValue, numberOfConnection);
        this.numberOfConnection = numberOfConnection;
        fireOnPostWrite(NUMBER_OF_CONNECTION, oldValue, numberOfConnection);
}

    /**
     * getNumberOfConnection :
     * @return int 
     */

    @Override
    public int getNumberOfConnection() {
        fireOnPreRead(NUMBER_OF_CONNECTION, numberOfConnection);
        int result = this.numberOfConnection;
        fireOnPostRead(NUMBER_OF_CONNECTION, numberOfConnection);
        return result;
}

    /**
     * setLink :
     * @param link 
     */

    @Override
    public void setLink(String link) {
        String oldValue = this.link;
        fireOnPreWrite(LINK, oldValue, link);
        this.link = link;
        fireOnPostWrite(LINK, oldValue, link);
}

    /**
     * getLink :
     * @return String 
     */

    @Override
    public String getLink() {
        fireOnPreRead(LINK, link);
        String result = this.link;
        fireOnPostRead(LINK, link);
        return result;
}

    /**
     * addPrincipals :
     * @param principals 
     */

    @Override
    public void addPrincipals(TaasPrincipal principals) {
        fireOnPreWrite(PRINCIPALS, null, principals);
        if (this.principals == null) {
            this.principals = new ArrayList<TaasPrincipal>();
        }

        this.principals.add(principals);
        fireOnPostWrite(PRINCIPALS, this.principals.size(), null, principals);
}

    /**
     * addAllPrincipals :
     * @param principals 
     */

    @Override
    public void addAllPrincipals(Collection<TaasPrincipal> principals) {
        if (principals == null) {
            return;
        }
        for (TaasPrincipal item : principals) {
            addPrincipals(item);
        }
}

    /**
     * setPrincipals :
     * @param principals 
     */

    @Override
    public void setPrincipals(Collection<TaasPrincipal> principals) {
        // Copy elements to keep data for fire with new reference
        Collection<TaasPrincipal> oldValue = this.principals != null ? new ArrayList<TaasPrincipal>(this.principals) : null;
        fireOnPreWrite(PRINCIPALS, oldValue, principals);
        this.principals = principals;
        fireOnPostWrite(PRINCIPALS, oldValue, principals);
}

    /**
     * removePrincipals :
     * @param principals 
     */

    @Override
    public void removePrincipals(TaasPrincipal principals) {
        fireOnPreWrite(PRINCIPALS, principals, null);
        if ((this.principals == null) || (!this.principals.remove(principals))) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PRINCIPALS, this.principals.size() + 1, principals, null);
}

    /**
     * clearPrincipals :
     */

    @Override
    public void clearPrincipals() {
        if (this.principals == null) {
            return;
        }
        Collection<TaasPrincipal> oldValue = new ArrayList<TaasPrincipal>(this.principals);
        fireOnPreWrite(PRINCIPALS, oldValue, this.principals);
        this.principals.clear();
        fireOnPostWrite(PRINCIPALS, oldValue, this.principals);
}

    /**
     * getPrincipals :
     * @return Collection<TaasPrincipal> 
     */

    @Override
    public Collection<TaasPrincipal> getPrincipals() {
        return principals;
}

    /**
     * getPrincipalsByTopiaId :
     * @param topiaId 
     * @return TaasPrincipal 
     */

    @Override
    public TaasPrincipal getPrincipalsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(principals, topiaId);
 }

    /**
     * sizePrincipals :
     * @return int 
     */

    @Override
    public int sizePrincipals() {
        if (principals == null) {
            return 0;
        }
        return principals.size();
}

    /**
     * isPrincipalsEmpty :
     * @return boolean 
     */

    @Override
    public boolean isPrincipalsEmpty() {
        int size = sizePrincipals();
        return size == 0;
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(LOGIN, this.login).
            append(PASSWORD, this.password).
            append(EMAIL, this.email).
            append(ENABLED, this.enabled).
            append(LAST_CONNECTION_DATE, this.lastConnectionDate).
            append(NUMBER_OF_CONNECTION, this.numberOfConnection).
            append(LINK, this.link).
            append(PRINCIPALS, this.principals).
         toString();
        return result;
}


} //TaasUserAbstract
