/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.security.entities.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.security.entities.user.TopiaGroup;
import org.nuiton.topia.security.entities.user.TopiaUser;

public abstract class TopiaGroupAbstract
extends TopiaEntityAbstract
implements TopiaGroup {
    protected String name;
    protected String description;
    protected Collection<TopiaUser> topiaUser;
    protected TopiaGroup superGroup;
    protected Collection<TopiaGroup> subGroup;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "description", String.class, (Object)this.description);
        visitor.visit((TopiaEntity)this, "topiaUser", Collection.class, TopiaUser.class, this.topiaUser);
        visitor.visit((TopiaEntity)this, "superGroup", TopiaGroup.class, (Object)this.superGroup);
        visitor.visit((TopiaEntity)this, "subGroup", Collection.class, TopiaGroup.class, this.subGroup);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.fireOnPreWrite("name", oldValue, name);
        this.name = name;
        this.fireOnPostWrite("name", oldValue, name);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void setDescription(String description) {
        String oldValue = this.description;
        this.fireOnPreWrite("description", oldValue, description);
        this.description = description;
        this.fireOnPostWrite("description", oldValue, description);
    }

    @Override
    public String getDescription() {
        this.fireOnPreRead("description", this.description);
        String result = this.description;
        this.fireOnPostRead("description", this.description);
        return result;
    }

    @Override
    public void addTopiaUser(TopiaUser topiaUser) {
        this.fireOnPreWrite("topiaUser", null, topiaUser);
        if (this.topiaUser == null) {
            this.topiaUser = new ArrayList<TopiaUser>();
        }
        if (topiaUser.getTopiaGroup() == null) {
            topiaUser.setTopiaGroup(new ArrayList<TopiaGroup>());
        }
        topiaUser.getTopiaGroup().add(this);
        this.topiaUser.add(topiaUser);
        this.fireOnPostWrite("topiaUser", this.topiaUser.size(), null, topiaUser);
    }

    @Override
    public void addAllTopiaUser(Collection<TopiaUser> topiaUser) {
        if (topiaUser == null) {
            return;
        }
        for (TopiaUser item : topiaUser) {
            this.addTopiaUser(item);
        }
    }

    @Override
    public void setTopiaUser(Collection<TopiaUser> topiaUser) {
        ArrayList<TopiaUser> oldValue = this.topiaUser != null ? new ArrayList<TopiaUser>(this.topiaUser) : null;
        this.fireOnPreWrite("topiaUser", oldValue, topiaUser);
        this.topiaUser = topiaUser;
        this.fireOnPostWrite("topiaUser", oldValue, topiaUser);
    }

    @Override
    public void removeTopiaUser(TopiaUser topiaUser) {
        this.fireOnPreWrite("topiaUser", topiaUser, null);
        if (this.topiaUser == null || !this.topiaUser.remove(topiaUser)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        topiaUser.getTopiaGroup().remove(this);
        this.fireOnPostWrite("topiaUser", this.topiaUser.size() + 1, topiaUser, null);
    }

    @Override
    public void clearTopiaUser() {
        if (this.topiaUser == null) {
            return;
        }
        for (TopiaUser item : this.topiaUser) {
            item.getTopiaGroup().remove(this);
        }
        ArrayList<TopiaUser> oldValue = new ArrayList<TopiaUser>(this.topiaUser);
        this.fireOnPreWrite("topiaUser", oldValue, this.topiaUser);
        this.topiaUser.clear();
        this.fireOnPostWrite("topiaUser", oldValue, this.topiaUser);
    }

    @Override
    public Collection<TopiaUser> getTopiaUser() {
        return this.topiaUser;
    }

    @Override
    public TopiaUser getTopiaUserByTopiaId(String topiaId) {
        return (TopiaUser)TopiaEntityHelper.getEntityByTopiaId(this.topiaUser, (String)topiaId);
    }

    @Override
    public int sizeTopiaUser() {
        if (this.topiaUser == null) {
            return 0;
        }
        return this.topiaUser.size();
    }

    @Override
    public boolean isTopiaUserEmpty() {
        int size = this.sizeTopiaUser();
        return size == 0;
    }

    @Override
    public void setSuperGroup(TopiaGroup superGroup) {
        TopiaGroup oldValue = this.superGroup;
        this.fireOnPreWrite("superGroup", oldValue, superGroup);
        this.superGroup = superGroup;
        this.fireOnPostWrite("superGroup", oldValue, superGroup);
    }

    @Override
    public TopiaGroup getSuperGroup() {
        this.fireOnPreRead("superGroup", this.superGroup);
        TopiaGroup result = this.superGroup;
        this.fireOnPostRead("superGroup", this.superGroup);
        return result;
    }

    @Override
    public void addSubGroup(TopiaGroup subGroup) {
        this.fireOnPreWrite("subGroup", null, subGroup);
        if (this.subGroup == null) {
            this.subGroup = new ArrayList<TopiaGroup>();
        }
        subGroup.setSuperGroup(this);
        this.subGroup.add(subGroup);
        this.fireOnPostWrite("subGroup", this.subGroup.size(), null, subGroup);
    }

    @Override
    public void addAllSubGroup(Collection<TopiaGroup> subGroup) {
        if (subGroup == null) {
            return;
        }
        for (TopiaGroup item : subGroup) {
            this.addSubGroup(item);
        }
    }

    @Override
    public void setSubGroup(Collection<TopiaGroup> subGroup) {
        ArrayList<TopiaGroup> oldValue = this.subGroup != null ? new ArrayList<TopiaGroup>(this.subGroup) : null;
        this.fireOnPreWrite("subGroup", oldValue, subGroup);
        this.subGroup = subGroup;
        this.fireOnPostWrite("subGroup", oldValue, subGroup);
    }

    @Override
    public void removeSubGroup(TopiaGroup subGroup) {
        this.fireOnPreWrite("subGroup", subGroup, null);
        if (this.subGroup == null || !this.subGroup.remove(subGroup)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        subGroup.setSuperGroup(null);
        this.fireOnPostWrite("subGroup", this.subGroup.size() + 1, subGroup, null);
    }

    @Override
    public void clearSubGroup() {
        if (this.subGroup == null) {
            return;
        }
        for (TopiaGroup item : this.subGroup) {
            item.setSuperGroup(null);
        }
        ArrayList<TopiaGroup> oldValue = new ArrayList<TopiaGroup>(this.subGroup);
        this.fireOnPreWrite("subGroup", oldValue, this.subGroup);
        this.subGroup.clear();
        this.fireOnPostWrite("subGroup", oldValue, this.subGroup);
    }

    @Override
    public Collection<TopiaGroup> getSubGroup() {
        return this.subGroup;
    }

    @Override
    public TopiaGroup getSubGroupByTopiaId(String topiaId) {
        return (TopiaGroup)TopiaEntityHelper.getEntityByTopiaId(this.subGroup, (String)topiaId);
    }

    @Override
    public int sizeSubGroup() {
        if (this.subGroup == null) {
            return 0;
        }
        return this.subGroup.size();
    }

    @Override
    public boolean isSubGroupEmpty() {
        int size = this.sizeSubGroup();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("description", (Object)this.description).toString();
        return result;
    }
}

