/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication;

import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.it.TopiaConfigurationHelper;
import org.nuiton.topia.it.legacy.TopiaTestEntityEnum;
import org.nuiton.topia.it.legacy.test.entities.Person;
import org.nuiton.topia.it.legacy.test.entities.PersonImpl;
import org.nuiton.topia.it.legacy.test.entities.Pet;
import org.nuiton.topia.it.legacy.test.entities.PetImpl;
import org.nuiton.topia.it.legacy.test.entities.Race;
import org.nuiton.topia.it.legacy.test.entities.RaceImpl;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaApplicationContextCache;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.replication.AbstractTopiaReplicationServiceTest;
import org.nuiton.topia.replication.TopiaReplicationModelBuilder;
import org.nuiton.topia.replication.TopiaReplicationServiceImpl;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;
import org.nuiton.topia.replication.operation.DettachAssociation;
import org.nuiton.topia.replication.operation.Duplicate;
import org.nuiton.topia.replication.operation.FakeOperation;
import org.nuiton.topia.replication.operation.UncreatableOperation;
import org.nuiton.topia.replication.operation.UnregistredOperation;

public class TopiaReplicationOperationTest
extends AbstractTopiaReplicationServiceTest {
    private static final Log log = LogFactory.getLog(TopiaReplicationOperationTest.class);
    protected static final TopiaEntityEnum[] contracts = new TopiaEntityEnum[]{TopiaTestEntityEnum.Person, TopiaTestEntityEnum.Pet, TopiaTestEntityEnum.Race};
    protected static final String entitiesList = PersonImpl.class.getName() + "," + PetImpl.class.getName() + "," + RaceImpl.class.getName();
    protected static Person person;
    protected static Person person2;
    protected static Pet pet;
    protected static Pet pet2;
    protected static Race race;
    protected static Race race2;
    protected static File tesDir;

    @BeforeClass
    public static void beforeClass() throws IOException {
        tesDir = TopiaConfigurationHelper.getTestBasedir(TopiaReplicationOperationTest.class);
    }

    @AfterClass
    public static void after() throws Exception {
        AbstractTopiaReplicationServiceTest.after();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        person = this.update(person);
        person2 = this.update(person2);
        pet = this.update(pet);
        pet2 = this.update(pet2);
        race = this.update(race);
        race2 = this.update(race2);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.destinationContext != null && !this.destinationContext.isClosed()) {
            this.destinationContext.closeContext();
        }
    }

    @Test(expected=NullPointerException.class)
    public void testGetOperation_nullOperationClass() throws Exception {
        this.getModelBuilder().getOperationProvider().getOperation((Class)null);
    }

    @Override
    protected TopiaReplicationModelBuilder getModelBuilder() {
        return this.service.getModelBuilder();
    }

    @Override
    @Test
    public void testGetOperation() throws Exception {
        this.getOperation(UnregistredOperation.class, false);
        this.getOperation(UncreatableOperation.class, true);
        this.getOperation(FakeOperation.class, true);
        this.getOperation(Duplicate.class, true);
        this.getOperation(DettachAssociation.class, true);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateOperation_nullModel() throws Exception {
        this.getModelBuilder().createOperation(null, null, null, null, new Object[0]);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateOperation_nullType() throws Exception {
        this.model = this.getModelBuilder().createModel(sourceContext, contracts, true, new String[0]);
        this.getModelBuilder().createOperation(this.model, null, null, null, new Object[0]);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateOperation_nullPhase() throws Exception {
        this.model = this.getModelBuilder().createModel(sourceContext, contracts, true, new String[0]);
        this.getModelBuilder().createOperation(this.model, (TopiaEntityEnum)TopiaTestEntityEnum.Pet, null, null, new Object[0]);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateOperation_nullOperationClass() throws Exception {
        this.model = this.getModelBuilder().createModel(sourceContext, contracts, true, new String[0]);
        this.getModelBuilder().createOperation(this.model, (TopiaEntityEnum)TopiaTestEntityEnum.Pet, ReplicationOperationPhase.before, null, new Object[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateOperation_noNode() throws Exception {
        this.model = this.getModelBuilder().createModel(sourceContext, contracts, true, new String[0]);
        this.getModelBuilder().addAfterOperation(this.model, (TopiaEntityEnum)TopiaTestEntityEnum.Pet, Duplicate.class, new Object[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateOperation_noOperation() throws Exception {
        this.model = this.getModelBuilder().createModel(sourceContext, contracts, true, new String[0]);
        this.getModelBuilder().addAfterOperation(this.model, (TopiaEntityEnum)TopiaTestEntityEnum.Pet, UnregistredOperation.class, new Object[0]);
    }

    @Test
    public void testCreateSupportedBeforeOperation_Duplicate() throws Exception {
        this.createSupportedBeforeOperation((TopiaEntityEnum)TopiaTestEntityEnum.Person, (TopiaEntity)person, Duplicate.class, new Object[0]);
    }

    @Test
    public void testCreateSupportedBeforeOperation_DetachAssociation() throws Exception {
        this.createSupportedBeforeOperation((TopiaEntityEnum)TopiaTestEntityEnum.Person, (TopiaEntity)person, DettachAssociation.class, new Object[0]);
    }

    @Test
    public void testCreateSupportedAfterOperation_Duplicate() throws Exception {
        this.createSupportedAfterOperation((TopiaEntityEnum)TopiaTestEntityEnum.Person, (TopiaEntity)person, Duplicate.class, new Object[0]);
    }

    @Test
    public void testCreateSupportedAfterOperation_DetachAssociation() throws Exception {
        this.createSupportedAfterOperation((TopiaEntityEnum)TopiaTestEntityEnum.Person, (TopiaEntity)person, DettachAssociation.class, new Object[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateOperation_wrongParameterNumber() throws Exception {
        this.model = this.getModelBuilder().createModel(sourceContext, contracts, true, new String[]{pet.getTopiaId()});
        this.getModelBuilder().addBeforeOperation(this.model, (TopiaEntityEnum)TopiaTestEntityEnum.Pet, FakeOperation.class, new Object[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateOperation_wrongParameterNumber2() throws Exception {
        this.model = this.getModelBuilder().createModel(sourceContext, contracts, true, new String[]{pet.getTopiaId()});
        this.getModelBuilder().addBeforeOperation(this.model, (TopiaEntityEnum)TopiaTestEntityEnum.Pet, FakeOperation.class, new Object[]{String.class, String.class});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateOperation_wrongParameterType() throws Exception {
        this.model = this.getModelBuilder().createModel(sourceContext, contracts, true, new String[]{pet.getTopiaId()});
        this.getModelBuilder().addBeforeOperation(this.model, (TopiaEntityEnum)TopiaTestEntityEnum.Pet, FakeOperation.class, new Object[]{Integer.class});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateOperation_nullParameter() throws Exception {
        this.model = this.getModelBuilder().createModel(sourceContext, contracts, true, new String[]{pet.getTopiaId()});
        this.getModelBuilder().addBeforeOperation(this.model, (TopiaEntityEnum)TopiaTestEntityEnum.Pet, FakeOperation.class, new Object[]{null});
    }

    @Test
    public void testCreateOperation() throws Exception {
        this.model = this.getModelBuilder().createModel(sourceContext, contracts, true, new String[]{pet.getTopiaId()});
        this.getModelBuilder().addBeforeOperation(this.model, (TopiaEntityEnum)TopiaTestEntityEnum.Pet, FakeOperation.class, new Object[]{"before"});
        this.getModelBuilder().addAfterOperation(this.model, (TopiaEntityEnum)TopiaTestEntityEnum.Race, FakeOperation.class, new Object[]{"after"});
    }

    @Test(expected=NullPointerException.class)
    public void testDoReplicate_nullModel() throws Exception {
        this.service.doReplicate(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testDoReplicate_nullDstCtxt() throws Exception {
        this.model = this.getModelBuilder().createModel(sourceContext, contracts, true, new String[0]);
        this.service.doReplicate(this.model, null);
    }

    @Override
    protected TopiaApplicationContext createDb(String name) throws Exception {
        Properties config = this.getH2Properties(name);
        sourceContext = TopiaApplicationContextCache.getContext((Properties)config, (Function)CREATE_TOPIA_TEST_APPLICATION_CONTEXT);
        TopiaPersistenceContext tx = sourceContext.newPersistenceContext();
        person = (Person)tx.getDao(Person.class).create("name", (Object)"pudding master", new Object[0]);
        race = (Race)tx.getDao(Race.class).create("name", (Object)"race I", new Object[0]);
        pet = (Pet)tx.getDao(Pet.class).create("name", (Object)"pudding", new Object[]{"person", person, "race", race});
        person2 = (Person)tx.getDao(Person.class).create("name", (Object)"pudding II master", new Object[0]);
        pet2 = (Pet)tx.getDao(Pet.class).create("name", (Object)"pudding II", new Object[0]);
        race2 = (Race)tx.getDao(Race.class).create("name", (Object)"race II", new Object[0]);
        tx.commit();
        tx.closeContext();
        return sourceContext;
    }

    @Override
    protected TopiaEntityEnum[] getContracts() {
        return contracts;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    protected Properties getH2Properties(String dbName) throws IOException {
        Properties config = TopiaConfigurationHelper.initTopiaContextConfiguration((File)tesDir, (String)dbName);
        config.setProperty("topia.persistence.classes", entitiesList);
        config.setProperty("topia.service.replication", TopiaReplicationServiceImpl.class.getName());
        return config;
    }

    @Override
    protected TopiaApplicationContext createDb2(String name) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectTypes() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectAssociations() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectDirectDependencies() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectShell() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectDependencies() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectObjectsToDettach() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectOperations() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDoReplicate() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

