/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication;

import java.io.File;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.replication.AbstractTopiaReplicationServiceTest;
import org.nuiton.topia.replication.TopiaReplicationModelBuilder;
import org.nuiton.topia.replication.TopiaReplicationServiceImpl;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;
import org.nuiton.topia.replication.operation.AttachAssociation;
import org.nuiton.topia.replication.operation.DettachAssociation;
import org.nuiton.topia.replication.operation.Duplicate;
import org.nuiton.topia.replication.operation.FakeOperation;
import org.nuiton.topia.replication.operation.UncreatableOperation;
import org.nuiton.topia.replication.operation.UnregistredOperation;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonImpl;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.PetImpl;
import org.nuiton.topia.test.entities.Race;
import org.nuiton.topia.test.entities.RaceImpl;

public class TopiaReplicationOperationTest
extends AbstractTopiaReplicationServiceTest {
    private static final Log log = LogFactory.getLog(TopiaReplicationOperationTest.class);
    protected static final TopiaEntityEnum[] contracts = new TopiaEntityEnum[]{TopiaTestDAOHelper.TopiaTestEntityEnum.Person, TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, TopiaTestDAOHelper.TopiaTestEntityEnum.Race};
    protected static final String entitiesList = PersonImpl.class.getName() + "," + PetImpl.class.getName() + "," + RaceImpl.class.getName();
    protected static Person person;
    protected static Person person2;
    protected static Pet pet;
    protected static Pet pet2;
    protected static Race race;
    protected static Race race2;

    @AfterClass
    public static void after() throws Exception {
        AbstractTopiaReplicationServiceTest.after();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        person = this.update(person);
        person2 = this.update(person2);
        pet = this.update(pet);
        pet2 = this.update(pet2);
        race = this.update(race);
        race2 = this.update(race2);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.dstCtxt != null && !this.dstCtxt.isClosed()) {
            this.dstCtxt.closeContext();
        }
    }

    @Test(expected=NullPointerException.class)
    public void testGetOperation_nullOperationClass() throws Exception {
        this.getModelBuilder().getOperationProvider().getOperation((Class)null);
    }

    @Override
    protected TopiaReplicationModelBuilder getModelBuilder() {
        return this.service.getModelBuilder();
    }

    @Override
    @Test
    public void testGetOperation() throws Exception {
        this.getOperation(UnregistredOperation.class, false);
        this.getOperation(UncreatableOperation.class, true);
        this.getOperation(FakeOperation.class, true);
        this.getOperation(Duplicate.class, true);
        this.getOperation(AttachAssociation.class, true);
        this.getOperation(DettachAssociation.class, true);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateOperation_nullModel() throws Exception {
        this.getModelBuilder().createOperation(null, null, null, null, new Object[0]);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateOperation_nullType() throws Exception {
        this.model = this.getModelBuilder().createModel(context, contracts, true, new String[0]);
        this.getModelBuilder().createOperation(this.model, null, null, null, new Object[0]);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateOperation_nullPhase() throws Exception {
        this.model = this.getModelBuilder().createModel(context, contracts, true, new String[0]);
        this.getModelBuilder().createOperation(this.model, (TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, null, null, new Object[0]);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateOperation_nullOperationClass() throws Exception {
        this.model = this.getModelBuilder().createModel(context, contracts, true, new String[0]);
        this.getModelBuilder().createOperation(this.model, (TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, ReplicationOperationPhase.before, null, new Object[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateOperation_noNode() throws Exception {
        this.model = this.getModelBuilder().createModel(context, contracts, true, new String[0]);
        this.getModelBuilder().addAfterOperation(this.model, (TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, Duplicate.class, new Object[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateOperation_noOperation() throws Exception {
        this.model = this.getModelBuilder().createModel(context, contracts, true, new String[0]);
        this.getModelBuilder().addAfterOperation(this.model, (TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, UnregistredOperation.class, new Object[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCreateUnsupportedBeforeOperation_Duplicate() throws Exception {
        this.createUnsupportedBeforeOperation((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Person, (TopiaEntity)person, Duplicate.class, new Object[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCreateUnsupportedBeforeOperation_AttachAssociation() throws Exception {
        this.createUnsupportedBeforeOperation((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Person, (TopiaEntity)person, AttachAssociation.class, new Object[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCreateUnsupportedBeforeOperation_DetachAssociation() throws Exception {
        this.createUnsupportedBeforeOperation((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Person, (TopiaEntity)person, DettachAssociation.class, new Object[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCreateUnsupportedAfterOperation_Duplicate() throws Exception {
        this.createUnsupportedAfterOperation((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Person, (TopiaEntity)person, Duplicate.class, new Object[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCreateUnsupportedAfterOperation_AttachAssociation() throws Exception {
        this.createUnsupportedAfterOperation((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Person, (TopiaEntity)person, AttachAssociation.class, new Object[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCreateUnsupportedAfterOperation_DetachAssociation() throws Exception {
        this.createUnsupportedAfterOperation((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Person, (TopiaEntity)person, DettachAssociation.class, new Object[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCreateUnsupportedBeforeOperation_UncreatableOperation() throws Exception {
        this.createUnsupportedBeforeOperation((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Person, (TopiaEntity)person, UncreatableOperation.class, new Object[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCreateUnsupportedAfterOperation_UncreatableOperation() throws Exception {
        this.createUnsupportedAfterOperation((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Person, (TopiaEntity)person, UncreatableOperation.class, new Object[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateOperation_wrongParameterNumber() throws Exception {
        this.model = this.getModelBuilder().createModel(context, contracts, true, new String[]{pet.getTopiaId()});
        this.getModelBuilder().addBeforeOperation(this.model, (TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, FakeOperation.class, new Object[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateOperation_wrongParameterNumber2() throws Exception {
        this.model = this.getModelBuilder().createModel(context, contracts, true, new String[]{pet.getTopiaId()});
        this.getModelBuilder().addBeforeOperation(this.model, (TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, FakeOperation.class, new Object[]{String.class, String.class});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateOperation_wrongParameterType() throws Exception {
        this.model = this.getModelBuilder().createModel(context, contracts, true, new String[]{pet.getTopiaId()});
        this.getModelBuilder().addBeforeOperation(this.model, (TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, FakeOperation.class, new Object[]{Integer.class});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateOperation_nullParameter() throws Exception {
        this.model = this.getModelBuilder().createModel(context, contracts, true, new String[]{pet.getTopiaId()});
        this.getModelBuilder().addBeforeOperation(this.model, (TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, FakeOperation.class, new Object[]{null});
    }

    @Test
    public void testCreateOperation() throws Exception {
        this.model = this.getModelBuilder().createModel(context, contracts, true, new String[]{pet.getTopiaId()});
        this.getModelBuilder().addBeforeOperation(this.model, (TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, FakeOperation.class, new Object[]{"before"});
        this.getModelBuilder().addAfterOperation(this.model, (TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Race, FakeOperation.class, new Object[]{"after"});
    }

    @Test(expected=NullPointerException.class)
    public void testDoReplicate_nullModel() throws Exception {
        this.service.doReplicate(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testDoReplicate_nullDstCtxt() throws Exception {
        this.model = this.getModelBuilder().createModel(context, contracts, true, new String[0]);
        this.service.doReplicate(this.model, null);
    }

    @Override
    protected TopiaContext createDb(String name) throws Exception {
        File localDB = new File(this.getTestDir(((Object)((Object)this)).getClass()), "db_" + name);
        Properties config = this.getH2Properties(localDB);
        context = TopiaContextFactory.getContext((Properties)config);
        TopiaContextImplementor tx = (TopiaContextImplementor)context.beginTransaction();
        person = (Person)tx.getDAO(Person.class).create(new Object[]{"name", "pudding master"});
        race = (Race)tx.getDAO(Race.class).create(new Object[]{"name", "race I"});
        pet = (Pet)tx.getDAO(Pet.class).create(new Object[]{"name", "pudding", "person", person, "race", race});
        person2 = (Person)tx.getDAO(Person.class).create(new Object[]{"name", "pudding II master"});
        pet2 = (Pet)tx.getDAO(Pet.class).create(new Object[]{"name", "pudding II"});
        race2 = (Race)tx.getDAO(Race.class).create(new Object[]{"name", "race II"});
        tx.commitTransaction();
        tx.closeContext();
        return context;
    }

    @Override
    protected TopiaEntityEnum[] getContracts() {
        return contracts;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    protected Properties getH2Properties(File f) {
        Properties config = new Properties();
        config.setProperty("hibernate.show_sql", "false");
        config.setProperty("hibernate.hbm2ddl.auto", "create");
        config.setProperty("topia.persistence.classes", entitiesList);
        config.setProperty("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        config.setProperty("hibernate.connection.driver_class", "org.h2.Driver");
        config.setProperty("hibernate.connection.url", "jdbc:h2:file:" + f.getAbsolutePath() + ";create=true");
        config.setProperty("hibernate.connection.username", "sa");
        config.setProperty("hibernate.connection.password", "");
        config.setProperty("topia.service.replication", TopiaReplicationServiceImpl.class.getName());
        return config;
    }

    @Override
    protected TopiaContext createDb2(String name) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectTypes() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectAssociations() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectDirectDependencies() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectShell() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectDependencies() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectObjectsToDettach() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDetectOperations() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void testDoReplicate() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

