/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: TopiaDAO.java 2851 2013-10-30 11:16:15Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-5/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaDAO.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/* *
 * TopiaDAO.java
 *
 * Created: 30 déc. 2005 03:00:57
 *
 * @author poussin <poussin@codelutin.com>
 * @version $Revision: 2851 $
 *
 * Last update: $Date: 2013-10-30 12:16:15 +0100 (Wed, 30 Oct 2013) $
 * by : $Author: athimel $
 */
package org.nuiton.topia.persistence;

import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;

import java.security.Permission;
import java.util.List;
import java.util.Map;

/**
 * TopiaDAO is used to manipulate entities corresponding to {@code E} type :
 * create, delete, update or find entities.
 * <p/>
 * This interface is implemented by {@link TopiaDAOImpl} overridden by generation
 * from {@link org.nuiton.topia.generator.EntityDaoTransformer}.
 * <p/>
 *
 * @param <E> the entity type managed by the dao
 * @author bpoussin <poussin@codelutin.com>
 * @author fdesbois <fdesbois@codelutin.com>
 * @author tchemit <chemit@codelutin.com>
 * @version $Id: TopiaDAO.java 2851 2013-10-30 11:16:15Z athimel $
 * @deprecated prefer {@link TopiaDao}
 */
@Deprecated
public interface TopiaDAO<E extends TopiaEntity> extends TopiaDao<E> {

    //------------------------------------------------------------------------//
    //-- Create - update - delete methods ------------------------------------//
    //------------------------------------------------------------------------//

    /**
     * Creates a new instance of the entity managed by the DAO
     *
     * @param propertyNamesAndValues the list of properties that the created entity will have. Arguments are key-value
     *                               paired : [propertyName;value;propertyName;value;...]
     * @return the newly created entity
     * @throws TopiaException           if any problem during instantiation
     * @throws IllegalArgumentException if the arguments count is not correct or
     *                                  if some property type is not the
     *                                  expected one
     * @see #create(Map)
     * @deprecated use {@link TopiaDao#create(String, Object, Object...)}
     */
    E create(Object... propertyNamesAndValues) throws TopiaException;

    //------------------------------------------------------------------------//
    //-- findByXXX methods ---------------------------------------------------//
    //------------------------------------------------------------------------//

    /**
     * Find an entity corresponding to the {@code id}. If the {@code id} is
     * null, nothing will be searched.
     *
     * @param id topiaId of the entity to found
     * @return the entity found or null if not
     * @throws TopiaException for Topia errors on query
     * @deprecated ambiguous signature use new API and inline {@link TopiaDao#forTopiaIdEquals(String)}
     */
    E findByTopiaId(String id) throws TopiaException;

    /**
     * Find an entity matching {@code value} for the given {@code propertyName}.
     *
     * @param propertyName property name to filter
     * @param value        value of the property to match
     * @return the first entity matching the request
     * @throws TopiaException if any pb while getting datas
     * @deprecated @deprecated use new API and inline {@link LegacyTopiaDao#findByProperties(String, Object, Object...)}
     */
    E findByProperty(String propertyName,
                     Object value) throws TopiaException;

    /**
     * Find an entity matching a succession of propertyName + value arguments.
     *
     * @param propertyName           the first property name to filter
     * @param value                  the first value of the property to match
     * @param propertyNamesAndValues other property names and values. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return the first entity matching the request
     * @throws TopiaException if any pb while getting datas
     * @deprecated @deprecated use new API and inline {@link LegacyTopiaDao#findByProperties(String, Object, Object...)}
     */
    E findByProperties(String propertyName,
                       Object value,
                       Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Find an entity matching {@code properties}.
     *
     * @param properties the properties key + value to match
     * @return the first entity matching the request
     * @throws TopiaException if any pb while getting datas
     * @deprecated @deprecated use new API and inline {@link LegacyTopiaDao#findByProperties(java.util.Map)}
     */
    E findByProperties(Map<String, Object> properties) throws TopiaException;

    /**
     * Executes and returns the result (entity E) of the given HQL query string.
     *
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return the entity E found or null
     * @throws TopiaException if any pb while getting datas
     * @since 2.6.12
     * @deprecated move your code inside the DAO and use a suitable protected method
     */
    E findByQuery(String hql,
                  Object... propertyNamesAndValues) throws TopiaException;

    // TODO AThimel 20/07/13 Add this method : E findByQuery(String hql, Map<String, Object> propertyNamesAndValues) throws TopiaException;

    /**
     * Executes and returns the result (entity R) of the given HQL query string.
     *
     * @param type                   the expected result type
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return the entity R found or null
     * @throws TopiaException if any pb while getting datas
     * @throws ClassCastException if the found type is not the expected one
     * @since 2.6.12
     * @deprecated move your code inside the DAO and use a suitable protected method
     */
    <R> R findByQuery(Class<R> type,
                      String hql,
                      Object... propertyNamesAndValues) throws TopiaException;

    // TODO AThimel 20/07/13 Add this method : <R> R findByQuery(Class<R> type, String hql, Map<String, Object> propertyNamesAndValues) throws TopiaException;

    /**
     * Find an entity using the natural ids. Each field of the natural id has to be present in the given Map.
     *
     * @param keys Map with the natural id property name as Map.key, and value as Map.value
     * @return the entity E found or null
     * @throws TopiaException if any pb while getting datas
     * @deprecated use new API and inline {@link LegacyTopiaDao#findByPrimaryKey(java.util.Map)}
     */
    E findByPrimaryKey(Map<String, Object> keys) throws TopiaException;

    /**
     * Find an entity using the natural ids. Each field of the natural id has to
     * be present in the given Map.
     *
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return the entity E found or null
     * @throws TopiaException if any pb while getting datas
     * @deprecated use new API and inline {@link LegacyTopiaDao#findByPrimaryKey(Object...)}
     */
    E findByPrimaryKey(Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Find the first entity which given collection (propertyName) contains the
     * given value
     *
     * @param propertyName the name of the property (must be a collection)
     * @param value        the value to use for find
     * @return the entity E found or null
     * @throws TopiaException if any pb while getting datas
     * @since 2.5.4
     * @deprecated use new API and inline {@link LegacyTopiaDao#findContains(String, Object)}
     */
    E findContains(String propertyName,
                   Object value) throws TopiaException;

    //------------------------------------------------------------------------//
    //-- findAllXXX methods --------------------------------------------------//
    //------------------------------------------------------------------------//

    /**
     * Finds all entites E managed by this DAO. The returned list will be ordered according to the given
     * {@code propertyNames}.
     * <p/>
     * You can add on each {@code property} {@code ASC} or {@code DESC} to force the result order
     * (by default is {@code ASC}).
     *
     * @param propertyNames property names of order to apply
     * @return all entities E of the dao entity type with given order
     * @throws TopiaException if any pb while getting datas
     * @deprecated use new API and inline {@link LegacyTopiaDao#findAllWithOrder(String...)}
     */
    List<E> findAllWithOrder(String... propertyNames) throws TopiaException;

    /**
     * Finds all entities E which value for the given {@code propertyName} is
     * {@code value}
     *
     * @param propertyName property name to use
     * @param value        value to expect
     * @return the list of entities E having the given value
     * @throws TopiaException if any pb while getting datas
     * @deprecated use new API and inline {@link LegacyTopiaDao#findAllByProperties(String, Object, Object...)}
     */
    List<E> findAllByProperty(String propertyName,
                              Object value) throws TopiaException;

    /**
     * Finds all entities E matching the given {@code propertyName}, {@code value}
     * AND all other properties
     *
     * @param propertyName           property name to use
     * @param value                  value to expect
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return the list of entities E having the given value
     * @throws TopiaException if any pb while getting datas
     * @deprecated use new API and inline {@link LegacyTopiaDao#findAllByProperties(String, Object, Object...)}
     */
    List<E> findAllByProperties(String propertyName,
                                Object value,
                                Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Finds all entities E matching all the {@code properties} values.
     *
     * @param properties properties to match
     * @return the list of entities E having the given values
     * @throws TopiaException if any pb while getting datas
     * @deprecated use new API and inline {@link LegacyTopiaDao#findAllByProperties(java.util.Map)}
     */
    List<E> findAllByProperties(Map<String, Object> properties) throws TopiaException;

    /**
     * Finds all entities E when executing the given HQL query.
     *
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return the list of entities E found by the query and parameters
     * @throws TopiaException if any pb while getting datas
     * @since 2.6.12
     * @deprecated move your code inside the DAO and use  {@link AbstractTopiaDao#findAll(String, java.util.Map)}
     */
    List<E> findAllByQuery(String hql,
                           Object... propertyNamesAndValues) throws TopiaException;

    // TODO AThimel 20/07/13 Add this method : List<E> findAllByQuery(String hql, Map<String, Object> propertyNamesAndValues) throws TopiaException;

    /**
     * Gets all entities when executing the given select query for the given
     * {@code type} which may not be a entity type (int, long, map,...).
     *
     * @param type                   the expected result type
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return entites of the query result
     * @throws TopiaException if any pb while getting datas
     * @since 2.6.12
     * @deprecated move your code inside the DAO and use  {@link AbstractTopiaDao#findAll(String, java.util.Map, Class)}
     */
    <R> List<R> findAllByQuery(Class<R> type,
                               String hql,
                               Object... propertyNamesAndValues) throws TopiaException;

    // TODO AThimel 20/07/13 Add this method : <R> List<R> findAllByQuery(Class<R> type, String hql, Map<String, Object> propertyNamesAndValues) throws TopiaException;

    /**
     * Finds all entities E in lazy mode when executing the given select query
     * for the dao entity type.
     * <p/>
     * <strong>Important note:</strong> // TODO AThimel 20/07/13 Write the important note...
     *
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return entites E of the query result
     * @throws TopiaException if any pb while getting datas
     * @since 2.6.14
     * @deprecated move your code inside the DAO and use  {@link AbstractTopiaDao#findAllLazy(String, java.util.Map, Class)}
     */
    Iterable<E> findAllLazyByQuery(String hql,
                                   Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Finds all entities R in lazy mode when executing the given select query
     * for the given {@code type} which may not be a entity type (int, long, map,...).
     * <p/>
     * <strong>Important note:</strong> // TODO AThimel 20/07/13 Write the important note...
     *
     * @param type                   the expected result type
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return entites R of the query result
     * @throws TopiaException if any pb while getting datas
     * @since 2.6.14
     * @deprecated move your code inside the DAO and use  {@link AbstractTopiaDao#findAllLazy(String, java.util.Map, Class)}
     */
    <R> Iterable<R> findAllLazyByQuery(Class<R> type,
                                       String hql,
                                       Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Finds all entities E in lazy mode when executing the given select query
     * for the dao entity type.
     * <p/>
     * <strong>Important note:</strong> // TODO AThimel 20/07/13 Write the important note...
     *
     * @param batchSize              batch size
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return entites E of the query result
     * @throws TopiaException if any pb while getting datas
     * @since 2.6.14
     * @deprecated move your code inside the DAO and use  {@link AbstractTopiaDao#findAllLazy(String, java.util.Map)}
     */
    Iterable<E> findAllLazyByQuery(int batchSize,
                                   String hql,
                                   Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Finds all entities R in lazy mode when executing the given select query
     * for the given {@code type} which may not be a entity type (int, long, map,...).
     * <p/>
     * <strong>Important note:</strong> // TODO AThimel 20/07/13 Write the important note...
     *
     * @param type                   the expected result type
     * @param batchSize              batch size
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return entites R of the query result
     * @throws TopiaException if any pb while getting datas
     * @since 2.6.14
     * @deprecated move your code inside the DAO and use  {@link AbstractTopiaDao#findAllLazy(String, java.util.Map, Class)}
     */
    <R> Iterable<R> findAllLazyByQuery(Class<R> type,
                                       int batchSize,
                                       String hql,
                                       Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Finds a page of entities E when executing the given select query for the dao
     * entity type (will only return the window of {@code startIndex -
     * endIndex} entities).
     * // TODO AThimel 20/07/13 Reformulate(?) the "window thing"
     *
     * @param hql                    the HQL query
     * @param startIndex             first index of entity to return
     * @param endIndex               last index of entity to return
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return entites E of the paginated query result
     * @throws TopiaException if any pb while getting datas
     * @since 2.6.12
     * @deprecated move your code inside the DAO and use  {@link AbstractTopiaDao#findAll(String, java.util.Map, int, int)}
     */
    List<E> findAllByQueryWithBound(String hql,
                                    int startIndex,
                                    int endIndex,
                                    Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Finds a page of entities R when executing the given select query for the dao
     * entity type (will only return the window of {@code startIndex -
     * endIndex} entities).
     * // TODO AThimel 20/07/13 Reformulate(?) the "window thing"
     *
     * @param type                   the expected result type
     * @param hql                    the HQL query
     * @param startIndex             first index of entity to return
     * @param endIndex               last index of entity to return
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return entites R of the paginated query result
     * @throws TopiaException if any pb while getting datas
     * @since 2.6.12
     * @deprecated move your code inside the DAO and use  {@link AbstractTopiaDao#findAll(String, java.util.Map, Class, int, int)}
     */
    <R> List<R> findAllByQueryWithBound(Class<R> type,
                                        String hql,
                                        int startIndex,
                                        int endIndex,
                                        Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Gets a page of entities E of the given select {@code hql} query using the
     * {@code pager} to obtain the window of entities to return.
     *
     * @param hql                    the HQL query
     * @param pager                  pager to obtain the correct window of data
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return entities E of the paginated query result
     * @throws TopiaException if any pb while getting datas
     * @see TopiaPagerBean
     * @since 2.6.12
     * @deprecated move your code inside the DAO and use  {@link AbstractTopiaDao#findAll(String, java.util.Map, org.nuiton.topia.persistence.pager.TopiaPagerBean)}
     */
    List<E> findAllByQueryAndPager(String hql,
                                   TopiaPagerBean pager,
                                   Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Finds a page of entities R of the given select {@code hql} query using the
     * {@code pager} to obtain the window of entities to return.
     *
     * @param type                   the expected result type
     * @param hql                    the HQL query
     * @param pager                  pager to obtain the correct window of data
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return entities R of the paginated query result
     * @throws TopiaException if any pb while getting datas
     * @see TopiaPagerBean
     * @since 2.6.12
     * @deprecated move your code inside the DAO and use  {@link AbstractTopiaDao#findAll(String, java.util.Map, Class, org.nuiton.topia.persistence.pager.TopiaPagerBean)}
     */
    <R> List<R> findAllByQueryAndPager(Class<R> type,
                                       String hql,
                                       TopiaPagerBean pager,
                                       Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Find all the entities E which given collection (propertyName) contains the
     * given value
     *
     * @param propertyName the name of the property (must be a collection)
     * @param value        the value to use for find
     * @return all the entities E found
     * @throws TopiaException if any pb while getting datas
     * @since 2.5.4
     * @deprecated use new API and inline {@link LegacyTopiaDao#findAllContains(String, Object)}
     */
    List<E> findAllContains(String propertyName,
                            Object value) throws TopiaException;

    //------------------------------------------------------------------------//
    //-- existsByXXX methods -------------------------------------------------//
    //------------------------------------------------------------------------//

    /**
     * Check the existence of an entity with technical {@code id}.
     *
     * @param id unique id of the entity to test existence.
     * @return true if entity exists, false otherwise
     * @throws TopiaException for any error
     * @since 2.3.4
     * @deprecated use new API and inline {@link LegacyTopiaDao#existByTopiaId(String)}
     */
    boolean existByTopiaId(String id) throws TopiaException;

    /**
     * Check the existence of an entity with {@code propertyName} with {@code
     * propertyValue}. {@code others} properties can be added to test
     * existence.
     *
     * @param propertyName           the first property name to test existence
     * @param propertyValue          the first property value to test existence
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return true if entity exists, false otherwise
     * @throws TopiaException for Topia errors
     * @since 2.3.4
     * @deprecated move your code inside the DAO and use  {@link AbstractTopiaDao#exists(String, java.util.Map)}
     */
    boolean existByProperties(String propertyName,
                              Object propertyValue,
                              Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Check the existence of an entity using the given HQL query.
     *
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return true if entity exists, false otherwise
     * @throws TopiaException
     * @since 2.6.12
     * @deprecated move your code inside the DAO and use  {@link AbstractTopiaDao#exists(String, java.util.Map)}
     */
    boolean existsByQuery(String hql,
                          Object... propertyNamesAndValues) throws TopiaException;

    //------------------------------------------------------------------------//
    //-- countXXX methods ----------------------------------------------------//
    //------------------------------------------------------------------------//

    /**
     * Count the number of entities based on a the given HQL query.
     *
     * @param hql                    the HQL query to use
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return number of entities filtered by the query
     * @throws TopiaException if any pb while getting datas
     * @since 2.6.12
     * @deprecated move your call to inside the DAO and use {@link AbstractTopiaDao#count(String, java.util.Map)}
     */
    long countByQuery(String hql,
                      Object... propertyNamesAndValues) throws TopiaException;

    //------------------------------------------------------------------------//
    //-- other request methods -----------------------------------------------//
    //------------------------------------------------------------------------//

    /**
     * Execute the count {@code hql} query and then synch the pager to this
     * result (says fill the
     * {@link TopiaPagerBean#records} field and then adapt
     * the number of pages available and the current number page).
     *
     * @param hql                    the HQL query to use
     * @param pager                  pager to obtain the correct window of data
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @throws TopiaException if any pb while getting datas
     * @see TopiaPagerBean
     * @since 2.6.12
     * // TODO brendan 17/10/13 really ??
     * @deprecated
     */
    void computeAndAddRecordsToPager(String hql,
                                     TopiaPagerBean pager,
                                     Object... propertyNamesAndValues) throws TopiaException;

    //------------------------------------------------------------------------//
    //-- Misc methods --------------------------------------------------------//
    //------------------------------------------------------------------------//

    /**
     * Returns the context used by this DAO.
     *
     * @return Returns the context.
     * @deprecated use {@link #getTopiaContext()}
     */
    @Deprecated
    TopiaContextImplementor getContext();

    /**
     * Returns the context used by this DAO.
     *
     * @return Returns the context.
     */
    // TODO AThimel 02/08/13 Use only TopiaPersistenceContext and TopiaHibernateSupport
    TopiaContext getTopiaContext();

    /**
     * Get the entityEnum of the type of entity managed by this DAO.
     *
     * @return entity type enum managed by this DAO
     * @deprecated you should get it from persistence context or application context
     */
    @Deprecated
    TopiaEntityEnum getTopiaEntityEnum();

    /**
     * Create the simple HQL query for the entity managed by the dao.
     * <p/>
     * A optional alias can be passed:
     * <p/>
     * <pre>FROM MyEntityImpl myAlias</pre>
     *
     * @param alias optional alias to use in query
     * @return the hql query
     * @since 2.6.14
     * @deprecated no longer accessible from outside DAO
     */
    @Deprecated
    String createSimpleQuery(String alias);

    /**
     * Retourne les permissions a verifier pour l'acces a l'entite pour le
     * service Taas.
     *
     * @param topiaId topiaId d'une entite
     * @param actions encoded actions
     * @return la liste des permissions
     * @throws TopiaException if any pb while getting datas
     * @since 2.6.14
     * @deprecated topia-service-security will be removed in 3.0
     */
    @Deprecated
    List<Permission> getRequestPermission(String topiaId,
                                          int actions) throws TopiaException;

    // The next 3 methods are copied from TopiaContext in order to facilitate migration

    /**
     * Allow to do some HQL query
     * <p/>
     * WARNING : Depending on the registered service, this method may not
     * support something else than queries on TopiaEntity
     *
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return The result list
     * @throws TopiaException for any error during querying
     * @deprecated use method from {@link org.nuiton.topia.TopiaJpaSupport}
     */
    @Deprecated
    <E> List<E> findAll(String hql,
                        Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Allow to do some JPA-QL query using the given bounds.
     * <p/>
     * No lower bound : <code>startIndex</code> = 0.<br/>
     * No upper bound : <code>endIndex</code> = -1.
     * <p/>
     * WARNING : Depending on the registered service, this method may not
     * support something else than queries on TopiaEntity
     *
     * @param hql                    the HQL query
     * @param startIndex             first index of entity to return
     * @param endIndex               last index of entity to return
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return The result list
     * @throws TopiaException for any error during querying
     * @deprecated use method from {@link org.nuiton.topia.TopiaJpaSupport}
     */
    @Deprecated
    <E> List<E> find(String hql,
                     int startIndex,
                     int endIndex,
                     Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Allow to do some HQL query and return an unique result. If nothing if
     * found by the query, will return null. If more than one result is found,
     * will throw an exception.
     * <p/>
     * WARNING : Depending on the registered service, this method may not
     * support something else than queries on TopiaEntity
     *
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return The result instance or null
     * @throws TopiaException for any error during querying or if the the query
     *                        returns more than one result.
     * @deprecated use method from {@link org.nuiton.topia.TopiaJpaSupport}
     */
    @Deprecated
    <E> E findUnique(String hql,
                     Object... propertyNamesAndValues) throws TopiaException;


} //TopiaDAO

