/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.PropertyValueException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.TopiaTestTopiaPersistenceContext;
import org.nuiton.topiatest.NaturalizedEntityTopiaDao;

public class NaturalIdTest {
    private static final Log log = LogFactory.getLog(NaturalIdTest.class);
    @Rule
    public final TopiaDatabase db = new TopiaDatabase();

    @Test
    public void testCreateSucessfull() throws Exception {
        log.debug((Object)"Test naturalId : create succesfull");
        TopiaTestTopiaPersistenceContext persistenceContext = this.db.beginTransaction();
        NaturalizedEntityTopiaDao dao = persistenceContext.getNaturalizedEntityDao();
        dao.createByNaturalId(5, "str");
        persistenceContext.commitTransaction();
        dao.createByNotNull(3);
        persistenceContext.commitTransaction();
        dao.create("naturalIdNotNull", 3, new Object[0]);
        persistenceContext.commitTransaction();
    }

    @Test
    public void testCreateFailed() throws Exception {
        log.debug((Object)"Test naturalId : create failed");
        TopiaTestTopiaPersistenceContext persistenceContext = this.db.beginTransaction();
        NaturalizedEntityTopiaDao dao = persistenceContext.getNaturalizedEntityDao();
        try {
            dao.create();
            persistenceContext.commitTransaction();
        }
        catch (TopiaException eee) {
            Assert.assertNotNull((Object)eee.getCause());
            Assert.assertTrue((boolean)(eee.getCause() instanceof PropertyValueException));
            Assert.assertEquals((Object)"naturalIdNotNull", (Object)((PropertyValueException)eee.getCause()).getPropertyName());
        }
    }

    @Test
    public void testUpdateFailed() throws Exception {
        log.debug((Object)"Test naturalId : update failed");
        TopiaTestTopiaPersistenceContext persistenceContext = this.db.beginTransaction();
        NaturalizedEntityTopiaDao dao = persistenceContext.getNaturalizedEntityDao();
        Object entity = dao.createByNaturalId(5, "str");
        persistenceContext.commitTransaction();
        try {
            entity.setNaturalIdNotNull(8);
            persistenceContext.commitTransaction();
        }
        catch (TopiaException eee) {
            Assert.assertEquals((Object)"org.hibernate.HibernateException", (Object)eee.getCause().getClass().getName());
        }
    }

    @Test
    public void testFindByNaturalId() throws Exception {
        log.debug((Object)"Test naturalId : findByNaturalId");
        TopiaTestTopiaPersistenceContext persistenceContext = this.db.beginTransaction();
        NaturalizedEntityTopiaDao dao = persistenceContext.getNaturalizedEntityDao();
        Object entity = dao.createByNaturalId(5, "str");
        persistenceContext.commitTransaction();
        Object result = dao.findByNaturalId(5, "str");
        Assert.assertEquals(entity, result);
    }

    @Test
    public void testExistNaturalId() throws Exception {
        log.debug((Object)"Test naturalId : existNaturalId");
        TopiaTestTopiaPersistenceContext persistenceContext = this.db.beginTransaction();
        NaturalizedEntityTopiaDao dao = persistenceContext.getNaturalizedEntityDao();
        dao.createByNaturalId(5, "str");
        persistenceContext.commitTransaction();
        boolean result = dao.existByNaturalId(5, "str");
        Assert.assertTrue((boolean)result);
        result = dao.existByNaturalId(8, "str");
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testNaturalIdAreGeneralized() throws Exception {
        Object[] generalizedNaturalizedNaturalIds = TopiaTestDAOHelper.TopiaTestEntityEnum.GeneralizedNaturalizedEntity.getNaturalIds();
        Object[] naturalizedNaturalIds = TopiaTestDAOHelper.TopiaTestEntityEnum.NaturalizedEntity.getNaturalIds();
        Assert.assertArrayEquals((Object[])generalizedNaturalizedNaturalIds, (Object[])naturalizedNaturalIds);
    }

    @Test
    public void testNotNullsAreGeneralized() throws Exception {
        Object[] generalizedNaturalizedNotNulls = TopiaTestDAOHelper.TopiaTestEntityEnum.GeneralizedNaturalizedEntity.getNotNulls();
        Object[] naturalizedNotNulls = TopiaTestDAOHelper.TopiaTestEntityEnum.NaturalizedEntity.getNotNulls();
        Assert.assertArrayEquals((Object[])generalizedNaturalizedNotNulls, (Object[])naturalizedNotNulls);
    }
}

