/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.DepthEntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class Collector<R> {
    private static final Log log = LogFactory.getLog(Collector.class);
    protected CollectorVisitor visitor;
    protected TopiaEntityEnum[] contracts;

    public Collector(CollectorVisitor visitor, TopiaEntityEnum[] contracts) {
        this.visitor = visitor == null ? new CollectorVisitor() : visitor;
        this.visitor.setCollector(this);
        this.contracts = contracts;
    }

    public Collector(TopiaEntityEnum[] contracts) {
        this(null, contracts);
    }

    protected void clear() {
        this.visitor.clear();
    }

    protected boolean onStarting(TopiaEntity e) {
        return true;
    }

    protected void onStarted(TopiaEntity e, boolean enter) {
    }

    protected boolean onVisiting(TopiaEntity e, String name, Class<?> type, Object value) {
        return true;
    }

    protected void onVisited(TopiaEntity e, String name, Class<?> type, Object value, boolean enter) {
    }

    protected boolean onVisiting(TopiaEntity e, String name, Class<?> collectionType, Class<?> type, Object value) {
        return true;
    }

    protected void onVisited(TopiaEntity e, String name, Class<?> collectionType, Class<?> type, Object value, boolean enter) {
    }

    protected boolean onVisiting(TopiaEntity e, String name, Class<?> collectionType, Class<?> type, int index, Object value) {
        return true;
    }

    protected void onVisited(TopiaEntity e, String name, Class<?> collectionType, Class<?> type, int index, Object value, boolean enter) {
    }

    protected boolean onEnding(TopiaEntity e) {
        return true;
    }

    protected void onEnded(TopiaEntity e, boolean enter) {
    }

    protected void beforeAll(CollectorVisitor visitor, TopiaEntity ... entities) {
    }

    protected void before(CollectorVisitor visitor, TopiaEntity entity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will detect " + entity.getTopiaId()));
        }
    }

    protected void after(CollectorVisitor visitor, TopiaEntity entity) {
    }

    protected abstract R afterAll(CollectorVisitor var1, TopiaEntity ... var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R detect(TopiaEntity ... entities) throws TopiaException {
        try {
            R result;
            this.beforeAll(this.visitor, entities);
            for (TopiaEntity e : entities) {
                this.before(this.visitor, e);
                e.accept(this.visitor);
                this.after(this.visitor, e);
            }
            R r = result = this.afterAll(this.visitor, entities);
            return r;
        }
        finally {
            this.clear();
        }
    }

    protected int stackSize() {
        return this.visitor.getStack().size();
    }

    protected Deque<TopiaEntity> getStack() {
        return this.visitor.getStack();
    }

    protected Collection<TopiaEntity> getAlreadyExplored() {
        return this.visitor.getAlreadyExplored();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }

    protected Class<? extends TopiaEntity> getContractClass(TopiaEntity e) {
        if (this.contracts.length == 0) {
            return null;
        }
        Class<? extends TopiaEntity> contractClass = TopiaEntityHelper.getContractClass(this.contracts, e.getClass());
        if (contractClass != null) {
            return contractClass;
        }
        return null;
    }

    protected TopiaEntity getTopiaValue(Object value) {
        return (TopiaEntity)(value != null && value instanceof TopiaEntity ? value : null);
    }

    public static class CollectorVisitor
    extends DepthEntityVisitor {
        protected Deque<TopiaEntity> stack = new ArrayDeque<TopiaEntity>();
        Collector<?> collector;

        protected void setCollector(Collector<?> collector) {
            this.collector = collector;
        }

        protected Deque<TopiaEntity> getStack() {
            return this.stack;
        }

        protected Collection<TopiaEntity> getAlreadyExplored() {
            return this.alreadyExplored;
        }

        @Override
        public void start(TopiaEntity e) {
            this.stack.offerLast(e);
            boolean canContinue = this.collector.onStarting(e);
            if (canContinue) {
                super.start(e);
            }
            this.collector.onStarted(e, canContinue);
        }

        @Override
        public void end(TopiaEntity e) {
            boolean canContinue = this.collector.onEnding(e);
            if (canContinue) {
                super.end(e);
            }
            this.stack.removeLast();
            this.collector.onEnded(e, canContinue);
        }

        @Override
        public void visit(TopiaEntity e, String name, Class<?> type, Object value) {
            boolean canContinue = this.collector.onVisiting(e, name, type, value);
            if (canContinue) {
                super.visit(e, name, type, value);
            }
            this.collector.onVisited(e, name, type, value, canContinue);
        }

        @Override
        public void visit(TopiaEntity e, String name, Class<?> collectionType, Class<?> type, Object value) {
            boolean canContinue = this.collector.onVisiting(e, name, collectionType, type, value);
            if (canContinue) {
                super.visit(e, name, collectionType, type, value);
            }
            this.collector.onVisited(e, name, collectionType, type, value, canContinue);
        }

        @Override
        public void visit(TopiaEntity e, String name, Class<?> collectionType, Class<?> type, int index, Object value) {
            boolean canContinue = this.collector.onVisiting(e, name, collectionType, type, index, value);
            if (canContinue) {
                super.visit(e, name, collectionType, type, index, value);
            }
            this.collector.onVisited(e, name, collectionType, type, index, value, canContinue);
        }

        @Override
        public void clear() {
            super.clear();
            this.stack.clear();
        }
    }
}

