/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.StringUtil;

@Deprecated
public class DAOAbstractTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(DAOAbstractTransformer.class);
    protected Map<ObjectModelClass, Set<ObjectModelClass>> usages;
    Set<String> allEntitiesFqn;
    protected Class<?> daoImplementation;
    Map<String, Collection<ObjectModelOperation>> extraOperations = new HashMap<String, Collection<ObjectModelOperation>>();

    public void transformFromModel(ObjectModel model) {
        this.usages = TopiaGeneratorUtil.searchDirectUsages(model);
        boolean extendLegacyDAO = Boolean.valueOf(model.getTagValue("useLegacyDAO"));
        if (extendLegacyDAO) {
            log.warn((Object)"Using a deprecated tag value useLegacyDAO, prefer use the tag value daoImplementation");
            this.daoImplementation = TopiaDAOLegacy.class;
        } else {
            this.daoImplementation = TopiaGeneratorUtil.getDAOImplementation(model);
        }
        List<ObjectModelClass> allEntities = TopiaGeneratorUtil.getEntityClasses(model, true);
        this.allEntitiesFqn = new HashSet<String>(allEntities.size());
        for (ObjectModelClass entity : allEntities) {
            this.allEntitiesFqn.add(entity.getQualifiedName());
        }
    }

    public void transformFromInterface(ObjectModelInterface interfacez) {
        if (!TopiaGeneratorUtil.hasDaoStereotype((ObjectModelClassifier)interfacez)) {
            return;
        }
        this.collectExtraOperations(interfacez);
    }

    protected void collectExtraOperations(ObjectModelInterface interfacez) {
        ObjectModelDependency dependency = interfacez.getDependency("dao");
        if (dependency == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not find dependency dao but DAO stereotype was placed on the interface " + interfacez.getName()));
            }
            return;
        }
        ObjectModelClassifier classifier = dependency.getSupplier();
        if (TopiaGeneratorUtil.isEntity(classifier)) {
            Collection operations = interfacez.getOperations();
            if (log.isDebugEnabled()) {
                log.debug((Object)"add extra operations for DAO");
            }
            this.extraOperations.put(classifier.getQualifiedName(), operations);
        }
    }

    public void transformFromClass(ObjectModelClass clazz) {
        if (!TopiaGeneratorUtil.isEntity((ObjectModelClassifier)clazz)) {
            return;
        }
        String clazzName = clazz.getName();
        ObjectModelClass result = this.createAbstractClass(clazzName + "DAOAbstract<E extends " + clazzName + '>', clazz.getPackageName());
        String extendClass = "";
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            extendClass = parent.getQualifiedName();
            if (!TopiaGeneratorUtil.isEntity((ObjectModelClassifier)parent)) continue;
            extendClass = extendClass + "DAOImpl<E>";
            break;
        }
        if (extendClass.length() == 0) {
            extendClass = this.daoImplementation.getName() + "<E>";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("super class = " + extendClass));
        }
        this.setSuperClass(result, extendClass);
        this.addInterface((ObjectModelClassifier)result, TopiaDAO.class.getName() + "<E>");
        String prefix = this.getConstantPrefix((ObjectModelClassifier)clazz, "");
        this.setConstantPrefix(prefix);
        Collection<ObjectModelOperation> DAOoperations = this.getDAOOperations(clazz);
        if (this.isCollectionNeeded(DAOoperations)) {
            this.addImport((ObjectModelClassifier)result, Collection.class);
        }
        if (this.isSetNeeded(DAOoperations)) {
            this.addImport((ObjectModelClassifier)result, Set.class);
        }
        this.addImport((ObjectModelClassifier)result, List.class);
        this.addImport((ObjectModelClassifier)result, Arrays.class);
        this.addImport((ObjectModelClassifier)result, TopiaException.class);
        this.addImport((ObjectModelClassifier)result, TopiaContextImplementor.class);
        boolean enableSecurity = TopiaGeneratorUtil.isClassWithSecurity((ObjectModelClassifier)clazz);
        if (enableSecurity) {
            this.addImport((ObjectModelClassifier)result, ArrayList.class);
            this.addImport((ObjectModelClassifier)result, Permission.class);
            this.addImport((ObjectModelClassifier)result, "org.nuiton.topia.taas.entities.TaasAuthorizationImpl");
            this.addImport((ObjectModelClassifier)result, "org.nuiton.topia.taas.jaas.TaasPermission");
            this.addImport((ObjectModelClassifier)result, "org.nuiton.topia.taas.TaasUtil");
            this.addImport((ObjectModelClassifier)result, TopiaDAO.class);
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "getEntityClass", "Class<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(op, "\n        return (Class<E>)" + clazzName + ".class;\n" + "    ");
        this.generateDAOOperations(result, DAOoperations);
        this.generateDelete(clazz, result);
        this.generateNaturalId(result, clazz);
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable()) continue;
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                this.generateNoNMultiplicity(clazzName, result, attr, false);
                continue;
            }
            this.generateNMultiplicity(clazzName, result, attr);
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assocClass = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assocClass.getParticipantsAttributes()) {
                if (attr == null) continue;
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    this.generateNoNMultiplicity(clazzName, result, attr, true);
                    continue;
                }
                this.generateNMultiplicity(clazzName, result, attr);
            }
        }
        if (enableSecurity) {
            op = this.addOperation((ObjectModelClassifier)result, "getRequestPermission", "List<Permission>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.setDocumentation((ObjectModelElement)op, "Retourne les permissions a verifier pour l'acces a l'entite pour le service Taas");
            this.addException(op, TopiaException.class);
            this.addParameter(op, String.class, "topiaId");
            this.addParameter(op, Integer.TYPE, "actions");
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n        List<Permission> resultPermissions = new ArrayList<Permission>();\n        if ((actions & TaasUtil.CREATE) == TaasUtil.CREATE) {\n");
            buffer.append(this.generateSecurity(result, clazz, TopiaGeneratorUtil.getSecurityCreateTagValue((ObjectModelClassifier)clazz)));
            buffer.append("\n        }\n        if ((actions & TaasUtil.LOAD) == TaasUtil.LOAD) {\n");
            buffer.append(this.generateSecurity(result, clazz, TopiaGeneratorUtil.getSecurityLoadTagValue((ObjectModelClassifier)clazz)));
            buffer.append("\n        }\n        if ((actions & TaasUtil.UPDATE) == TaasUtil.UPDATE) {\n");
            buffer.append(this.generateSecurity(result, clazz, TopiaGeneratorUtil.getSecurityUpdateTagValue((ObjectModelClassifier)clazz)));
            buffer.append("\n        }\n        if ((actions & TaasUtil.DELETE) == TaasUtil.DELETE) {\n");
            buffer.append(this.generateSecurity(result, clazz, TopiaGeneratorUtil.getSecurityDeleteTagValue((ObjectModelClassifier)clazz)));
            buffer.append("\n        }\n        return resultPermissions;\n    ");
            this.setOperationBody(op, buffer.toString());
            op = this.addOperation((ObjectModelClassifier)result, "getRequestPermission", "List<Permission>", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
            this.addParameter(op, String.class, "topiaId");
            this.addParameter(op, Integer.TYPE, "actions");
            this.addParameter(op, String.class, "query");
            this.addParameter(op, Class.class, "daoClass");
            this.addException(op, TopiaException.class);
            this.setDocumentation((ObjectModelElement)op, "Retourne les permissions a verifier pour l'acces a l'entite pour le service Taas");
            this.setOperationBody(op, "    TopiaContextImplementor context = getContext();\n    List<String> result = context.findAll(query, \"id\", topiaId);\n\n    List<Permission> resultPermissions = new ArrayList<Permission>();\n    for (String topiaIdPermission : result) {\n        TopiaDAO dao = context.getDAO(daoClass);\n        List<Permission> permissions = dao.getRequestPermission(topiaIdPermission, actions);\n        if(permissions != null) {\n            resultPermissions.addAll(permissions);\n        } else {\n            TaasPermission permission = new TaasPermission(topiaIdPermission, actions);\n            resultPermissions.add(permission);\n        }\n    }\n    return resultPermissions;\n    ");
        }
        Set<ObjectModelClass> usagesForclass = this.usages.get(clazz);
        this.generateFindUsages(clazz, result, usagesForclass);
    }

    protected void generateDelete(ObjectModelClass clazz, ObjectModelClass result) {
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "delete", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addParameter(op, "E", "entity");
        StringBuilder body = new StringBuilder();
        String modelName = StringUtils.capitalize((String)((ObjectModel)this.model).getName());
        String providerFQN = this.getOutputProperties().getProperty("defaultPackage") + '.' + modelName + "DAOHelper.getImplementationClass";
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            String attrType = GeneratorUtil.getSimpleName((String)attr.getType());
            String reverseAttrName = attr.getReverseAttributeName();
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (attr.hasAssociationClass() || reverse == null || !reverse.isNavigable()) continue;
            if (!this.allEntitiesFqn.contains(attr.getType())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("[" + result.getName() + "] Skip attribute [" + attr.getName() + "] with type " + attr.getType()));
                continue;
            }
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) && GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                String attrDBName = TopiaGeneratorUtil.getDbName((ObjectModelElement)attr);
                String attrClassifierDBName = TopiaGeneratorUtil.getDbName((ObjectModelElement)attr.getClassifier());
                String attrJoinTableName = TopiaGeneratorUtil.getManyToManyTableName(attr);
                String attrReverseDBName = TopiaGeneratorUtil.getReverseDbName(attr);
                body.append("\n        {\n            List<" + attrType + "> list = getContext().getHibernate().createSQLQuery(\n" + "                    \"SELECT main.topiaid \" +\n" + "                    \"from " + attrClassifierDBName + " main, " + attrJoinTableName + " secondary \" +\n" + "                    \"where main.topiaid=secondary." + attrDBName + "\" +\n" + "                    \" and secondary." + attrReverseDBName + "='\" + entity.getTopiaId() + \"'\")\n" + "                    .addEntity(\"main\", " + providerFQN + "(" + attrType + ".class)).list();\n" + "\n" + "            for (" + attrType + " item : list) {\n" + "                item.remove" + StringUtils.capitalize((String)reverseAttrName) + "(entity);\n" + "            }\n" + "        }\n" + "");
                continue;
            }
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) continue;
            this.builder.addImport((ObjectModelClassifier)result, attrType);
            String attrSimpleType = TopiaGeneratorUtil.getClassNameFromQualifiedName((String)attrType);
            body.append("\n                                        {\n                                        List<" + attrSimpleType + "> list = getContext()\n" + "                                                    .getDAO(" + attrSimpleType + ".class)\n" + "                                                    .findAllByProperties(" + attrSimpleType + "." + this.getConstantName(reverseAttrName) + ", entity);\n" + "                                            for (" + attrSimpleType + " item : list) {\n" + "                                                item.set" + StringUtils.capitalize((String)reverseAttrName) + "(null);\n" + "                        ");
            if (attr.isAggregate()) {
                body.append("\n            \t\t\tgetContext().getDAO(" + attrSimpleType + ".class).delete(item);\n" + "            \t\t\t//item.delete();\n" + "");
            }
            body.append("\n                    }\n                }\n");
        }
        body.append("\n        super.delete(entity);\n    ");
        this.setOperationBody(op, body.toString());
    }

    private void generateFindUsages(ObjectModelClass clazz, ObjectModelClass result, Set<ObjectModelClass> usagesForclass) {
        this.builder.addImport((ObjectModelClassifier)result, ArrayList.class.getName());
        this.builder.addImport((ObjectModelClassifier)result, Map.class.getName());
        this.builder.addImport((ObjectModelClassifier)result, HashMap.class.getName());
        this.builder.addImport((ObjectModelClassifier)result, TopiaEntity.class.getName());
        if (clazz instanceof ObjectModelAssociationClass || usagesForclass.isEmpty()) {
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)result, "findUsages", "<U extends TopiaEntity> List<U>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "Class<U>", "type");
            this.addParameter(operation, "E", "entity");
            this.addException(operation, TopiaException.class);
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, "Override");
            this.setOperationBody(operation, "\n        return new ArrayList<U>();\n    ");
            operation = this.addOperation((ObjectModelClassifier)result, "findAllUsages", "Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "E", "entity");
            this.addException(operation, TopiaException.class);
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, "Override");
            this.setOperationBody(operation, "\n        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();\n    ");
            return;
        }
        List<ObjectModelClass> allEntities = TopiaGeneratorUtil.getEntityClasses((ObjectModel)this.model, true);
        TreeMap<String, ObjectModelClass> allEntitiesByFQN = new TreeMap<String, ObjectModelClass>();
        for (ObjectModelClass klass : allEntities) {
            allEntitiesByFQN.put(klass.getQualifiedName(), klass);
        }
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)result, "findUsages", "<U extends TopiaEntity> List<U>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "Class<U>", "type");
        this.addParameter(operation, "E", "entity");
        this.addException(operation, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, "Override");
        StringBuilder buffer = new StringBuilder(300);
        buffer.append("\n        List<?> result = new ArrayList();\n        List tmp;\n");
        for (ObjectModelClass usageClass : usagesForclass) {
            String usageType = usageClass.getQualifiedName();
            this.builder.addImport((ObjectModelClassifier)result, usageType);
            String usageSimpleType = TopiaGeneratorUtil.getClassNameFromQualifiedName((String)usageType);
            String usageSimplePropertyMethod = "findAllBy" + usageSimpleType;
            String usageCollectionPropertyMethod = "findAllContaining" + usageSimpleType;
            for (ObjectModelAttribute attr : usageClass.getAttributes()) {
                ObjectModelClass targetEntity;
                String type;
                if (!attr.isNavigable()) continue;
                String attrName = attr.getName();
                if (attr.hasAssociationClass() || !allEntitiesByFQN.containsKey(type = attr.getType()) || !(targetEntity = (ObjectModelClass)allEntitiesByFQN.get(type)).equals(clazz)) continue;
                String methodNameSuffix = StringUtils.capitalize((String)attrName);
                String methodName = TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) ? "findAllContains" + methodNameSuffix : "findAllBy" + methodNameSuffix;
                String daoName = StringUtils.capitalize((String)usageSimpleType) + "DAO";
                this.builder.addImport((ObjectModelClassifier)result, usageClass.getPackageName() + '.' + daoName);
                buffer.append("\n        if (type == " + usageSimpleType + ".class) {\n" + "            " + daoName + " dao = (" + daoName + ")\n" + "                getContext().getDAO(" + usageSimpleType + ".class);\n" + "            tmp = dao." + methodName + "(entity);\n" + "            result.addAll(tmp);\n" + "        }\n" + "");
            }
        }
        buffer.append("\n        return (List<U>) result;\n    ");
        this.setOperationBody(operation, buffer.toString());
        operation = this.addOperation((ObjectModelClassifier)result, "findAllUsages", "Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "E", "entity");
        this.addException(operation, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, "Override");
        buffer = new StringBuilder(300);
        buffer.append("\n        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;\n        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(" + usagesForclass.size() + ");\n" + "        \n" + "        List<? extends TopiaEntity> list;\n" + "");
        for (ObjectModelClass usageClass : usagesForclass) {
            String fqn = usageClass.getName();
            buffer.append("\n        list = findUsages(" + fqn + ".class, entity);\n" + "        if (!list.isEmpty()) {\n" + "            result.put(" + fqn + ".class, list);\n" + "        }\n" + "");
        }
        buffer.append("\n        return result;\n    ");
        this.setOperationBody(operation, buffer.toString());
    }

    private void generateDAOOperations(ObjectModelClass result, Collection<ObjectModelOperation> operations) {
        for (ObjectModelOperation op : operations) {
            ObjectModelOperation op2 = this.addOperation((ObjectModelClassifier)result, op.getName(), op.getReturnType(), new ObjectModelModifier[]{ObjectModelJavaModifier.ABSTRACT, ObjectModelJavaModifier.fromVisibility((String)op.getVisibility())});
            this.setDocumentation((ObjectModelElement)op2, op.getDocumentation());
            for (ObjectModelParameter param : op.getParameters()) {
                ObjectModelParameter param2 = this.addParameter(op2, param.getType(), param.getName());
                this.setDocumentation((ObjectModelElement)param2, param.getDocumentation());
            }
            Set exceptions = op.getExceptions();
            exceptions.add(TopiaException.class.getName());
            for (String exception : exceptions) {
                this.addException(op2, exception);
            }
        }
    }

    private String generateSecurity(ObjectModelClass result, ObjectModelClass clazz, String tagValue) {
        StringBuilder buffer = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)tagValue)) {
            String[] valuesSecurity;
            String security = tagValue;
            Pattern propertiesPattern = Pattern.compile("((?:[_a-zA-Z0-9]+\\.)+(?:_?[A-Z][_a-zA-Z0-9]*\\.)+)attribute\\.(?:([_a-z0-9][_a-zA-Z0-9]*))#(?:(create|load|update|delete))");
            for (String valueSecurity : valuesSecurity = security.split(":")) {
                Matcher matcher = propertiesPattern.matcher(valueSecurity);
                matcher.find();
                String className = matcher.group(1);
                className = StringUtil.substring((String)className, (int)0, (int)-1);
                String attributeName = matcher.group(2);
                String actions = matcher.group(3).toUpperCase();
                String query = "";
                String daoClass = "";
                if (className.equals(clazz.getQualifiedName())) {
                    query = "select " + attributeName + ".topiaId from " + clazz.getQualifiedName() + " where topiaId = :id";
                    daoClass = clazz.getAttribute(attributeName).getClassifier().getQualifiedName();
                } else {
                    query = "select at.topiaId from " + className + " at inner join at." + attributeName + " cl where cl.topiaId = :id";
                    daoClass = className;
                }
                buffer.append("\n              resultPermissions.addAll(getRequestPermission(topiaId,\n                                                            " + actions + ",\n" + "                                                            \"" + query + "\",\n" + "                                                            " + daoClass + ".class));\n" + "");
            }
        } else {
            buffer.append("            return null;\n    ");
        }
        return buffer.toString();
    }

    protected void generateNoNMultiplicity(String clazzName, ObjectModelClass result, ObjectModelAttribute attr, boolean isAssoc) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        String propertyName = attrName;
        if (!isAssoc && attr.hasAssociationClass()) {
            propertyName = TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + '.' + propertyName;
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "findBy" + StringUtils.capitalize((String)attrName), "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addParameter(op, attrType, "v");
        this.setDocumentation((ObjectModelElement)op, "Retourne le premier \u00e9l\u00e9ment trouv\u00e9 ayant comme valeur pour l'attribut " + attrName + " le param\u00e8tre.");
        this.setOperationBody(op, "\n        E result = findByProperty(" + clazzName + "." + this.getConstantName(propertyName) + ", v);\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)result, "findAllBy" + StringUtils.capitalize((String)attrName), "List<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addParameter(op, attrType, "v");
        this.setDocumentation((ObjectModelElement)op, "Retourne les \u00e9l\u00e9ments ayant comme valeur pour l'attribut " + attrName + " le param\u00e8tre.");
        this.setOperationBody(op, "\n        List<E> result = findAllByProperty(" + clazzName + "." + this.getConstantName(propertyName) + ", v);\n" + "        return result;\n" + "    ");
        if (attr.hasAssociationClass()) {
            String assocClassName = attr.getAssociationClass().getName();
            String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            op = this.addOperation((ObjectModelClassifier)result, "findBy" + StringUtils.capitalize((String)assocClassName), "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(op, TopiaException.class);
            this.addParameter(op, assocClassFQN, "value");
            this.setDocumentation((ObjectModelElement)op, "Retourne le premier \u00e9l\u00e9ment trouv\u00e9 ayant comme valeur pour l'attribut " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " le param\u00e8tre.");
            this.setOperationBody(op, "\n        E result = findByProperty(" + clazzName + "." + this.getConstantName(TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName)) + ", value);\n" + "        return result;\n" + "    ");
            op = this.addOperation((ObjectModelClassifier)result, "findAllBy" + StringUtils.capitalize((String)assocClassName), "List<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(op, TopiaException.class);
            this.addParameter(op, assocClassFQN, "value");
            this.setDocumentation((ObjectModelElement)op, "Retourne les \u00e9l\u00e9ments ayant comme valeur pour l'attribut " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " le param\u00e8tre.");
            this.setOperationBody(op, "\n        List<E> result = findAllByProperty(" + clazzName + "." + this.getConstantName(TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName)) + ", value);\n" + "        return result;\n" + "    ");
        }
    }

    protected void generateNMultiplicity(String clazzName, ObjectModelClass result, ObjectModelAttribute attr) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        if (attr.hasAssociationClass()) {
            return;
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "findContains" + StringUtils.capitalize((String)attrName), "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addParameter(op, attrType, "v");
        this.setDocumentation((ObjectModelElement)op, "Retourne le premier \u00e9l\u00e9ment ayant comme valeur pour l'attribut " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attrName) + " le param\u00e8tre.");
        this.setOperationBody(op, "\n        E result = findContains(" + clazzName + "." + this.getConstantName(attrName) + ", v);\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)result, "findAllContains" + StringUtils.capitalize((String)attrName), "List<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addParameter(op, attrType, "v");
        this.setDocumentation((ObjectModelElement)op, "Retourne les \u00e9l\u00e9ments ayant comme valeur pour l'attribut " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attrName) + " le param\u00e8tre.");
        this.setOperationBody(op, "\n        List<E> result = findAllContains(" + clazzName + "." + this.getConstantName(attrName) + ", v);\n" + "        return result;\n" + "    ");
    }

    private boolean isCollectionNeeded(Collection<ObjectModelOperation> operations) {
        return this.isImportNeeded(operations, "Collection");
    }

    private boolean isSetNeeded(Collection<ObjectModelOperation> operations) {
        return this.isImportNeeded(operations, "Set");
    }

    private boolean isImportNeeded(Collection<ObjectModelOperation> operations, String importName) {
        for (ObjectModelOperation op : operations) {
            if (op.getReturnType().contains(importName)) {
                return true;
            }
            for (ObjectModelParameter param : op.getParameters()) {
                if (!param.getType().contains(importName)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<ObjectModelOperation> getDAOOperations(ObjectModelClass clazz) {
        ArrayList<ObjectModelOperation> results = new ArrayList<ObjectModelOperation>();
        for (ObjectModelOperation op : clazz.getOperations()) {
            if (!TopiaGeneratorUtil.hasDaoStereotype(op)) continue;
            results.add(op);
        }
        Collection<ObjectModelOperation> extra = this.extraOperations.get(clazz.getQualifiedName());
        if (extra != null) {
            for (ObjectModelOperation op : extra) {
                results.add(op);
            }
        }
        return results;
    }

    private void generateNaturalId(ObjectModelClass result, ObjectModelClass clazz) {
        Set<ObjectModelAttribute> props = TopiaGeneratorUtil.getNaturalIdAttributes(clazz);
        if (!props.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("generateNaturalId for " + props));
            }
            ObjectModelOperation findByNaturalId = this.addOperation((ObjectModelClassifier)result, "findByNaturalId", "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(findByNaturalId, TopiaException.class);
            ObjectModelOperation existByNaturalId = this.addOperation((ObjectModelClassifier)result, "existByNaturalId", "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(existByNaturalId, TopiaException.class);
            ObjectModelOperation create = this.addOperation((ObjectModelClassifier)result, "create", "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(create, TopiaException.class);
            String searchProperties = "";
            String params = "";
            String clazzName = clazz.getName();
            for (ObjectModelAttribute attr : props) {
                String propName = attr.getName();
                this.addParameter(findByNaturalId, attr.getType(), propName);
                this.addParameter(existByNaturalId, attr.getType(), propName);
                this.addParameter(create, attr.getType(), propName);
                searchProperties = searchProperties + ", " + clazzName + '.' + this.getConstantName(propName) + ", " + propName;
            }
            searchProperties = searchProperties.substring(2);
            this.setOperationBody(findByNaturalId, "\n        return findByProperties(" + searchProperties + ");\n" + "    ");
            this.setOperationBody(existByNaturalId, "\n        return existByProperties(" + searchProperties + ");\n" + "    ");
            this.setOperationBody(create, "\n        return create(" + searchProperties + ");\n" + "    ");
        }
    }
}

