/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.PropertyValueException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topiatest.NaturalizedEntityDAO;

public class NaturalIdTest {
    private static final Log log = LogFactory.getLog(NaturalIdTest.class);
    @Rule
    public final TopiaDatabase db = new TopiaDatabase();

    @Test
    public void testCreateSucessfull() throws Exception {
        log.debug((Object)"Test naturalId : create succesfull");
        TopiaContext transaction = this.db.beginTransaction();
        NaturalizedEntityDAO dao = TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);
        dao.createByNaturalId(5, "str");
        transaction.commitTransaction();
        dao.createByNotNull(3);
        transaction.commitTransaction();
        dao.create(new Object[]{"naturalIdNotNull", 3});
        transaction.commitTransaction();
    }

    @Test
    public void testCreateFailed() throws Exception {
        log.debug((Object)"Test naturalId : create failed");
        TopiaContext transaction = this.db.beginTransaction();
        NaturalizedEntityDAO dao = TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);
        try {
            dao.create(new Object[0]);
            transaction.commitTransaction();
        }
        catch (PropertyValueException eee) {
            Assert.assertEquals((Object)"naturalIdNotNull", (Object)eee.getPropertyName());
        }
    }

    @Test
    public void testUpdateFailed() throws Exception {
        log.debug((Object)"Test naturalId : update failed");
        TopiaContext transaction = this.db.beginTransaction();
        NaturalizedEntityDAO dao = TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);
        Object entity = dao.createByNaturalId(5, "str");
        transaction.commitTransaction();
        try {
            entity.setNaturalIdNotNull(8);
            transaction.commitTransaction();
        }
        catch (TopiaException eee) {
            Assert.assertEquals((Object)"org.hibernate.HibernateException", (Object)eee.getCause().getClass().getName());
        }
    }

    @Test
    public void testFindByNaturalId() throws Exception {
        log.debug((Object)"Test naturalId : findByNaturalId");
        TopiaContext transaction = this.db.beginTransaction();
        NaturalizedEntityDAO dao = TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);
        Object entity = dao.createByNaturalId(5, "str");
        transaction.commitTransaction();
        Object result = dao.findByNaturalId(5, "str");
        Assert.assertEquals(entity, result);
    }

    @Test
    public void testExistNaturalId() throws Exception {
        log.debug((Object)"Test naturalId : existNaturalId");
        TopiaContext transaction = this.db.beginTransaction();
        NaturalizedEntityDAO dao = TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);
        dao.createByNaturalId(5, "str");
        transaction.commitTransaction();
        boolean result = dao.existByNaturalId(5, "str");
        Assert.assertTrue((boolean)result);
        result = dao.existByNaturalId(8, "str");
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testNaturalIdAreGeneralized() throws Exception {
        Object[] generalizedNaturalizedNaturalIds = TopiaTestDAOHelper.TopiaTestEntityEnum.GeneralizedNaturalizedEntity.getNaturalIds();
        Object[] naturalizedNaturalIds = TopiaTestDAOHelper.TopiaTestEntityEnum.NaturalizedEntity.getNaturalIds();
        Assert.assertArrayEquals((Object[])generalizedNaturalizedNaturalIds, (Object[])naturalizedNaturalIds);
    }

    @Test
    public void testNotNullsAreGeneralized() throws Exception {
        Object[] generalizedNaturalizedNotNulls = TopiaTestDAOHelper.TopiaTestEntityEnum.GeneralizedNaturalizedEntity.getNotNulls();
        Object[] naturalizedNotNulls = TopiaTestDAOHelper.TopiaTestEntityEnum.NaturalizedEntity.getNotNulls();
        Assert.assertArrayEquals((Object[])generalizedNaturalizedNotNulls, (Object[])naturalizedNotNulls);
    }
}

