package org.nuiton.topia;

import java.util.HashMap;
import java.util.Map;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.Race;
import org.nuiton.topiatest.Address;
import org.nuiton.topiatest.Bill;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.ExtraDAOEntity;
import org.nuiton.topiatest.Gender;
import org.nuiton.topiatest.NaturalizedEntity;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.Product;
import org.nuiton.topiatest.QueriedEntity;
import org.nuiton.topiatest.Store;
import org.nuiton.topiatest.Type;
import org.nuiton.topiatest.deletetest.Contact2;
import org.nuiton.topiatest.deletetest.Party2;
import org.nuiton.topiatest.deletetest.Telephone2;


public  class TopiaTestQueryHelper {



    public static  abstract class EntityProperty<E> {

        protected String alias;
        protected Map<String, String> propertiesCache;
        /**
         * EntityProperty :
         */

        public EntityProperty()     {
            propertiesCache = new HashMap<String, String>();
        }

        /**
         * setAlias :
             * @param alias 
     */

        protected void setAlias(String alias)     {
            this.alias = alias;
        }

        /**
         * $alias :
             * @return String 
     */

        public String $alias()     {
            return alias;
        }

        /**
         * $property :
             * @param propertyName 
         * @return String 
     */

        public String $property(String propertyName)     {
            String result = propertiesCache.get(propertyName);
            if (result == null) {
                result = TopiaQuery.getProperty(alias, propertyName);
                propertiesCache.put(propertyName, result);
            }
            return result;
        }

        /**
         * topiaCreateDate :
             * @return String 
     */

        public String topiaCreateDate()     {
            return $property(TopiaEntity.TOPIA_CREATE_DATE);
        }

        /**
         * topiaId :
             * @return String 
     */

        public String topiaId()     {
            return $property(TopiaEntity.TOPIA_ID);
        }

        /**
         * topiaVersion :
             * @return String 
     */

        public String topiaVersion()     {
            return $property(TopiaEntity.TOPIA_VERSION);
        }

        /**
         * getEntityClass :
             * @return Class<E> 
     */

        public abstract Class<E> getEntityClass();

        /**
         * defaultAlias :
             * @return String 
     */

        public abstract String defaultAlias();


    } //EntityProperty<E>


    public static  class CompanyProperty extends EntityProperty<Company> {

        /**
         * CompanyProperty :
         */

        protected CompanyProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<Company> 
     */

    @Override
        public Class<Company> getEntityClass()     {
            return Company.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_COMPANY;
        }

        /**
         * name :
             * @return String 
     */

        public String name()     {
            return $property(Company.PROPERTY_NAME);
        }

        /**
         * siret :
             * @return String 
     */

        public String siret()     {
            return $property(Company.PROPERTY_SIRET);
        }

        /**
         * employe :
             * @return String 
     */

        public String employe()     {
            return $property(Company.PROPERTY_EMPLOYE);
        }

        /**
         * storeBill :
             * @return String 
     */

        public String storeBill()     {
            return $property(Company.PROPERTY_STORE_BILL);
        }

        /**
         * storeBillProperty :
             * @return BillProperty 
     */

        public BillProperty storeBillProperty()     {
            return newBillProperty(storeBill());
        }

        /**
         * department :
             * @return String 
     */

        public String department()     {
            return $property(Company.PROPERTY_DEPARTMENT);
        }


    } //CompanyProperty


    public static  class TypeProperty extends EntityProperty<Type> {

        /**
         * TypeProperty :
         */

        protected TypeProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<Type> 
     */

    @Override
        public Class<Type> getEntityClass()     {
            return Type.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_TYPE;
        }

        /**
         * name :
             * @return String 
     */

        public String name()     {
            return $property(Type.PROPERTY_NAME);
        }


    } //TypeProperty


    public static  class Telephone2Property extends EntityProperty<Telephone2> {

        /**
         * Telephone2Property :
         */

        protected Telephone2Property()     {
        }

        /**
         * getEntityClass :
             * @return Class<Telephone2> 
     */

    @Override
        public Class<Telephone2> getEntityClass()     {
            return Telephone2.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_TELEPHONE2;
        }

        /**
         * prefix :
             * @return String 
     */

        public String prefix()     {
            return $property(Telephone2.PROPERTY_PREFIX);
        }

        /**
         * country :
             * @return String 
     */

        public String country()     {
            return $property(Telephone2.PROPERTY_COUNTRY);
        }


    } //Telephone2Property


    public static  class BillProperty extends EntityProperty<Bill> {

        /**
         * BillProperty :
         */

        protected BillProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<Bill> 
     */

    @Override
        public Class<Bill> getEntityClass()     {
            return Bill.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_BILL;
        }

        /**
         * cost :
             * @return String 
     */

        public String cost()     {
            return $property(Bill.PROPERTY_COST);
        }

        /**
         * date :
             * @return String 
     */

        public String date()     {
            return $property(Bill.PROPERTY_DATE);
        }

        /**
         * paid :
             * @return String 
     */

        public String paid()     {
            return $property(Bill.PROPERTY_PAID);
        }

        /**
         * store :
             * @return String 
     */

        public String store()     {
            return $property(Bill.PROPERTY_STORE);
        }

        /**
         * storeBillProperty :
             * @return BillProperty 
     */

        public BillProperty storeBillProperty()     {
            return newBillProperty(store());
        }

        /**
         * company :
             * @return String 
     */

        public String company()     {
            return $property(Bill.PROPERTY_COMPANY);
        }

        /**
         * companyBillProperty :
             * @return BillProperty 
     */

        public BillProperty companyBillProperty()     {
            return newBillProperty(company());
        }


    } //BillProperty


    public static  class PersonneProperty extends EntityProperty<Personne> {

        /**
         * PersonneProperty :
         */

        protected PersonneProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<Personne> 
     */

    @Override
        public Class<Personne> getEntityClass()     {
            return Personne.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_PERSONNE;
        }

        /**
         * name :
             * @return String 
     */

        public String name()     {
            return $property(Personne.PROPERTY_NAME);
        }

        /**
         * otherNames :
             * @return String 
     */

        public String otherNames()     {
            return $property(Personne.PROPERTY_OTHER_NAMES);
        }

        /**
         * gender :
             * @return String 
     */

        public String gender()     {
            return $property(Personne.PROPERTY_GENDER);
        }

        /**
         * genderProperty :
             * @return GenderProperty 
     */

        public GenderProperty genderProperty()     {
            return newGenderProperty(gender());
        }

        /**
         * otherGender :
             * @return String 
     */

        public String otherGender()     {
            return $property(Personne.PROPERTY_OTHER_GENDER);
        }

        /**
         * otherGenderProperty :
             * @return GenderProperty 
     */

        public GenderProperty otherGenderProperty()     {
            return newGenderProperty(otherGender());
        }

        /**
         * address :
             * @return String 
     */

        public String address()     {
            return $property(Personne.PROPERTY_ADDRESS);
        }

        /**
         * addressProperty :
             * @return AddressProperty 
     */

        public AddressProperty addressProperty()     {
            return newAddressProperty(address());
        }


    } //PersonneProperty


    public static  class EmployeProperty extends EntityProperty<Employe> {

        /**
         * EmployeProperty :
         */

        protected EmployeProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<Employe> 
     */

    @Override
        public Class<Employe> getEntityClass()     {
            return Employe.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_EMPLOYE;
        }

        /**
         * salary :
             * @return String 
     */

        public String salary()     {
            return $property(Employe.PROPERTY_SALARY);
        }


    } //EmployeProperty


    public static  class NaturalizedEntityProperty extends EntityProperty<NaturalizedEntity> {

        /**
         * NaturalizedEntityProperty :
         */

        protected NaturalizedEntityProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<NaturalizedEntity> 
     */

    @Override
        public Class<NaturalizedEntity> getEntityClass()     {
            return NaturalizedEntity.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_NATURALIZED_ENTITY;
        }

        /**
         * naturalIdNotNull :
             * @return String 
     */

        public String naturalIdNotNull()     {
            return $property(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL);
        }

        /**
         * naturalIdNull :
             * @return String 
     */

        public String naturalIdNull()     {
            return $property(NaturalizedEntity.PROPERTY_NATURAL_ID_NULL);
        }


    } //NaturalizedEntityProperty


    public static  class PetProperty extends EntityProperty<Pet> {

        /**
         * PetProperty :
         */

        protected PetProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<Pet> 
     */

    @Override
        public Class<Pet> getEntityClass()     {
            return Pet.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_PET;
        }

        /**
         * name :
             * @return String 
     */

        public String name()     {
            return $property(Pet.PROPERTY_NAME);
        }

        /**
         * type :
             * @return String 
     */

        public String type()     {
            return $property(Pet.PROPERTY_TYPE);
        }

        /**
         * person :
             * @return String 
     */

        public String person()     {
            return $property(Pet.PROPERTY_PERSON);
        }

        /**
         * personProperty :
             * @return PersonProperty 
     */

        public PersonProperty personProperty()     {
            return newPersonProperty(person());
        }

        /**
         * race :
             * @return String 
     */

        public String race()     {
            return $property(Pet.PROPERTY_RACE);
        }

        /**
         * raceProperty :
             * @return RaceProperty 
     */

        public RaceProperty raceProperty()     {
            return newRaceProperty(race());
        }


    } //PetProperty


    public static  class Contact2Property extends EntityProperty<Contact2> {

        /**
         * Contact2Property :
         */

        protected Contact2Property()     {
        }

        /**
         * getEntityClass :
             * @return Class<Contact2> 
     */

    @Override
        public Class<Contact2> getEntityClass()     {
            return Contact2.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_CONTACT2;
        }

        /**
         * contactValue :
             * @return String 
     */

        public String contactValue()     {
            return $property(Contact2.PROPERTY_CONTACT_VALUE);
        }

        /**
         * type :
             * @return String 
     */

        public String type()     {
            return $property(Contact2.PROPERTY_TYPE);
        }

        /**
         * party2 :
             * @return String 
     */

        public String party2()     {
            return $property(Contact2.PROPERTY_PARTY2);
        }


    } //Contact2Property


    public static  class RaceProperty extends EntityProperty<Race> {

        /**
         * RaceProperty :
         */

        protected RaceProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<Race> 
     */

    @Override
        public Class<Race> getEntityClass()     {
            return Race.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_RACE;
        }

        /**
         * name :
             * @return String 
     */

        public String name()     {
            return $property(Race.PROPERTY_NAME);
        }


    } //RaceProperty


    public static  class DepartmentProperty extends EntityProperty<Department> {

        /**
         * DepartmentProperty :
         */

        protected DepartmentProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<Department> 
     */

    @Override
        public Class<Department> getEntityClass()     {
            return Department.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_DEPARTMENT;
        }

        /**
         * name :
             * @return String 
     */

        public String name()     {
            return $property(Department.PROPERTY_NAME);
        }

        /**
         * leader :
             * @return String 
     */

        public String leader()     {
            return $property(Department.PROPERTY_LEADER);
        }

        /**
         * leaderProperty :
             * @return EmployeProperty 
     */

        public EmployeProperty leaderProperty()     {
            return newEmployeProperty(leader());
        }

        /**
         * company :
             * @return String 
     */

        public String company()     {
            return $property(Department.PROPERTY_COMPANY);
        }

        /**
         * companyProperty :
             * @return CompanyProperty 
     */

        public CompanyProperty companyProperty()     {
            return newCompanyProperty(company());
        }

        /**
         * product :
             * @return String 
     */

        public String product()     {
            return $property(Department.PROPERTY_PRODUCT);
        }


    } //DepartmentProperty


    public static  class ProductProperty extends EntityProperty<Product> {

        /**
         * ProductProperty :
         */

        protected ProductProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<Product> 
     */

    @Override
        public Class<Product> getEntityClass()     {
            return Product.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_PRODUCT;
        }

        /**
         * name :
             * @return String 
     */

        public String name()     {
            return $property(Product.PROPERTY_NAME);
        }

        /**
         * type :
             * @return String 
     */

        public String type()     {
            return $property(Product.PROPERTY_TYPE);
        }

        /**
         * typeProperty :
             * @return TypeProperty 
     */

        public TypeProperty typeProperty()     {
            return newTypeProperty(type());
        }


    } //ProductProperty


    public static  class GenderProperty extends EntityProperty<Gender> {

        /**
         * GenderProperty :
         */

        protected GenderProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<Gender> 
     */

    @Override
        public Class<Gender> getEntityClass()     {
            return Gender.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_GENDER;
        }


    } //GenderProperty


    public static  class QueriedEntityProperty extends EntityProperty<QueriedEntity> {

        /**
         * QueriedEntityProperty :
         */

        protected QueriedEntityProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<QueriedEntity> 
     */

    @Override
        public Class<QueriedEntity> getEntityClass()     {
            return QueriedEntity.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_QUERIED_ENTITY;
        }

        /**
         * testAdd :
             * @return String 
     */

        public String testAdd()     {
            return $property(QueriedEntity.PROPERTY_TEST_ADD);
        }


    } //QueriedEntityProperty


    public static  class Party2Property extends EntityProperty<Party2> {

        /**
         * Party2Property :
         */

        protected Party2Property()     {
        }

        /**
         * getEntityClass :
             * @return Class<Party2> 
     */

    @Override
        public Class<Party2> getEntityClass()     {
            return Party2.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_PARTY2;
        }

        /**
         * contacts :
             * @return String 
     */

        public String contacts()     {
            return $property(Party2.PROPERTY_CONTACTS);
        }


    } //Party2Property


    public static  class AddressProperty extends EntityProperty<Address> {

        /**
         * AddressProperty :
         */

        protected AddressProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<Address> 
     */

    @Override
        public Class<Address> getEntityClass()     {
            return Address.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_ADDRESS;
        }

        /**
         * city :
             * @return String 
     */

        public String city()     {
            return $property(Address.PROPERTY_CITY);
        }

        /**
         * adress :
             * @return String 
     */

        public String adress()     {
            return $property(Address.PROPERTY_ADRESS);
        }


    } //AddressProperty


    public static  class ExtraDAOEntityProperty extends EntityProperty<ExtraDAOEntity> {

        /**
         * ExtraDAOEntityProperty :
         */

        protected ExtraDAOEntityProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<ExtraDAOEntity> 
     */

    @Override
        public Class<ExtraDAOEntity> getEntityClass()     {
            return ExtraDAOEntity.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_EXTRA_DAOENTITY;
        }

        /**
         * attr1 :
             * @return String 
     */

        public String attr1()     {
            return $property(ExtraDAOEntity.PROPERTY_ATTR1);
        }


    } //ExtraDAOEntityProperty


    public static  class PersonProperty extends EntityProperty<Person> {

        /**
         * PersonProperty :
         */

        protected PersonProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<Person> 
     */

    @Override
        public Class<Person> getEntityClass()     {
            return Person.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_PERSON;
        }

        /**
         * name :
             * @return String 
     */

        public String name()     {
            return $property(Person.PROPERTY_NAME);
        }

        /**
         * firstname :
             * @return String 
     */

        public String firstname()     {
            return $property(Person.PROPERTY_FIRSTNAME);
        }

        /**
         * pet :
             * @return String 
     */

        public String pet()     {
            return $property(Person.PROPERTY_PET);
        }


    } //PersonProperty


    public static  class StoreProperty extends EntityProperty<Store> {

        /**
         * StoreProperty :
         */

        protected StoreProperty()     {
        }

        /**
         * getEntityClass :
             * @return Class<Store> 
     */

    @Override
        public Class<Store> getEntityClass()     {
            return Store.class;
        }

        /**
         * defaultAlias :
             * @return String 
     */

    @Override
        public String defaultAlias()     {
            return ALIAS_STORE;
        }

        /**
         * name :
             * @return String 
     */

        public String name()     {
            return $property(Store.PROPERTY_NAME);
        }


    } //StoreProperty
        public static final String ALIAS_COMPANY = "C";
        public static final String ALIAS_TYPE = "T";
        public static final String ALIAS_TELEPHONE2 = "TE";
        public static final String ALIAS_BILL = "B";
        public static final String ALIAS_PERSONNE = "P";
        public static final String ALIAS_EMPLOYE = "E";
        public static final String ALIAS_NATURALIZED_ENTITY = "NE";
        public static final String ALIAS_PET = "PE";
        public static final String ALIAS_CONTACT2 = "CO";
        public static final String ALIAS_RACE = "R";
        public static final String ALIAS_DEPARTMENT = "D";
        public static final String ALIAS_PRODUCT = "PR";
        public static final String ALIAS_GENDER = "G";
        public static final String ALIAS_QUERIED_ENTITY = "QE";
        public static final String ALIAS_PARTY2 = "PA";
        public static final String ALIAS_ADDRESS = "A";
        public static final String ALIAS_EXTRA_DAOENTITY = "ED";
        public static final String ALIAS_PERSON = "PER";
        public static final String ALIAS_STORE = "S";
        /**
         * createQuery :
             * @param property 
         * @return TopiaQuery 
     */

        public static TopiaQuery createQuery(EntityProperty property)     {
        return new TopiaQuery((Class<? extends TopiaEntity>)property.getEntityClass(), property.$alias());
        }

        /**
         * format :
             * @param statement 
         * @param propertyNames 
         * @return String 
     */

        public static String format(String statement, String... propertyNames)     {
        for (int i = 1; i <= propertyNames.length; i++) {
           statement = statement.replace("$" + i, propertyNames[i-1]);
        }
        return statement;
        }

        /**
         * newEntityProperty :
             * @param propertyClass 
         * @return <P extends EntityProperty> P 
     */

        private static <P extends EntityProperty> P newEntityProperty(Class<P> propertyClass)     {
        return newEntityProperty(propertyClass, null);
        }

        /**
         * newEntityProperty :
             * @param propertyClass 
         * @param alias 
         * @return <P extends EntityProperty> P 
     */

        private static <P extends EntityProperty> P newEntityProperty(Class<P> propertyClass, String alias)     {
        try {
            P property = propertyClass.newInstance();
            if (alias == null) {
                alias = property.defaultAlias();
            }
            property.setAlias(alias);
            return property;
        } catch (Exception eee) {
    
            throw new Error("Error instantiate " + propertyClass.getName(), eee);
    
        }
        }

        /**
         * newCompanyProperty :
             * @return CompanyProperty 
     */

        public static CompanyProperty newCompanyProperty()     {
        return newCompanyProperty(null);
        }

        /**
         * newCompanyProperty :
             * @param alias 
         * @return CompanyProperty 
     */

        public static CompanyProperty newCompanyProperty(String alias)     {
        return newEntityProperty(CompanyProperty.class, alias);
        }

        /**
         * newTypeProperty :
             * @return TypeProperty 
     */

        public static TypeProperty newTypeProperty()     {
        return newTypeProperty(null);
        }

        /**
         * newTypeProperty :
             * @param alias 
         * @return TypeProperty 
     */

        public static TypeProperty newTypeProperty(String alias)     {
        return newEntityProperty(TypeProperty.class, alias);
        }

        /**
         * newTelephone2Property :
             * @return Telephone2Property 
     */

        public static Telephone2Property newTelephone2Property()     {
        return newTelephone2Property(null);
        }

        /**
         * newTelephone2Property :
             * @param alias 
         * @return Telephone2Property 
     */

        public static Telephone2Property newTelephone2Property(String alias)     {
        return newEntityProperty(Telephone2Property.class, alias);
        }

        /**
         * newBillProperty :
             * @return BillProperty 
     */

        public static BillProperty newBillProperty()     {
        return newBillProperty(null);
        }

        /**
         * newBillProperty :
             * @param alias 
         * @return BillProperty 
     */

        public static BillProperty newBillProperty(String alias)     {
        return newEntityProperty(BillProperty.class, alias);
        }

        /**
         * newPersonneProperty :
             * @return PersonneProperty 
     */

        public static PersonneProperty newPersonneProperty()     {
        return newPersonneProperty(null);
        }

        /**
         * newPersonneProperty :
             * @param alias 
         * @return PersonneProperty 
     */

        public static PersonneProperty newPersonneProperty(String alias)     {
        return newEntityProperty(PersonneProperty.class, alias);
        }

        /**
         * newEmployeProperty :
             * @return EmployeProperty 
     */

        public static EmployeProperty newEmployeProperty()     {
        return newEmployeProperty(null);
        }

        /**
         * newEmployeProperty :
             * @param alias 
         * @return EmployeProperty 
     */

        public static EmployeProperty newEmployeProperty(String alias)     {
        return newEntityProperty(EmployeProperty.class, alias);
        }

        /**
         * newNaturalizedEntityProperty :
             * @return NaturalizedEntityProperty 
     */

        public static NaturalizedEntityProperty newNaturalizedEntityProperty()     {
        return newNaturalizedEntityProperty(null);
        }

        /**
         * newNaturalizedEntityProperty :
             * @param alias 
         * @return NaturalizedEntityProperty 
     */

        public static NaturalizedEntityProperty newNaturalizedEntityProperty(String alias)     {
        return newEntityProperty(NaturalizedEntityProperty.class, alias);
        }

        /**
         * newPetProperty :
             * @return PetProperty 
     */

        public static PetProperty newPetProperty()     {
        return newPetProperty(null);
        }

        /**
         * newPetProperty :
             * @param alias 
         * @return PetProperty 
     */

        public static PetProperty newPetProperty(String alias)     {
        return newEntityProperty(PetProperty.class, alias);
        }

        /**
         * newContact2Property :
             * @return Contact2Property 
     */

        public static Contact2Property newContact2Property()     {
        return newContact2Property(null);
        }

        /**
         * newContact2Property :
             * @param alias 
         * @return Contact2Property 
     */

        public static Contact2Property newContact2Property(String alias)     {
        return newEntityProperty(Contact2Property.class, alias);
        }

        /**
         * newRaceProperty :
             * @return RaceProperty 
     */

        public static RaceProperty newRaceProperty()     {
        return newRaceProperty(null);
        }

        /**
         * newRaceProperty :
             * @param alias 
         * @return RaceProperty 
     */

        public static RaceProperty newRaceProperty(String alias)     {
        return newEntityProperty(RaceProperty.class, alias);
        }

        /**
         * newDepartmentProperty :
             * @return DepartmentProperty 
     */

        public static DepartmentProperty newDepartmentProperty()     {
        return newDepartmentProperty(null);
        }

        /**
         * newDepartmentProperty :
             * @param alias 
         * @return DepartmentProperty 
     */

        public static DepartmentProperty newDepartmentProperty(String alias)     {
        return newEntityProperty(DepartmentProperty.class, alias);
        }

        /**
         * newProductProperty :
             * @return ProductProperty 
     */

        public static ProductProperty newProductProperty()     {
        return newProductProperty(null);
        }

        /**
         * newProductProperty :
             * @param alias 
         * @return ProductProperty 
     */

        public static ProductProperty newProductProperty(String alias)     {
        return newEntityProperty(ProductProperty.class, alias);
        }

        /**
         * newGenderProperty :
             * @return GenderProperty 
     */

        public static GenderProperty newGenderProperty()     {
        return newGenderProperty(null);
        }

        /**
         * newGenderProperty :
             * @param alias 
         * @return GenderProperty 
     */

        public static GenderProperty newGenderProperty(String alias)     {
        return newEntityProperty(GenderProperty.class, alias);
        }

        /**
         * newQueriedEntityProperty :
             * @return QueriedEntityProperty 
     */

        public static QueriedEntityProperty newQueriedEntityProperty()     {
        return newQueriedEntityProperty(null);
        }

        /**
         * newQueriedEntityProperty :
             * @param alias 
         * @return QueriedEntityProperty 
     */

        public static QueriedEntityProperty newQueriedEntityProperty(String alias)     {
        return newEntityProperty(QueriedEntityProperty.class, alias);
        }

        /**
         * newParty2Property :
             * @return Party2Property 
     */

        public static Party2Property newParty2Property()     {
        return newParty2Property(null);
        }

        /**
         * newParty2Property :
             * @param alias 
         * @return Party2Property 
     */

        public static Party2Property newParty2Property(String alias)     {
        return newEntityProperty(Party2Property.class, alias);
        }

        /**
         * newAddressProperty :
             * @return AddressProperty 
     */

        public static AddressProperty newAddressProperty()     {
        return newAddressProperty(null);
        }

        /**
         * newAddressProperty :
             * @param alias 
         * @return AddressProperty 
     */

        public static AddressProperty newAddressProperty(String alias)     {
        return newEntityProperty(AddressProperty.class, alias);
        }

        /**
         * newExtraDAOEntityProperty :
             * @return ExtraDAOEntityProperty 
     */

        public static ExtraDAOEntityProperty newExtraDAOEntityProperty()     {
        return newExtraDAOEntityProperty(null);
        }

        /**
         * newExtraDAOEntityProperty :
             * @param alias 
         * @return ExtraDAOEntityProperty 
     */

        public static ExtraDAOEntityProperty newExtraDAOEntityProperty(String alias)     {
        return newEntityProperty(ExtraDAOEntityProperty.class, alias);
        }

        /**
         * newPersonProperty :
             * @return PersonProperty 
     */

        public static PersonProperty newPersonProperty()     {
        return newPersonProperty(null);
        }

        /**
         * newPersonProperty :
             * @param alias 
         * @return PersonProperty 
     */

        public static PersonProperty newPersonProperty(String alias)     {
        return newEntityProperty(PersonProperty.class, alias);
        }

        /**
         * newStoreProperty :
             * @return StoreProperty 
     */

        public static StoreProperty newStoreProperty()     {
        return newStoreProperty(null);
        }

        /**
         * newStoreProperty :
             * @param alias 
         * @return StoreProperty 
     */

        public static StoreProperty newStoreProperty(String alias)     {
        return newEntityProperty(StoreProperty.class, alias);
        }


    } //TopiaTestQueryHelper
