/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TestHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.persistence.DepthEntityVisitor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.ExportXMLVisitor;
import org.nuiton.topiatest.Address;
import org.nuiton.topiatest.AddressDAO;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.CompanyDAO;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.DepartmentDAO;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.EmployeDAO;
import org.nuiton.util.FileUtil;

public class EntityVisitorExportXmlTest {
    private static Log log = LogFactory.getLog(EntityVisitorExportXmlTest.class);
    protected static File tempDir;
    protected static Properties config;

    @BeforeClass
    public static void init() throws IOException {
        File testBasedir = TestHelper.getTestBasedir(EntityVisitorExportXmlTest.class);
        tempDir = FileUtil.createTempDirectory((String)"h2", (String)"-exportxml", (File)testBasedir);
        String dburl = "file:" + tempDir.getAbsolutePath() + File.separator + "data";
        config = new Properties();
        config.setProperty("topia.persistence.classes", TopiaTestDAOHelper.getImplementationClassesAsString());
        config.setProperty("hibernate.connection.username", "sa");
        config.setProperty("hibernate.connection.password", "");
        config.setProperty("hibernate.current_session_context_class", "thread");
        config.setProperty("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        config.setProperty("hibernate.connection.driver_class", "org.h2.Driver");
        config.setProperty("hibernate.connection.url", "jdbc:h2:" + dburl);
    }

    @AfterClass
    public static void clear() {
    }

    @Before
    public void setUp() throws TopiaException {
        TopiaContext context = TopiaContextFactory.getContext((Properties)config);
        context.createSchema();
        this.addData(context);
    }

    protected void addData(TopiaContext context) throws TopiaException {
        TopiaContext newContext = context.beginTransaction();
        CompanyDAO companyDAO = TopiaTestDAOHelper.getCompanyDAO(newContext);
        Company clCompany = (Company)companyDAO.create(new Object[0]);
        clCompany.setName("CodeLutin");
        EmployeDAO employeDAO = TopiaTestDAOHelper.getEmployeDAO(newContext);
        Employe empl1 = (Employe)employeDAO.create(new Object[0]);
        empl1.setName("boss");
        empl1.setSalary(30000);
        AddressDAO adressDAO = TopiaTestDAOHelper.getAddressDAO(newContext);
        Address addr1 = (Address)adressDAO.create(new Object[0]);
        addr1.setCity("nantes");
        addr1.setAdress("bd des pas enchant\u00e9s");
        empl1.setAddress(addr1);
        Employe empl2 = (Employe)employeDAO.create(new Object[0]);
        empl2.setName("boss2");
        empl2.setSalary(29000);
        Address addr2 = (Address)adressDAO.create(new Object[0]);
        addr2.setCity("nantes");
        addr2.setAdress("bd des pas enchant\u00e9s");
        empl2.setAddress(addr2);
        DepartmentDAO departmentDAO = TopiaTestDAOHelper.getDepartmentDAO(newContext);
        Department depComm = (Department)departmentDAO.create(new Object[0]);
        depComm.setName("Commercial");
        depComm.setLeader(empl1);
        Department depDev = (Department)departmentDAO.create(new Object[0]);
        depDev.setName("Dev");
        depDev.setLeader(empl2);
        clCompany.addDepartment(depComm);
        clCompany.addDepartment(depDev);
        newContext.commitTransaction();
        newContext.closeContext();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testExportXMLDepth() throws TopiaException {
        TopiaContext rootContext = TopiaContextFactory.getContext((Properties)config);
        TopiaContext context = rootContext.beginTransaction();
        CompanyDAO companyDAO = TopiaTestDAOHelper.getCompanyDAO(context);
        Object clCompany = companyDAO.findByName("CodeLutin");
        ExportXMLVisitor delegateVisitor = new ExportXMLVisitor();
        DepthEntityVisitor visitor = new DepthEntityVisitor((EntityVisitor)delegateVisitor);
        clCompany.accept((EntityVisitor)visitor);
        context.closeContext();
        if (log.isInfoEnabled()) {
            log.info((Object)("Export XML = \n" + ((Object)delegateVisitor).toString()));
        }
    }
}

