package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topiatest.deletetest.Party2Impl;

public  abstract class PersonneAbstract extends Party2Impl implements Personne {

    /**
     * Nom de l'attribut en BD : name

     */
    protected String name;
    /**
     * Nom de l'attribut en BD : otherNames

     */
    protected Collection<String> otherNames;
    /**
     * Nom de l'attribut en BD : gender

     */
    protected Gender gender;
    /**
     * Nom de l'attribut en BD : otherGender

     */
    protected Gender otherGender;
    /**
     * Nom de l'attribut en BD : address

     */
    protected Address address;
    /**
     * Nom de l'attribut en BD : title

     */
    protected Collection<Title> title;
    private static final long serialVersionUID = 7364566692353290854L;

static {
    
        I18n.n_("topia.test.common.personne");
        I18n.n_("topia.test.common.name");
        I18n.n_("topia.test.common.otherNames");
        I18n.n_("topia.test.common.gender");
        I18n.n_("topia.test.common.otherGender");
        I18n.n_("topia.test.common.address");
        I18n.n_("topia.test.common.title");
    }
     /**
      * accept :
      * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
      * @param visitor le visiteur de l'entite.
      * @throws TopiaException
      */
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_OTHER_NAMES, Collection.class, String.class, otherNames);
        visitor.visit(this, PROPERTY_GENDER, Gender.class, gender);
        visitor.visit(this, PROPERTY_OTHER_GENDER, Gender.class, otherGender);
        visitor.visit(this, PROPERTY_ADDRESS, Address.class, address);
        visitor.visit(this, PROPERTY_TITLE, Collection.class, Title.class, title);
        visitor.end(this);
}

     /**
      * setName :
      * @param name 
      */

    @Override    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
}

     /**
      * getName :
      * @return String 
      */

    @Override    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
}

     /**
      * addOtherNames :
      * @param otherNames 
      */

    @Override    public void addOtherNames(String otherNames) {
        fireOnPreWrite(PROPERTY_OTHER_NAMES, null, otherNames);
        if (this.otherNames == null) {
            this.otherNames = new ArrayList<String>();
        }

        this.otherNames.add(otherNames);
        fireOnPostWrite(PROPERTY_OTHER_NAMES, this.otherNames.size(), null, otherNames);
}

     /**
      * addAllOtherNames :
      * @param otherNames 
      */

    @Override    public void addAllOtherNames(Collection<String> otherNames) {
        if (otherNames == null) {
            return;
        }
        for (String item : otherNames) {
            addOtherNames(item);
        }
}

     /**
      * setOtherNames :
      * @param otherNames 
      */

    @Override    public void setOtherNames(Collection<String> otherNames) {
        // Copy elements to keep data for fire with new reference
        Collection<String> oldValue = this.otherNames != null ? new ArrayList<String>(this.otherNames) : null;
        fireOnPreWrite(PROPERTY_OTHER_NAMES, oldValue, otherNames);
        this.otherNames = otherNames;
        fireOnPostWrite(PROPERTY_OTHER_NAMES, oldValue, otherNames);
}

     /**
      * removeOtherNames :
      * @param otherNames 
      */

    @Override    public void removeOtherNames(String otherNames) {
        fireOnPreWrite(PROPERTY_OTHER_NAMES, otherNames, null);
        if ((this.otherNames == null) || (!this.otherNames.remove(otherNames))) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_OTHER_NAMES, this.otherNames.size() + 1, otherNames, null);
}

     /**
      * clearOtherNames :
      */

    @Override    public void clearOtherNames() {
        if (this.otherNames == null) {
            return;
        }
        Collection<String> oldValue = new ArrayList<String>(this.otherNames);
        fireOnPreWrite(PROPERTY_OTHER_NAMES, oldValue, this.otherNames);
        this.otherNames.clear();
        fireOnPostWrite(PROPERTY_OTHER_NAMES, oldValue, this.otherNames);
}

     /**
      * getOtherNames :
      * @return Collection<String> 
      */

    @Override    public Collection<String> getOtherNames() {
        return otherNames;
}

     /**
      * sizeOtherNames :
      * @return int 
      */

    @Override    public int sizeOtherNames() {
        if (otherNames == null) {
            return 0;
        }
        return otherNames.size();
}

     /**
      * isOtherNamesEmpty :
      * @return boolean 
      */

    @Override    public boolean isOtherNamesEmpty() {
        int size = sizeOtherNames();
        return size == 0;
}

     /**
      * setGender :
      * @param gender 
      */

    @Override    public void setGender(Gender gender) {
        Gender oldValue = this.gender;
        fireOnPreWrite(PROPERTY_GENDER, oldValue, gender);
        this.gender = gender;
        fireOnPostWrite(PROPERTY_GENDER, oldValue, gender);
}

     /**
      * getGender :
      * @return Gender 
      */

    @Override    public Gender getGender() {
        fireOnPreRead(PROPERTY_GENDER, gender);
        Gender result = this.gender;
        fireOnPostRead(PROPERTY_GENDER, gender);
        return result;
}

     /**
      * setOtherGender :
      * @param otherGender 
      */

    @Override    public void setOtherGender(Gender otherGender) {
        Gender oldValue = this.otherGender;
        fireOnPreWrite(PROPERTY_OTHER_GENDER, oldValue, otherGender);
        this.otherGender = otherGender;
        fireOnPostWrite(PROPERTY_OTHER_GENDER, oldValue, otherGender);
}

     /**
      * getOtherGender :
      * @return Gender 
      */

    @Override    public Gender getOtherGender() {
        fireOnPreRead(PROPERTY_OTHER_GENDER, otherGender);
        Gender result = this.otherGender;
        fireOnPostRead(PROPERTY_OTHER_GENDER, otherGender);
        return result;
}

     /**
      * setAddress :
      * @param address 
      */

    @Override    public void setAddress(Address address) {
        Address oldValue = this.address;
        fireOnPreWrite(PROPERTY_ADDRESS, oldValue, address);
        this.address = address;
        fireOnPostWrite(PROPERTY_ADDRESS, oldValue, address);
}

     /**
      * getAddress :
      * @return Address 
      */

    @Override    public Address getAddress() {
        fireOnPreRead(PROPERTY_ADDRESS, address);
        Address result = this.address;
        fireOnPostRead(PROPERTY_ADDRESS, address);
        return result;
}

     /**
      * addTitle :
      * @param title 
      */

    @Override    public void addTitle(Title title) {
        fireOnPreWrite(PROPERTY_TITLE, null, title);
        if (this.title == null) {
            this.title = new ArrayList<Title>();
        }

        this.title.add(title);
        fireOnPostWrite(PROPERTY_TITLE, this.title.size(), null, title);
}

     /**
      * addAllTitle :
      * @param title 
      */

    @Override    public void addAllTitle(Collection<Title> title) {
        if (title == null) {
            return;
        }
        for (Title item : title) {
            addTitle(item);
        }
}

     /**
      * setTitle :
      * @param title 
      */

    @Override    public void setTitle(Collection<Title> title) {
        // Copy elements to keep data for fire with new reference
        Collection<Title> oldValue = this.title != null ? new ArrayList<Title>(this.title) : null;
        fireOnPreWrite(PROPERTY_TITLE, oldValue, title);
        this.title = title;
        fireOnPostWrite(PROPERTY_TITLE, oldValue, title);
}

     /**
      * removeTitle :
      * @param title 
      */

    @Override    public void removeTitle(Title title) {
        fireOnPreWrite(PROPERTY_TITLE, title, null);
        if ((this.title == null) || (!this.title.remove(title))) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_TITLE, this.title.size() + 1, title, null);
}

     /**
      * clearTitle :
      */

    @Override    public void clearTitle() {
        if (this.title == null) {
            return;
        }
        Collection<Title> oldValue = new ArrayList<Title>(this.title);
        fireOnPreWrite(PROPERTY_TITLE, oldValue, this.title);
        this.title.clear();
        fireOnPostWrite(PROPERTY_TITLE, oldValue, this.title);
}

     /**
      * getTitle :
      * @return Collection<Title> 
      */

    @Override    public Collection<Title> getTitle() {
        return title;
}

     /**
      * sizeTitle :
      * @return int 
      */

    @Override    public int sizeTitle() {
        if (title == null) {
            return 0;
        }
        return title.size();
}

     /**
      * isTitleEmpty :
      * @return boolean 
      */

    @Override    public boolean isTitleEmpty() {
        int size = sizeTitle();
        return size == 0;
}

     /**
      * getAggregate :
      * @return List<TopiaEntity> 
      * @throws TopiaException
      */

    @Override    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

     /**
      * getComposite :
      * @return List<TopiaEntity> 
      * @throws TopiaException
      */

    @Override    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

     /**
      * toString :
      * @return String 
      */

    @Override    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_OTHER_NAMES, this.otherNames).
            append(PROPERTY_GENDER, this.gender).
            append(PROPERTY_OTHER_GENDER, this.otherGender).
            append(PROPERTY_ADDRESS, this.address).
            append(PROPERTY_TITLE, this.title).
         toString();
        return result;
}


} //PersonneAbstract
