package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public  abstract class NaturalizedEntityDAOAbstract<E extends NaturalizedEntity> extends TopiaDAOImpl<E> implements TopiaDAO<E> {


     /**
      * getEntityClass :
      * @return Class<E> 
      */
    public Class<E> getEntityClass() {
        return (Class<E>)NaturalizedEntity.class;
    }

     /**
      * delete :
      * @param entity 
      * @throws TopiaException
      */
    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

     /**
      * findByNaturalId :
      * @param naturalIdNotNull 
      * @param naturalIdNull 
      * @return E 
      * @throws TopiaException
      */
    public E findByNaturalId(Integer naturalIdNotNull, String naturalIdNull) throws TopiaException {
        return findByProperties(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull);
    }

     /**
      * existByNaturalId :
      * @param naturalIdNotNull 
      * @param naturalIdNull 
      * @return boolean 
      * @throws TopiaException
      */
    public boolean existByNaturalId(Integer naturalIdNotNull, String naturalIdNull) throws TopiaException {
        return existByProperties(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull);
    }

     /**
      * create :
      * @param naturalIdNotNull 
      * @param naturalIdNull 
      * @return E 
      * @throws TopiaException
      */
    public E create(Integer naturalIdNotNull, String naturalIdNull) throws TopiaException {
        return create(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull);
    }

     /**
      * findByNaturalIdNotNull :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut naturalIdNotNull le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByNaturalIdNotNull(Integer v) throws TopiaException {
        E result = findByProperty(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, v);
        return result;
    }

     /**
      * findAllByNaturalIdNotNull :
      * Retourne les éléments ayant comme valeur pour l'attribut naturalIdNotNull le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByNaturalIdNotNull(Integer v) throws TopiaException {
        List<E> result = findAllByProperty(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, v);
        return result;
    }

     /**
      * findByNaturalIdNull :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut naturalIdNull le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByNaturalIdNull(String v) throws TopiaException {
        E result = findByProperty(NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, v);
        return result;
    }

     /**
      * findAllByNaturalIdNull :
      * Retourne les éléments ayant comme valeur pour l'attribut naturalIdNull le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByNaturalIdNull(String v) throws TopiaException {
        List<E> result = findAllByProperty(NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, v);
        return result;
    }

     /**
      * findUsages :
      * @param type 
      * @param entity 
      * @return <U extends TopiaEntity> List<U> 
      * @throws TopiaException
      */

    @Override    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

     /**
      * findAllUsages :
      * @param entity 
      * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
      * @throws TopiaException
      */

    @Override    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }


} //NaturalizedEntityDAOAbstract<E extends NaturalizedEntity>
