package org.nuiton.topiatest;

import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;

public interface Department extends TopiaEntity {

     String PROPERTY_NAME = "name";
     String PROPERTY_LEADER = "leader";
     String PROPERTY_COMPANY = "company";
     String PROPERTY_PRODUCT = "product";

     /**
      * setName :
      * @param name La valeur de l'attribut à positionner.
      */
     void setName(String name);

     /**
      * getName :
      * @return String 
      */
     String getName();

     /**
      * setLeader :
      * @param leader La valeur de l'attribut à positionner.
      */
     void setLeader(Employe leader);

     /**
      * getLeader :
      * @return Employe 
      */
     Employe getLeader();

     /**
      * setCompany :
      * @param company La valeur de l'attribut à positionner.
      */
     void setCompany(Company company);

     /**
      * getCompany :
      * @return Company 
      */
     Company getCompany();

     /**
      * addProduct :
      * @param product L'instance de org.nuiton.topiatest.Product à ajouter
      */
     void addProduct(Product product);

     /**
      * addAllProduct :
      * @param product Les instances de org.nuiton.topiatest.Product à ajouter
      */
     void addAllProduct(Collection<Product> product);

     /**
      * setProduct :
      * @param product La valeur de l'attribut à positionner.
      */
     void setProduct(Collection<Product> product);

     /**
      * removeProduct :
      * @param product L'instance de org.nuiton.topiatest.Product à retirer
      */
     void removeProduct(Product product);

     /**
      * clearProduct :
      */
     void clearProduct();

     /**
      * getProduct :
      * Retourne la collection.
      * @return Collection<Product> 
      */
     Collection<Product> getProduct();

     /**
      * getProductByTopiaId :
      * Recupère l'attribut product à partir de son topiaId
      * @param topiaId le topia id de l'entité recherchée
      * @return Product 
      */
     Product getProductByTopiaId(String topiaId);

     /**
      * sizeProduct :
      * Retourne le nombre d'éléments de la collection product
      * @return int 
      */
     int sizeProduct();

     /**
      * isProductEmpty :
      * Retourne {@code true} si la collection product est vide.
      * @return boolean 
      */
     boolean isProductEmpty();


} //Department
