/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.ArrayList;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.validator.ObjectModelValidator;

public class TopiaJavaValidator
extends ObjectModelValidator {
    public TopiaJavaValidator(ObjectModel model) {
        super(model);
    }

    protected boolean validateAttribute(ObjectModelAttribute attr) {
        boolean isValid = super.validateAttribute(attr);
        if (attr.getType() == null || attr.getType().isEmpty()) {
            isValid = false;
            this.addError((ObjectModelElement)attr, "Invalid type \"" + attr.getType() + "\"");
        }
        if (!TopiaJavaValidator.isJavaIdentifier(attr.getName())) {
            isValid = false;
            this.addError((ObjectModelElement)attr, "Attribute name " + attr.getName() + " is not valid java identifier");
        }
        return isValid;
    }

    protected boolean validateClass(ObjectModelClass clazz) {
        boolean isValid = super.validateClass(clazz);
        ArrayList<String> attributesName = new ArrayList<String>();
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attributesName.contains(attr.getName())) {
                this.addError((ObjectModelElement)attr, "Attribute name " + attr.getName() + " already exists");
                isValid = false;
                continue;
            }
            attributesName.add(attr.getName());
        }
        return isValid;
    }

    protected boolean validateModel(ObjectModel model) {
        return super.validateModel(model);
    }

    public static boolean isJavaIdentifier(String s) {
        if (s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

