package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public  abstract class QueriedEntityAbstract extends TopiaEntityAbstract implements QueriedEntity {

    /**
     * Nom de l'attribut en BD : testAdd

     */
    protected String testAdd;
static {
    
        I18n.n_("topia.test.common.queriedEntity");
        I18n.n_("topia.test.common.testAdd");
    }
    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_TEST_ADD, String.class, testAdd);
        visitor.end(this);
}

    /**
     * setTestAdd :
     * @param testAdd 
     */

    @Override
    public void setTestAdd(String testAdd) {
        String oldValue = this.testAdd;
        fireOnPreWrite(PROPERTY_TEST_ADD, oldValue, testAdd);
        this.testAdd = testAdd;
        fireOnPostWrite(PROPERTY_TEST_ADD, oldValue, testAdd);
}

    /**
     * getTestAdd :
     * @return String 
     */

    @Override
    public String getTestAdd() {
        fireOnPreRead(PROPERTY_TEST_ADD, testAdd);
        String result = this.testAdd;
        fireOnPostRead(PROPERTY_TEST_ADD, testAdd);
        return result;
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_TEST_ADD, this.testAdd).
         toString();
        return result;
}


} //QueriedEntityAbstract
