package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topiatest.deletetest.Party2Impl;


public  abstract class PersonneAbstract extends Party2Impl implements Personne {

    protected String name;
    protected Collection<String> otherNames;
    protected boolean gender;
    protected Address address;
static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.personne");
    org.nuiton.i18n.I18n.n_("topia.test.common.name");
    org.nuiton.i18n.I18n.n_("topia.test.common.otherNames");
    org.nuiton.i18n.I18n.n_("topia.test.common.gender");
    org.nuiton.i18n.I18n.n_("topia.test.common.address");
    }
    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_OTHER_NAMES, Collection.class, String.class, otherNames);
        visitor.visit(this, PROPERTY_GENDER, boolean.class, gender);
        visitor.visit(this, PROPERTY_ADDRESS, Address.class, address);
        visitor.end(this);
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
}

    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
}

    /**
     * addOtherNames :
     * @param otherNames 
     */

    @Override
    public void addOtherNames(String otherNames) {
        fireOnPreWrite(PROPERTY_OTHER_NAMES, null, otherNames);
        if (this.otherNames == null) {
            this.otherNames = new ArrayList<String>();
        }

        this.otherNames.add(otherNames);
        fireOnPostWrite(PROPERTY_OTHER_NAMES, this.otherNames.size(), null, otherNames);
}

    /**
     * addAllOtherNames :
     * @param otherNames 
     */

    @Override
    public void addAllOtherNames(Collection<String> otherNames) {
        if (otherNames == null) {
            return;
        }
        for (String item : otherNames) {
            addOtherNames(item);
        }
}

    /**
     * setOtherNames :
     * @param otherNames 
     */

    @Override
    public void setOtherNames(Collection<String> otherNames) {
        // Copy elements to keep data for fire with new reference
        Collection<String> oldValue = this.otherNames != null ? new ArrayList<String>(this.otherNames) : null;
        fireOnPreWrite(PROPERTY_OTHER_NAMES, oldValue, otherNames);
        this.otherNames = otherNames;
        fireOnPostWrite(PROPERTY_OTHER_NAMES, oldValue, otherNames);
}

    /**
     * removeOtherNames :
     * @param otherNames 
     */

    @Override
    public void removeOtherNames(String otherNames) {
        fireOnPreWrite(PROPERTY_OTHER_NAMES, otherNames, null);
        if ((this.otherNames == null) || (!this.otherNames.remove(otherNames))) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_OTHER_NAMES, this.otherNames.size() + 1, otherNames, null);
}

    /**
     * clearOtherNames :
     */

    @Override
    public void clearOtherNames() {
        if (this.otherNames == null) {
            return;
        }
        Collection<String> oldValue = new ArrayList<String>(this.otherNames);
        fireOnPreWrite(PROPERTY_OTHER_NAMES, oldValue, this.otherNames);
        this.otherNames.clear();
        fireOnPostWrite(PROPERTY_OTHER_NAMES, oldValue, this.otherNames);
}

    /**
     * getOtherNames :
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getOtherNames() {
        return otherNames;
}

    /**
     * sizeOtherNames :
     * @return int 
     */

    @Override
    public int sizeOtherNames() {
        if (otherNames == null) {
            return 0;
        }
        return otherNames.size();
}

    /**
     * isOtherNamesEmpty :
     * @return boolean 
     */

    @Override
    public boolean isOtherNamesEmpty() {
        int size = sizeOtherNames();
        return size == 0;
}

    /**
     * setGender :
     * @param gender 
     */

    @Override
    public void setGender(boolean gender) {
        boolean oldValue = this.gender;
        fireOnPreWrite(PROPERTY_GENDER, oldValue, gender);
        this.gender = gender;
        fireOnPostWrite(PROPERTY_GENDER, oldValue, gender);
}

    /**
     * getGender :
     * @return boolean 
     */

    @Override
    public boolean getGender() {
        fireOnPreRead(PROPERTY_GENDER, gender);
        boolean result = this.gender;
        fireOnPostRead(PROPERTY_GENDER, gender);
        return result;
}

    /**
     * isGender :
     * @return boolean 
     */

    @Override
    public boolean isGender() {
        fireOnPreRead(PROPERTY_GENDER, gender);
        boolean result = this.gender;
        fireOnPostRead(PROPERTY_GENDER, gender);
        return result;
}

    /**
     * setAddress :
     * @param address 
     */

    @Override
    public void setAddress(Address address) {
        Address oldValue = this.address;
        fireOnPreWrite(PROPERTY_ADDRESS, oldValue, address);
        this.address = address;
        fireOnPostWrite(PROPERTY_ADDRESS, oldValue, address);
}

    /**
     * getAddress :
     * @return Address 
     */

    @Override
    public Address getAddress() {
        fireOnPreRead(PROPERTY_ADDRESS, address);
        Address result = this.address;
        fireOnPostRead(PROPERTY_ADDRESS, address);
        return result;
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_OTHER_NAMES, this.otherNames).
            append(PROPERTY_GENDER, this.gender).
            append(PROPERTY_ADDRESS, this.address).
         toString();
        return result;
}


} //PersonneAbstract
