package org.nuiton.topiatest.deletetest;

import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;


public interface Party2 extends TopiaEntity {     String CONTACTS = "contacts";
    /**
     * addContacts :
     * @param contacts L'instance de contacts à ajouter
     */

     void addContacts(Contact2 contacts);

    /**
     * addAllContacts :
     * @param contacts Les instances de contacts à ajouter
     */

     void addAllContacts(Collection<Contact2> contacts);

    /**
     * setContacts :
     * @param contacts La Collection de contacts à ajouter
     */

     void setContacts(Collection<Contact2> contacts);

    /**
     * removeContacts :
     * @param contacts Vide la Collection de contacts
     */

     void removeContacts(Contact2 contacts);

    /**
     * clearContacts :
     */

     void clearContacts();

    /**
     * getContacts :
     * @return Collection<Contact2> 
     */

     Collection<Contact2> getContacts();

    /**
     * getContactsByTopiaId :
     * Recupère l'attribut contacts à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Contact2 
     */

     Contact2 getContactsByTopiaId(String topiaId);

    /**
     * sizeContacts :
     * Retourne le nombre d'éléments de la collection contacts
     * @return int 
     */

     int sizeContacts();

    /**
     * isContactsEmpty :
     * Retourne {@code true} si la collection contacts est vide.
     * @return boolean 
     */

     boolean isContactsEmpty();


} //Party2
