package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class NaturalizedEntityAbstract extends TopiaEntityAbstract implements NaturalizedEntity {

    protected Integer naturalIdNotNull;
    protected String naturalIdNull;
    /**
     * getNaturalIdNotNull :
     * @return Integer 
     */

    public Integer getNaturalIdNotNull() {
        fireOnPreRead(NATURAL_ID_NOT_NULL, naturalIdNotNull);
        java.lang.Integer result = this.naturalIdNotNull;
        fireOnPostRead(NATURAL_ID_NOT_NULL, naturalIdNotNull);
        return result;
}

    /**
     * getNaturalIdNull :
     * @return String 
     */

    public String getNaturalIdNull() {
        fireOnPreRead(NATURAL_ID_NULL, naturalIdNull);
        java.lang.String result = this.naturalIdNull;
        fireOnPostRead(NATURAL_ID_NULL, naturalIdNull);
        return result;
}

    /**
     * update :
     * @deprecated since 2.3.4, use the DAO api instead.
     * @throws TopiaException
     */

    @Deprecated
    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(NaturalizedEntity.class).update(this);
}

    /**
     * delete :
     * @deprecated since 2.3.4, use the DAO api instead.
     * @throws TopiaException
     */

    @Deprecated
    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(NaturalizedEntity.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NATURAL_ID_NOT_NULL, Integer.class, naturalIdNotNull);
        visitor.visit(this, NATURAL_ID_NULL, String.class, naturalIdNull);
        visitor.end(this);
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * setNaturalIdNotNull :
     * @param value 
     */

    public void setNaturalIdNotNull(Integer value) {
        Integer _oldValue = this.naturalIdNotNull;
        fireOnPreWrite(NATURAL_ID_NOT_NULL, _oldValue, value);
        this.naturalIdNotNull = value;
        fireOnPostWrite(NATURAL_ID_NOT_NULL, _oldValue, value);
}

    /**
     * setNaturalIdNull :
     * @param value 
     */

    public void setNaturalIdNull(String value) {
        String _oldValue = this.naturalIdNull;
        fireOnPreWrite(NATURAL_ID_NULL, _oldValue, value);
        this.naturalIdNull = value;
        fireOnPostWrite(NATURAL_ID_NULL, _oldValue, value);
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NATURAL_ID_NOT_NULL, this.naturalIdNotNull).
            append(NATURAL_ID_NULL, this.naturalIdNull).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.naturalizedEntity");
    org.nuiton.i18n.I18n.n_("topia.test.common.naturalIdNotNull");
    org.nuiton.i18n.I18n.n_("topia.test.common.naturalIdNull");
    }

} //NaturalizedEntityAbstract
