package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class EmployeAbstract extends PersonneImpl implements Employe {

    protected int salary;
    /**
     * getSalary :
     * @return int 
     */

    public int getSalary() {
        fireOnPreRead(SALARY, salary);
        int result = this.salary;
        fireOnPostRead(SALARY, salary);
        return result;
}

    /**
     * update :
     * @deprecated since 2.3.4, use the DAO api instead.
     * @throws TopiaException
     */

    @Deprecated
    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Employe.class).update(this);
}

    /**
     * delete :
     * @deprecated since 2.3.4, use the DAO api instead.
     * @throws TopiaException
     */

    @Deprecated
    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Employe.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, SALARY, int.class, salary);
        visitor.end(this);
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * setSalary :
     * @param value 
     */

    public void setSalary(int value) {
        int _oldValue = this.salary;
        fireOnPreWrite(SALARY, _oldValue, value);
        this.salary = value;
        fireOnPostWrite(SALARY, _oldValue, value);
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(SALARY, this.salary).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.employe");
    org.nuiton.i18n.I18n.n_("topia.test.common.salary");
    }

} //EmployeAbstract
