/* *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

/*{generator option: parentheses = true}*/
/*{generator option: writeString = output.write}*/

/**
 * InterfaceGenerator.java
 *
 * Created: 12 déc. 2005
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 * @version $Revision: 1732 $
 *
 * Mise a jour: $Date: 2009-12-20 17:29:38 +0100 (dim. 20 déc. 2009) $
 * par : $Author: tchemit $
 * @deprecated since 2.3.0, use {@link org.nuiton.topia.generator.InterfaceTransformer} instead
 */

package org.nuiton.topia.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.*;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Set;


/**
 *
 * @deprecated since 2.3.0, prefer use the corresponding {@link org.nuiton.eugene.Transformer} :
 * {@link InterfaceTransformer}.
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.InterfaceGenerator" 
 */
@Deprecated
public class InterfaceGenerator extends ObjectModelGenerator { //InterfaceGenerator

    /** Logger for this class */
    private static final Log log = LogFactory.getLog(InterfaceGenerator.class);

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + ".java";
    }

    @Override
    public String getFilenameForInterface(ObjectModelInterface interfacez) {
        return interfacez.getQualifiedName().replace('.', File.separatorChar) + ".java";
    }

    @Override
    public void generateFromInterface(Writer output, ObjectModelInterface interfacez) throws IOException {
        if (!interfacez.getStereotypes().isEmpty()) {
            // can only generate an interface with there is no other stereotypes
            return;
        }

        // log
        if (log.isDebugEnabled()) {
            log.debug("Generating interface for : " + interfacez.getName());
        }

        String interfacezName = interfacez.getName();

        generateInterfaceHeader(output, interfacez);

        generateInterfaceOperations(output, interfacez);

/*{} //<%=interfacezName%>
}*/
    }

    private void generateInterfaceHeader(Writer output, ObjectModelInterface interfacez) throws IOException {
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
/*{<%=copyright%>
}*/
        }
/*{package <%=interfacez.getPackageName()%>;

}*/
        if (TopiaGeneratorUtil.hasDocumentation(interfacez)) {
        	String documentation = interfacez.getDocumentation();
/*{
/**
 * <%=documentation%>
 *)
}*/
        }
        String interfacezName = interfacez.getName();
/*{public interface <%=interfacezName%> }*/
        String extendClass = "";
        if (!interfacez.getInterfaces().isEmpty()) {
            for (ObjectModelClassifier parent : interfacez.getInterfaces()) {
                extendClass += parent.getQualifiedName();
                extendClass += ", ";
            }
            if (log.isTraceEnabled()) {
                log.trace("Interface : " + extendClass);
            }

/*{ extends <%=extendClass%> {

}*/
        }
/*{ {
}*/
    }

    private void generateInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelOperation op : classifier.getOperations()) {
/*{    /**
}*/
            if (TopiaGeneratorUtil.hasDocumentation(op)) {
            	String documentation = op.getDocumentation();
/*{     * <%=documentation%>
}*/
            }
            Collection<ObjectModelParameter> params = op.getParameters();
            for (ObjectModelParameter param : params) {
                if (log.isTraceEnabled()) {
                    log.trace("Param" + param);
                }
                String paramName = param.getName();
                String paramDocumentation = param.getDocumentation();
/*{     * @param <%=paramName%> <%=paramDocumentation%>
 }*/
            }
            String opVisibility = op.getVisibility();
            String opType = op.getReturnType();
            String opName = op.getName();
/*{     *)
    <%=opVisibility%> <%=opType%> <%=opName%>(}*/
            String comma = "";
            for (ObjectModelParameter param : params) {
                if (log.isTraceEnabled()) {
                    log.trace("Param" + param + " comma" + comma);
                }
                String paramName = param.getName();
                String paramType = param.getType();
/*{<%=comma%><%=paramType%> <%=paramName%>}*/
                comma = ", ";
            }
/*{)}*/
            Set<String> exceptions = op.getExceptions();
            comma = " throws ";
            for (String exception : exceptions) {
                if (log.isTraceEnabled()) {
                    log.trace("exception" + exception + " vir" + comma);
                }
/*{<%=comma%><%=exception%>}*/
                comma = ", ";
            }
/*{;

}*/
        }
    }

} //InterfaceGenerator
